/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.SsoServerSiteMapEntry;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SsoServerSiteMapEntryImpl
extends SsoServerSiteMapEntry {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerSiteMapEntryImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init();
    }

    private void init() {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
    }

    public ObjectName createSsoServerSiteMapEntryObjectName(MBeanServer server) {
        String classModule = "SsoServerSiteMapEntryImpl.createSsoServerSiteMapEntryObjectName: ";
        String prfx = "ssoServerSiteMapEntry.";
        if (debug.messageEnabled()) {
            debug.message(classModule + "\n    SsoServerSiteMapIndex = " + this.SsoServerSiteMapIndex + "\n    SsoServerMapId = " + this.SsoServerMapId + "\n    SsoServerSiteMapId = " + this.SsoServerSiteMapId + "\n    SsoServerMapServerURL = " + this.SsoServerMapServerURL + "\n    SsoServerMapSiteName = " + this.SsoServerMapSiteName);
        }
        String host = null;
        String path = null;
        int port = 0;
        try {
            URL url = new URL(this.SsoServerMapServerURL);
            host = url.getHost();
            port = url.getPort();
            path = url.getPath();
        }
        catch (MalformedURLException mue) {
            debug.error(classModule + "invalid URL: " + this.SsoServerMapServerURL + "; " + mue.getMessage());
            return null;
        }
        String objname = myMibName + "/ssoServerSiteMapTable:" + prfx + "ssoServerMapServerHost=" + host + "," + prfx + "ssoServerMapServerPort=" + port + "," + prfx + "ssoServerMapServerPath=" + path;
        try {
            if (server == null) {
                return null;
            }
            return new ObjectName(objname);
        }
        catch (Exception ex) {
            debug.error(classModule + objname, (Throwable)ex);
            return null;
        }
    }
}

