/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerSvcMgmtSvc;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import java.util.Collection;
import javax.management.MBeanServer;

public class SsoServerSvcMgmtSvcImpl
extends SsoServerSvcMgmtSvc {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerSvcMgmtSvcImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerSvcMgmtSvcImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        String classMethod = "SsoServerSvcMgmtSvcImpl.init:";
        boolean dsEmbedded = Agent.getDsIsEmbedded();
        String dirSSL = SystemProperties.get("com.iplanet.am.directory.ssl.enabled");
        String dsType = "embedded";
        if (!dsEmbedded) {
            dsType = "remote";
        }
        try {
            DSConfigMgr dscm = DSConfigMgr.getDSConfigMgr();
            ServerGroup sgrp = dscm.getServerGroup("sms");
            Collection slist = sgrp.getServersList();
            StringBuffer sbp1 = new StringBuffer("DSConfigMgr:\n");
            int port = 0;
            String svr = null;
            for (Server sobj : slist) {
                svr = sobj.getServerName();
                port = sobj.getPort();
                if (!debug.messageEnabled()) continue;
                sbp1.append("  svrname = ").append(svr).append(", port = ").append(port).append("\n");
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + sbp1.toString());
            }
            ServerInstance si = dscm.getServerInstance(LDAPUser.Type.AUTH_BASIC);
            String bindDN = si.getAuthID();
            String orgDN = si.getBaseDN();
            boolean siStat = si.getActiveStatus();
            String conntype = si.getConnectionType().toString();
            if (debug.messageEnabled()) {
                sbp1 = new StringBuffer("ServerInstance:\n");
                sbp1.append("  bindDN = ").append(bindDN).append("\n").append("  orgDN = ").append(orgDN).append("\n").append("  active status = ").append(siStat).append("\n").append("  conn type = ").append(conntype).append("\n");
                debug.message(classMethod + sbp1.toString());
            }
            this.SsoServerSvcMgmtRepositoryType = dsType;
            this.SsoServerSvcMgmtStatus = "operational";
            if (!siStat) {
                this.SsoServerSvcMgmtStatus = "dormant";
            }
            this.SsoServerSvcMgmtRepositorySSL = dirSSL;
            this.SsoServerSvcMgmtRepositoryOrgDN = orgDN;
            this.SsoServerSvcMgmtRepositoryBindDN = bindDN;
            String portS = "0";
            try {
                portS = Integer.toString(port);
            }
            catch (NumberFormatException nex) {
                debug.error(classMethod + "port retrieved invalid (" + port + ": " + nex.getMessage());
            }
            this.SsoServerSvcMgmtRepositoryHostPort = portS;
        }
        catch (Exception d) {
            debug.error(classMethod + "trying to get Directory Server Config");
        }
    }
}

