/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Conditions {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private String name;
    private String description;
    private Map conditions = new HashMap();
    private static String CONDITIONS_ELEMENT_BEGIN = "<Conditions name=\"";
    private static String CONDITIONS_DESCRIPTION = "\" description=\"";
    private static String CONDITIONS_ELEMENT_END = "</Conditions>";
    private static String CONDITION_ELEMENT = "<Condition name=\"";
    private static String CONDITION_TYPE = "\" type=\"";
    private static String CONDITION_ELEMENT_END = "</Condition>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_PAIR_BEGIN = "<AttributeValuePair>";
    private static String ATTR_NAME_BEGIN = "<Attribute name=";
    private static String ATTR_NAME_END = "/>";
    private static String ATTR_VALUE_PAIR_END = "</AttributeValuePair>";

    Conditions() {
    }

    protected Conditions(ConditionTypeManager ctm, Node conditionsNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        if (!conditionsNode.getNodeName().equalsIgnoreCase("Conditions")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid conditions xml blob given to construct conditions");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_conditions_root_node", null, "", 6);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)conditionsNode, (String)"name");
        if (this.name == null) {
            this.name = "Conditions:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)conditionsNode, (String)"description")) == null) {
            this.description = "";
        }
        for (Node conditionNode : XMLUtils.getChildNodes((Node)conditionsNode, (String)"Condition")) {
            String conditionType = XMLUtils.getNodeAttributeValue((Node)conditionNode, (String)"type");
            if (conditionType == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("condition type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_conditions_root_node", null, "", 6);
            }
            Condition condition = ctm.getCondition(conditionType);
            HashMap<String, Set> properties = new HashMap<String, Set>();
            NodeList attrValuePairNodes = conditionNode.getChildNodes();
            int numAttrValuePairNodes = attrValuePairNodes.getLength();
            for (int j = 0; j < numAttrValuePairNodes; ++j) {
                Node attrValuePairNode = attrValuePairNodes.item(j);
                Node attributeNode = XMLUtils.getChildNode((Node)attrValuePairNode, (String)"Attribute");
                if (attributeNode == null) continue;
                String name = XMLUtils.getNodeAttributeValue((Node)attributeNode, (String)"name");
                Set values = XMLUtils.getAttributeValuePair((Node)attrValuePairNode);
                if (name == null || values == null) continue;
                properties.put(name, values);
            }
            condition.setProperties(properties);
            String conditionName = XMLUtils.getNodeAttributeValue((Node)conditionNode, (String)"name");
            this.addCondition(conditionName, condition);
        }
    }

    public Conditions(String name, String description) {
        this.name = name == null ? "Conditions:" + ServiceTypeManager.generateRandomName() : name;
        this.description = description == null ? "" : description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name == null ? "Conditions:" + ServiceTypeManager.generateRandomName() : name;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public Set getConditionNames() {
        return this.conditions.keySet();
    }

    public Condition getCondition(String conditionName) throws NameNotFoundException {
        Condition answer = (Condition)this.conditions.get(conditionName);
        if (answer == null) {
            Object[] objs = new String[]{conditionName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, conditionName, 6);
        }
        return answer;
    }

    public void addCondition(Condition condition) throws NameAlreadyExistsException {
        this.addCondition(null, condition);
    }

    public void addCondition(String conditionName, Condition condition) throws NameAlreadyExistsException {
        if (conditionName == null) {
            conditionName = "Condition:" + ServiceTypeManager.generateRandomName();
        }
        if (this.conditions.containsKey(conditionName)) {
            Object[] objs = new String[]{conditionName};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objs, conditionName, 6);
        }
        this.conditions.put(conditionName, condition);
    }

    public void replaceCondition(String conditionName, Condition condition) throws NameNotFoundException {
        if (!this.conditions.containsKey(conditionName)) {
            Object[] objs = new String[]{conditionName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, conditionName, 6);
        }
        this.conditions.put(conditionName, condition);
    }

    public Condition removeCondition(String conditionName) {
        return (Condition)this.conditions.remove(conditionName);
    }

    public Condition removeCondition(Condition condition) {
        String conditionName = this.getConditionName(condition);
        if (conditionName != null) {
            return this.removeCondition(conditionName);
        }
        return null;
    }

    public String getConditionName(Condition condition) {
        String answer = null;
        for (String conditionName : this.conditions.keySet()) {
            if (!condition.equals(this.conditions.get(conditionName))) continue;
            answer = conditionName;
            break;
        }
        return answer;
    }

    public boolean equals(Object o) {
        if (o instanceof Conditions) {
            Conditions s = (Conditions)o;
            Iterator iter = this.conditions.entrySet().iterator();
            while (iter.hasNext()) {
                Object ss = iter.next().getValue();
                if (s.conditions.containsValue(ss)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        Conditions answer = null;
        try {
            answer = (Conditions)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new Conditions();
        }
        answer.name = this.name;
        answer.description = this.description;
        answer.conditions = new HashMap();
        for (Object item : this.conditions.keySet()) {
            Condition condition = (Condition)this.conditions.get(item);
            answer.conditions.put(item, condition.clone());
        }
        return answer;
    }

    public boolean isAllowed(SSOToken token, Map env) throws PolicyException, SSOException {
        return this.getConditionDecision(token, env).isAllowed();
    }

    ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = false;
        HashMap<String, Boolean> allowMap = new HashMap<String, Boolean>();
        HashMap advicesMap = new HashMap();
        long timeToLive = Long.MAX_VALUE;
        Iterator items = this.conditions.entrySet().iterator();
        while (items.hasNext()) {
            long ttl;
            ConditionDecision cd;
            boolean currentAllowed;
            Condition condition = (Condition)items.next().getValue();
            String conditionType = ConditionTypeManager.conditionTypeName(condition);
            boolean previousAllowed = false;
            Boolean previousValue = (Boolean)allowMap.get(conditionType);
            if (previousValue != null) {
                previousAllowed = previousValue;
            }
            currentAllowed = (currentAllowed = (cd = condition.getConditionDecision(token, env)).isAllowed()) || previousAllowed;
            allowMap.put(conditionType, currentAllowed);
            Map cdAdvices = cd.getAdvices();
            if (cdAdvices != null && !cdAdvices.isEmpty()) {
                HashMap advices = (HashMap)advicesMap.get(conditionType);
                if (advices == null) {
                    advices = new HashMap();
                    advicesMap.put(conditionType, advices);
                }
                PolicyUtils.appendMapToMap(cdAdvices, (Map)advicesMap.get(conditionType));
            }
            if ((ttl = cd.getTimeToLive()) >= timeToLive) continue;
            timeToLive = ttl;
        }
        HashMap effectiveAdvices = new HashMap();
        if (!allowMap.containsValue(Boolean.FALSE)) {
            allowed = true;
        } else {
            for (String conditionType : advicesMap.keySet()) {
                Boolean result = (Boolean)allowMap.get(conditionType);
                if (!result.equals(Boolean.FALSE)) continue;
                PolicyUtils.appendMapToMap((Map)advicesMap.get(conditionType), effectiveAdvices);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At Conditions.getConditionDecision():allowed,timeToLive,  advices=" + allowed + "," + timeToLive + "," + effectiveAdvices);
        }
        return new ConditionDecision(allowed, timeToLive, effectiveAdvices);
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\n").append(CONDITIONS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(CONDITIONS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        for (String conditionName : this.conditions.keySet()) {
            Condition condition = (Condition)this.conditions.get(conditionName);
            sb.append("\n").append(CONDITION_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)conditionName)).append(CONDITION_TYPE).append(XMLUtils.escapeSpecialCharacters((String)ConditionTypeManager.conditionTypeName(condition))).append("\">");
            Map properties = condition.getProperties();
            if (properties != null) {
                Set keySet = properties.keySet();
                Iterator keys = keySet.iterator();
                while (keys.hasNext()) {
                    sb.append("\n").append(ATTR_VALUE_PAIR_BEGIN);
                    String key = (String)keys.next();
                    sb.append(ATTR_NAME_BEGIN);
                    sb.append(this.quote(XMLUtils.escapeSpecialCharacters((String)key)));
                    sb.append(ATTR_NAME_END);
                    Set valueSet = (Set)properties.get(key);
                    if (valueSet != null && !valueSet.isEmpty()) {
                        for (String value : valueSet) {
                            sb.append(VALUE_BEGIN);
                            sb.append(XMLUtils.escapeSpecialCharacters((String)value));
                            sb.append(VALUE_END);
                        }
                    }
                    sb.append("\n").append(ATTR_VALUE_PAIR_END);
                }
            }
            sb.append("\n").append(CONDITION_ELEMENT_END);
        }
        sb.append("\n").append(CONDITIONS_ELEMENT_END);
        return sb.toString();
    }

    private String quote(String s) {
        String str = null;
        str = s == null ? "\"\"" : "\"" + s + "\"";
        return str;
    }

    int size() {
        return this.conditions.size();
    }
}

