/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyListenerRequest
implements PolicyListener {
    static final String POLICY_LISTENER = "AddPolicyListener";
    static final String SERVICE_NAME = "serviceName";
    static final String NOTIFICATION_URL = "notificationURL";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String notificationURL = null;
    private String serviceName = null;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getNotificationURL() {
        return this.notificationURL;
    }

    public void setNotificationURL(String url) {
        this.notificationURL = url;
    }

    public static PolicyListenerRequest parseXML(Node pNode) throws PolicyEvaluationException {
        PolicyListenerRequest policyListenerReq = new PolicyListenerRequest();
        String attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)SERVICE_NAME);
        if (attr == null) {
            debug.error("PolicyListenerRequest: missing attribute serviceName");
            Object[] objs = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        policyListenerReq.setServiceName(attr);
        attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)NOTIFICATION_URL);
        if (attr == null) {
            debug.error("PolicyListenerRequest: missing attribute notificationURL");
            Object[] objs = new String[]{NOTIFICATION_URL};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        policyListenerReq.setNotificationURL(attr);
        return policyListenerReq;
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(100);
        xmlsb.append("<AddPolicyListener serviceName=\"" + this.serviceName + "\" " + NOTIFICATION_URL + "=" + "\"" + this.notificationURL + "\"/>" + CRLF);
        return xmlsb.toString();
    }

    public String getServiceTypeName() {
        return this.serviceName;
    }

    public void policyChanged(PolicyEvent evt) {
        debug.message("PolicyListenerRequest.policyChanged()");
        if (evt == null) {
            debug.error("PolicyListenerRequest.policyChanged(PolicyEvent): invalid policy event");
            return;
        }
        String changeType = null;
        int type = evt.getChangeType();
        changeType = type == 1 ? "added" : (type == 2 ? "deleted" : "modified");
        Set resourceNames = evt.getResourceNames();
        if (debug.messageEnabled()) {
            debug.message("PolicyListenerRequest.policyChanged(PolicyEvent): resource names from the policy event : " + resourceNames.toString());
        }
        PolicyService ps = new PolicyService();
        PolicyNotification pn = new PolicyNotification();
        PolicyChangeNotification pcn = new PolicyChangeNotification();
        pcn.setResourceNames(resourceNames);
        pcn.setPolicyChangeType(changeType);
        pcn.setServiceName(this.serviceName);
        pn.setNotificationType(1);
        pn.setPolicyChangeNotification(pcn);
        ps.setMethodID(3);
        ps.setPolicyNotification(pn);
        Notification notification = new Notification(ps.toXMLString());
        NotificationSet set = new NotificationSet("policy");
        set.addNotification(notification);
        if (debug.messageEnabled()) {
            debug.message("PolicyListenerRequest.policyChanged(PolicyEvent): the notification set sent is : " + set.toXMLString());
        }
        try {
            PLLServer.send(new URL(this.notificationURL), set);
            if (debug.messageEnabled()) {
                debug.message("PolicyListenerRequest.policyChanged(PolicyEvent): the policy change notification has been sent to " + this.notificationURL);
            }
        }
        catch (SendNotificationException e) {
            debug.error("PolicyListenerRequest.policyChanged(): PLLServer.send() failed", (Throwable)e);
        }
        catch (MalformedURLException e) {
            debug.error("PolicyListenerRequest.policyChanged(): PLLServer.send() failed", (Throwable)e);
        }
    }
}

