/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.remote.AdvicesHandleableByAMResponse;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyResponse {
    public static final int POLICY_RESPONSE_RESOURCE_RESULT = 1;
    public static final int POLICY_ADD_LISTENER_RESPONSE = 2;
    public static final int POLICY_REMOVE_LISTENER_RESPONSE = 3;
    public static final int POLICY_EXCEPTION = 4;
    public static final int POLICY_ADVICES_HANDLEABLE_BY_AM_RESPONSE = 5;
    public static final String APP_SSO_TOKEN_INVALID = "Application sso token is invalid";
    static final String POLICY_RESPONSE = "PolicyResponse";
    static final String REQUEST_ID = "requestId";
    static final String ISSUE_INSTANT = "issueInstant";
    static final String RESOURCE_RESULT = "ResourceResult";
    static final String ADD_LISTENER_RESPONSE = "AddPolicyListenerResponse";
    static final String REMOVE_LISTENER_RESPONSE = "RemovePolicyListenerResponse";
    static final String ADVICES_HANDLEABLE_BY_AM_RESPONSE = "AdvicesHandleableByAMResponse";
    static final String EXCEPTION_RESPONSE = "Exception";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private int methodID = 0;
    private long issueInstant = 0L;
    private String requestId = null;
    private Set resourceResults = null;
    private AdvicesHandleableByAMResponse advicesHandleableByAMResponse = null;
    private String exceptionMsg = null;

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int id) {
        this.methodID = id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String reqId) {
        this.requestId = reqId;
    }

    public long getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(long issueInst) {
        this.issueInstant = issueInst;
    }

    public Set getResourceResults() {
        return this.resourceResults;
    }

    public void setResourceResults(Set set) {
        this.resourceResults = set;
    }

    public AdvicesHandleableByAMResponse getAdvicesHandleableByAMResponse() {
        return this.advicesHandleableByAMResponse;
    }

    public void setAdvicesHandleableByAMResponse(AdvicesHandleableByAMResponse advicesHandleableByAMResponse) {
        this.advicesHandleableByAMResponse = advicesHandleableByAMResponse;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void setExceptionMsg(String exMsg) {
        this.exceptionMsg = exMsg;
    }

    public static PolicyResponse parseXML(Node pNode) throws PolicyEvaluationException {
        Set nodeSet;
        PolicyResponse pres = new PolicyResponse();
        Node node2 = null;
        String attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)REQUEST_ID);
        if (attr == null) {
            debug.error("PolicyResponse: missing attribute requestId");
            Object[] objs = new String[]{REQUEST_ID};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        pres.setRequestId(attr);
        String issueInst = XMLUtils.getNodeAttributeValue((Node)pNode, (String)ISSUE_INSTANT);
        if (issueInst != null && issueInst.length() != 0) {
            try {
                pres.setIssueInstant(Long.parseLong(issueInst));
            }
            catch (NumberFormatException nfe) {
                if (debug.warningEnabled()) {
                    debug.message("PolicyResponse: invald value for attribute:issueInstant:" + issueInst);
                }
            }
        } else if (debug.messageEnabled()) {
            debug.message("PolicyResponse: missing attribute: issueInstant");
        }
        if ((nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)RESOURCE_RESULT)) != null && nodeSet.size() != 0) {
            HashSet<ResourceResult> resResults = new HashSet<ResourceResult>();
            for (Node node2 : nodeSet) {
                ResourceResult rRes = null;
                try {
                    rRes = ResourceResult.parseResourceResult(node2);
                }
                catch (Exception e) {
                    debug.error("PolicyResponse: XML parsing error");
                    throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, e);
                }
                resResults.add(rRes);
            }
            pres.setResourceResults(resResults);
            pres.setMethodID(1);
            return pres;
        }
        node2 = XMLUtils.getChildNode((Node)pNode, (String)ADD_LISTENER_RESPONSE);
        if (node2 != null) {
            pres.setMethodID(2);
            return pres;
        }
        node2 = XMLUtils.getChildNode((Node)pNode, (String)REMOVE_LISTENER_RESPONSE);
        if (node2 != null) {
            pres.setMethodID(3);
            return pres;
        }
        node2 = XMLUtils.getChildNode((Node)pNode, (String)ADVICES_HANDLEABLE_BY_AM_RESPONSE);
        if (node2 != null) {
            pres.setAdvicesHandleableByAMResponse(AdvicesHandleableByAMResponse.parseXML(node2));
            pres.setMethodID(5);
            return pres;
        }
        node2 = XMLUtils.getChildNode((Node)pNode, (String)EXCEPTION_RESPONSE);
        if (node2 != null) {
            String eMsg = XMLUtils.getValueOfValueNode((Node)node2);
            pres.setExceptionMsg(eMsg);
            pres.setMethodID(4);
            return pres;
        }
        debug.error("PolicyResponse: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_response_method", null, null);
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(1000);
        xmlsb.append("<").append(POLICY_RESPONSE).append(" ").append(REQUEST_ID).append("=\"").append(this.requestId).append("\" ");
        if (this.issueInstant != 0L) {
            xmlsb.append(ISSUE_INSTANT).append("=\"").append(this.issueInstant).append("\" ");
        }
        xmlsb.append(">").append(CRLF);
        if (this.methodID == 1) {
            for (ResourceResult rRes : this.resourceResults) {
                xmlsb.append(rRes.toXML());
            }
        } else if (this.methodID == 2) {
            xmlsb.append("<").append(ADD_LISTENER_RESPONSE).append("/>").append(CRLF);
        } else if (this.methodID == 3) {
            xmlsb.append("<").append(REMOVE_LISTENER_RESPONSE).append("/>").append(CRLF);
        } else if (this.methodID == 5) {
            xmlsb.append(this.advicesHandleableByAMResponse.toXMLString());
        } else if (this.methodID == 4) {
            xmlsb.append("<").append(EXCEPTION_RESPONSE).append(">").append(CRLF);
            xmlsb.append(this.exceptionMsg).append(CRLF);
            xmlsb.append("</").append(EXCEPTION_RESPONSE).append(">").append(CRLF);
        }
        xmlsb.append("</").append(POLICY_RESPONSE).append(">").append(CRLF);
        return xmlsb.toString();
    }
}

