/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.session.util;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.shared.encode.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RestrictedTokenContext {
    private static ThreadLocal currentContext = new ThreadLocal();
    private static final String OBJECT_PREFIX = "object:";
    private static final String TOKEN_PREFIX = "token:";

    public static Object getCurrent() {
        return currentContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doUsing(Object context, RestrictedTokenAction action) throws Exception {
        Object savedContext = currentContext.get();
        try {
            currentContext.set(context);
            Object object = action.run();
            return object;
        }
        finally {
            currentContext.set(savedContext);
        }
    }

    public static String marshal(Object context) throws Exception {
        if (context instanceof SSOToken) {
            return TOKEN_PREFIX + ((Object)((SSOToken)context).getTokenID()).toString();
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bs);
        os.writeObject(context);
        os.flush();
        os.close();
        return OBJECT_PREFIX + Base64.encode((byte[])bs.toByteArray());
    }

    public static Object unmarshal(String data) throws Exception {
        if (data.startsWith(TOKEN_PREFIX)) {
            return SSOTokenManager.getInstance().createSSOToken(data.substring(TOKEN_PREFIX.length()));
        }
        if (data.startsWith(OBJECT_PREFIX)) {
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)data.substring(OBJECT_PREFIX.length()))));
            return is.readObject();
        }
        throw new IllegalArgumentException("Bad context value:" + data);
    }
}

