/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.shared.StringUtils;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class RegisterServices {
    private static final List serviceNames = new ArrayList();
    private static final String umEmbeddedDS;
    private static final String IDREPO_SUB_CONFIG_MARKER = "<SubConfiguration name=\"@IDREPO_DATABASE@\" id=\"@IDREPO_DATABASE@\" />";
    private static final String IDREPO_SUB_CONFIG = "<SubConfiguration name=\"files\" id=\"files\"><AttributeValuePair><Attribute name=\"sunIdRepoClass\" /><Value>com.sun.identity.idm.plugins.files.FilesRepo</Value></AttributeValuePair><AttributeValuePair><Attribute name=\"sunFilesIdRepoDirectory\" /><Value>@BASE_DIR@/@SERVER_URI@/idRepo</Value></AttributeValuePair></SubConfiguration>";

    public void registers(SSOToken adminToken, boolean bUseExtUMDS) throws IOException, SMSException, SSOException {
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        String dirXML = basedir + "/config/xml";
        new File(dirXML).mkdirs();
        for (String serviceFileName : serviceNames) {
            boolean tagswap = true;
            if (serviceFileName.startsWith("*")) {
                serviceFileName = serviceFileName.substring(1);
                tagswap = false;
            }
            Object[] params = new Object[]{serviceFileName};
            SetupProgress.reportStart("emb.registerservice", params);
            String strXML = this.getResourceContent(serviceFileName);
            if (tagswap) {
                strXML = ServicesDefaultValues.tagSwap(strXML, true);
            }
            AMSetupServlet.writeToFile(dirXML + "/" + serviceFileName, strXML);
            this.registerService(strXML, adminToken);
            SetupProgress.reportEnd("emb.success", null);
        }
        if (!bUseExtUMDS) {
            this.addSubConfigForEmbeddedDS(adminToken);
        }
    }

    private void addSubConfigForEmbeddedDS(SSOToken adminSSOToken) throws SSOException, SMSException, IOException {
        Map data = ServicesDefaultValues.getDefaultValues();
        String xml = this.getResourceContent(umEmbeddedDS);
        xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_CONFIG_ROOT_SUFFIX@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("SM_CONFIG_ROOT_SUFFIX"))));
        xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DIRECTORY_SERVER@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("DIRECTORY_SERVER"))));
        xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DIRECTORY_PORT@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("DIRECTORY_PORT"))));
        xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DS_DIRMGRDN@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("DS_DIRMGRDN"))));
        xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DS_DIRMGRPASSWD@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("DS_DIRMGRPASSWD"))));
        this.registerService(xml, adminSSOToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(String xml, SSOToken adminSSOToken) throws SSOException, SMSException, IOException {
        ServiceManager serviceManager = new ServiceManager(adminSSOToken);
        ByteArrayInputStream serviceStream = null;
        try {
            serviceStream = new ByteArrayInputStream(xml.getBytes());
            serviceManager.registerServices(serviceStream);
        }
        finally {
            if (serviceStream != null) {
                ((InputStream)serviceStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceContent(String resName) throws IOException {
        BufferedReader rawReader = null;
        String content = null;
        try {
            rawReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resName)));
            StringBuffer buff = new StringBuffer();
            String line = null;
            while ((line = rawReader.readLine()) != null) {
                buff.append(line).append("\n");
            }
            rawReader.close();
            rawReader = null;
            content = buff.toString();
        }
        finally {
            if (rawReader != null) {
                rawReader.close();
            }
        }
        return content;
    }

    private String manipulateServiceXML(String serviceFileName, String strXML) {
        if (serviceFileName.equals("idRepoService.xml")) {
            strXML = StringUtils.strReplaceAll((String)strXML, (String)IDREPO_SUB_CONFIG_MARKER, (String)IDREPO_SUB_CONFIG);
        }
        return strXML;
    }

    static {
        ResourceBundle rb = ResourceBundle.getBundle("serviceNames");
        String names = rb.getString("serviceNames");
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            serviceNames.add(st.nextToken());
        }
        umEmbeddedDS = rb.getString("umEmbeddedDS");
    }
}

