/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPUtils;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.shared.StringUtils;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

class UserIdRepo {
    private static final String umSunDSForAM;
    private static final String umSunDSGeneric;
    private static UserIdRepo instance;

    private UserIdRepo() {
    }

    public static UserIdRepo getInstance() {
        return instance;
    }

    void configure(Map userRepo, String basedir, ServletContext servletCtx, SSOToken adminToken) throws Exception {
        String type = (String)userRepo.get("userStoreType");
        if (type == null) {
            type = "LDAPv3ForSUNDS";
        }
        ResourceBundle rb = ResourceBundle.getBundle("schemaNames");
        String strFiles = rb.getString("sundsSchema");
        if (type.equals("LDAPv3ForSUNDS")) {
            this.loadSchema(userRepo, basedir, servletCtx, strFiles);
        } else if (type.equals("LDAPv3ForOpenDS")) {
            strFiles = rb.getString("opendsUserSchema");
            this.loadSchema(userRepo, basedir, servletCtx, strFiles);
        } else if (type.equals("LDAPv3ForAD")) {
            strFiles = rb.getString("adUserSchema");
            this.loadSchema(userRepo, basedir, servletCtx, strFiles);
        } else if (type.equals("LDAPv3ForTivoli")) {
            strFiles = rb.getString("tivoliUserSchema");
            this.loadSchema(userRepo, basedir, servletCtx, strFiles);
        }
        this.addSubConfig(userRepo, type, adminToken);
    }

    private void addSubConfig(Map userRepo, String type, SSOToken adminToken) throws SMSException, SSOException, IOException {
        String xml = null;
        xml = type.equals("LDAPv3ForSUNDS") ? this.getResourceContent(umSunDSForAM) : this.getResourceContent(umSunDSGeneric);
        if (xml != null) {
            Map data = ServicesDefaultValues.getDefaultValues();
            xml = StringUtils.strReplaceAll((String)xml, (String)"@SM_CONFIG_ROOT_SUFFIX@", (String)XMLUtils.escapeSpecialCharacters((String)((String)data.get("SM_CONFIG_ROOT_SUFFIX"))));
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_CONFIG_ROOT_SUFFIX@", (String)XMLUtils.escapeSpecialCharacters((String)((String)userRepo.get("userStoreRootSuffix"))));
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DIRECTORY_SERVER@", (String)XMLUtils.escapeSpecialCharacters((String)UserIdRepo.getHost(userRepo)));
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DIRECTORY_PORT@", (String)XMLUtils.escapeSpecialCharacters((String)UserIdRepo.getPort(userRepo)));
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DS_DIRMGRDN@", (String)XMLUtils.escapeSpecialCharacters((String)UserIdRepo.getBindDN(userRepo)));
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_DS_DIRMGRPASSWD@", (String)XMLUtils.escapeSpecialCharacters((String)UserIdRepo.getBindPassword(userRepo)));
            String s = (String)userRepo.get("userStoreSSL");
            String ssl = s != null && s.equals("SSL") ? "true" : "false";
            xml = StringUtils.strReplaceAll((String)xml, (String)"@UM_SSL@", (String)ssl);
            this.registerService(xml, adminToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(String xml, SSOToken adminSSOToken) throws SSOException, SMSException, IOException {
        ServiceManager serviceManager = new ServiceManager(adminSSOToken);
        ByteArrayInputStream serviceStream = null;
        try {
            serviceStream = new ByteArrayInputStream(xml.getBytes());
            serviceManager.registerServices(serviceStream);
        }
        finally {
            if (serviceStream != null) {
                ((InputStream)serviceStream).close();
            }
        }
    }

    static ServiceConfig getOrgConfig(SSOToken adminToken) throws SMSException, SSOException {
        ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminToken);
        ServiceConfig cfg = svcCfgMgr.getOrganizationConfig("", null);
        HashMap<String, Set> values = new HashMap<String, Set>();
        if (cfg == null) {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminToken, "/");
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", adminToken);
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            Set attrs = orgSchema.getAttributeSchemas();
            for (AttributeSchema as : attrs) {
                values.put(as.getName(), as.getDefaultValues());
            }
            cfg = orgCfgMgr.addServiceConfig("sunIdentityRepositoryService", values);
        }
        return cfg;
    }

    static String getHost(Map userRepo) {
        return (String)userRepo.get("userStoreHostName");
    }

    static String getPort(Map userRepo) {
        return (String)userRepo.get("userStorePort");
    }

    static String getBindDN(Map userRepo) {
        return (String)userRepo.get("userStoreLoginID");
    }

    static String getBindPassword(Map userRepo) {
        return (String)userRepo.get("userStoreLoginPassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchema(Map userRepo, String basedir, ServletContext servletCtx, String strFiles) throws Exception {
        LDAPConnection ld = null;
        try {
            ld = this.getLDAPConnection(userRepo);
            String dbName = this.getDBName(userRepo, ld);
            List schemas = this.writeSchemaFiles(basedir, dbName, servletCtx, strFiles, userRepo);
            for (String file : schemas) {
                Object[] params = new Object[]{file};
                SetupProgress.reportStart("emb.loadingschema", params);
                LDAPUtils.createSchemaFromLDIF(file, ld);
                SetupProgress.reportEnd("emb.success", null);
                File f = new File(file);
                f.delete();
            }
        }
        finally {
            this.disconnectDServer(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List writeSchemaFiles(String basedir, String dbName, ServletContext servletCtx, String strFiles, Map userRepo) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            int len;
            String file = st.nextToken();
            InputStreamReader fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(servletCtx, file));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
            OutputStreamWriter fout = null;
            try {
                int idx = file.lastIndexOf("/");
                String absFile = idx != -1 ? file.substring(idx + 1) : file;
                String outfile = basedir + "/" + absFile;
                fout = new FileWriter(outfile);
                String inpStr = sbuf.toString();
                inpStr = StringUtils.strReplaceAll((String)inpStr, (String)"@DB_NAME@", (String)dbName);
                String suffix = (String)userRepo.get("userStoreRootSuffix");
                if (suffix != null) {
                    inpStr = StringUtils.strReplaceAll((String)inpStr, (String)"@userStoreRootSuffix@", (String)suffix);
                }
                fout.write(ServicesDefaultValues.tagSwap(inpStr));
                files.add(outfile);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
                if (fout == null) continue;
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceContent(String resName) throws IOException {
        BufferedReader rawReader = null;
        String content = null;
        try {
            rawReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resName)));
            StringBuffer buff = new StringBuffer();
            String line = null;
            while ((line = rawReader.readLine()) != null) {
                buff.append(line);
            }
            rawReader.close();
            rawReader = null;
            content = buff.toString();
        }
        finally {
            if (rawReader != null) {
                rawReader.close();
            }
        }
        return content;
    }

    private void disconnectDServer(LDAPConnection ld) throws LDAPException {
        if (ld != null && ld.isConnected()) {
            ld.disconnect();
        }
    }

    private LDAPConnection getLDAPConnection(Map userRepo) throws Exception {
        String s = (String)userRepo.get("userStoreSSL");
        boolean ssl = s != null && s.equals("SSL");
        LDAPConnection ld = ssl ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
        ld.setConnectTimeout(300);
        int port = Integer.parseInt(UserIdRepo.getPort(userRepo));
        ld.connect(3, UserIdRepo.getHost(userRepo), port, UserIdRepo.getBindDN(userRepo), UserIdRepo.getBindPassword(userRepo));
        return ld;
    }

    private String getDBName(Map userRepo, LDAPConnection ld) throws LDAPException {
        String suffix = (String)userRepo.get("userStoreRootSuffix");
        return LDAPUtils.getDBName(suffix, ld);
    }

    static {
        instance = new UserIdRepo();
        ResourceBundle rb = ResourceBundle.getBundle("serviceNames");
        umSunDSForAM = rb.getString("umSunDSForAM");
        umSunDSGeneric = rb.getString("umSunDSGeneric");
    }
}

