/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeSchema {
    private static Debug debug = SMSEntry.debug;
    ServiceSchemaManager ssm;
    ServiceSchema ss;
    PluginSchema ps;
    AttributeSchemaImpl as;
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String DEFAULT_VALUES_BEGIN = "<DefaultValues>";
    private static final String DEFAULT_VALUES_END = "</DefaultValues>";
    static final String VALUE_BEGIN = "<Value>";
    static final String VALUE_END = "</Value>";
    private static final String CHOICE_VALUES_BEGIN = "<ChoiceValues>";
    private static final String CHOICE_VALUES_END = "</ChoiceValues>";
    private static final String CHOICE_VALUE_KEY = "<ChoiceValue i18nKey=\"{0}\">{1}</ChoiceValue>";
    private static final String CHOICE_VALUE = "<ChoiceValue>{0}</ChoiceValue>";
    private static final String BOOLEAN_VALUES_BEGIN = "<BooleanValues>";
    private static final String BOOLEAN_VALUES_END = "</BooleanValues>";
    private static final String TRUE_BOOLEAN_KEY = "<BooleanTrueValue i18nKey=\"{0}\">{1}</BooleanTrueValue>";
    private static final String FALSE_BOOLEAN_KEY = "<BooleanFalseValue i18nKey=\"{0}\">{1}</BooleanFalseValue>";

    private AttributeSchema() {
    }

    protected AttributeSchema(AttributeSchemaImpl as, ServiceSchemaManager ssm, ServiceSchema ss) {
        this.ssm = ssm;
        this.ss = ss;
        this.as = as;
        if (as == null) {
            debug.error("AttributeSchema:: IMPL is NULL");
        }
    }

    protected AttributeSchema(AttributeSchemaImpl as, PluginSchema ps) {
        this.as = as;
        this.ps = ps;
    }

    public String getName() {
        return this.as.getName();
    }

    public Type getType() {
        return this.as.getType();
    }

    public ServiceSchema getServiceSchema() {
        return this.ss;
    }

    public void setType(String type) throws SMSException, SSOException {
        this.updateXMLDocument("type", type);
    }

    public UIType getUIType() {
        return this.as.getUIType();
    }

    public void setUIType(String uiType) throws SMSException, SSOException {
        this.updateXMLDocument("uitype", uiType);
    }

    public Syntax getSyntax() {
        return this.as.getSyntax();
    }

    public void setSyntax(String synt) throws SMSException, SSOException {
        this.updateXMLDocument("syntax", synt);
    }

    public String getI18NKey() {
        return this.as.getI18NKey();
    }

    public void setI18NKey(String i18nKey) throws SMSException, SSOException {
        this.updateXMLDocument("i18nKey", i18nKey);
    }

    public String getCosQualifier() {
        return this.as.getCosQualifier();
    }

    public void setCosQualifier(String cosq) throws SMSException, SSOException {
        this.updateXMLDocument("cosQualifier", cosq);
    }

    public Set getDefaultValues() {
        return this.as.getDefaultValues();
    }

    public Set getDefaultValues(Map envParams) {
        return this.as.getDefaultValues(envParams);
    }

    public void setDefaultValues(Set values) throws SMSException, SSOException {
        this.updateDefaultValues(values);
    }

    void setDefaultValues(Set values, Document document) throws SMSException, SSOException {
        this.updateDefaultValues(values, document);
    }

    public void addDefaultValue(String value) throws SMSException, SSOException {
        HashSet<String> defaultValues = this.getDefaultValues();
        if (defaultValues != Collections.EMPTY_SET) {
            defaultValues.add(value);
        } else {
            defaultValues = new HashSet<String>();
            defaultValues.add(value);
        }
        this.updateDefaultValues(defaultValues);
    }

    public void removeDefaultValues() throws SMSException, SSOException {
        this.updateDefaultValues(new HashSet());
    }

    public void removeDefaultValue(String value) throws SMSException, SSOException {
        Set defaultValues = this.getDefaultValues();
        if (defaultValues != Collections.EMPTY_SET) {
            defaultValues.remove(value);
            this.updateDefaultValues(defaultValues);
        }
    }

    public String[] getChoiceValues() {
        return this.as.getChoiceValues();
    }

    public String[] getChoiceValues(Map envParams) {
        return this.as.getChoiceValues(envParams);
    }

    public String getChoiceValueI18NKey(String cValue) {
        return this.as.getChoiceValueI18NKey(cValue);
    }

    public void addChoiceValue(String value, String i18nKey) throws SMSException, SSOException {
        Map choiceValues = this.as.getChoiceValuesMap();
        choiceValues.put(value, i18nKey);
        this.updateChoiceValues(choiceValues);
    }

    public void removeChoiceValue(String value) throws SMSException, SSOException {
        Map choiceValues = this.as.getChoiceValuesMap();
        if (choiceValues.remove(value) != null) {
            this.updateChoiceValues(choiceValues);
        }
    }

    public String getStartRange() {
        return this.as.getStartRange();
    }

    public void setStartRange(String stRange) throws SMSException, SSOException {
        this.updateXMLDocument("rangeStart", stRange);
    }

    public String getEndRange() {
        return this.as.getEndRange();
    }

    public void setEndRange(String edRange) throws SMSException, SSOException {
        this.updateXMLDocument("rangeEnd", edRange);
    }

    public String getValidator() {
        return this.as.getValidator();
    }

    public void setValidator(String valid) throws SMSException, SSOException {
        this.updateXMLDocument("validator", valid);
    }

    public int getMinValue() {
        return this.as.getMinValue();
    }

    public void setMinValue(String minV) throws SMSException, SSOException {
        this.updateXMLDocument("minValue", minV);
    }

    public int getMaxValue() {
        return this.as.getMaxValue();
    }

    public void setMaxValue(String maxV) throws SMSException, SSOException {
        this.updateXMLDocument("maxValue", maxV);
    }

    public void setBooleanValues(String trueValue, String trueValueI18nKey, String falseValue, String falseValueI18nKey) throws SSOException, SMSException {
        this.updateBooleanValues(trueValue, trueValueI18nKey, falseValue, falseValueI18nKey, null);
    }

    public String getTrueValue() {
        return this.as.getTrueValue();
    }

    public String getTrueValueI18NKey() {
        return this.as.getTrueValueI18NKey();
    }

    public String getFalseValue() {
        return this.as.getFalseValue();
    }

    public String getFalseValueI18NKey() {
        return this.as.getFalseValueI18NKey();
    }

    public boolean isOptional() {
        return this.as.isOptional();
    }

    public boolean isServiceIdentifier() {
        return this.as.isServiceIdentifier();
    }

    public boolean isResourceNameAllowed() {
        return this.as.isResourceNameAllowed();
    }

    public boolean isStatusAttribute() {
        return this.as.isStatusAttribute();
    }

    public String getAny() {
        return this.as.getAny();
    }

    public void setAny(String a) throws SMSException, SSOException {
        this.updateXMLDocument("any", a);
    }

    public String getPropertiesViewBeanURL() {
        return this.as.getPropertiesViewBeanURL();
    }

    public void setPropertiesViewBeanUR(String prop) throws SMSException, SSOException {
        this.updateXMLDocument("propertiesViewBeanURL", prop);
    }

    public boolean isSearchable() {
        return this.as.isSearchable();
    }

    public void setSearchable(String value) throws SMSException, SSOException {
        if (!value.toLowerCase().equals("yes") && !value.toLowerCase().equals("no")) {
            String[] arg = new String[]{value};
            debug.error("AttributeSchema: Invalid isSearchable value");
            throw new SMSException(SMSEntry.bundle.getString("sms-invalid-searchable-value") + ":" + arg, "sms-invalid-searchable-value");
        }
        this.updateXMLDocument("isSearchable", value);
    }

    public String toString() {
        return this.as.toString();
    }

    protected void updateDefaultValues(Set defaultValues) throws SMSException, SSOException {
        this.updateDefaultValues(defaultValues, null);
    }

    protected void updateDefaultValues(Set defaultValues, Document doc) throws SMSException, SSOException {
        if (this.ss != null) {
            HashMap<String, Set> tempattrs = new HashMap<String, Set>(1);
            tempattrs.put(this.getName(), defaultValues);
            this.ss.validateAttributes(tempattrs);
        }
        boolean encode = false;
        if (this.getSyntax().equals(Syntax.PASSWORD) || this.getSyntax().equals(Syntax.ENCRYPTED_PASSWORD)) {
            encode = true;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(XML_PREFIX).append(DEFAULT_VALUES_BEGIN);
        Iterator items = defaultValues.iterator();
        while (items.hasNext()) {
            sb.append(VALUE_BEGIN);
            if (encode) {
                String encString = (String)items.next();
                try {
                    encString = (String)AccessController.doPrivileged(new EncodeAction(encString));
                }
                catch (Throwable e) {
                    debug.error("AttributeSchema: Unable to encode", e);
                }
                sb.append(encString);
            } else {
                sb.append(SMSSchema.escapeSpecialCharacters((String)items.next()));
            }
            sb.append(VALUE_END);
        }
        sb.append(DEFAULT_VALUES_END);
        this.updateXMLDocument(sb, "DefaultValues", doc);
    }

    protected void updateChoiceValues(Map choiceValues) throws SMSException, SSOException {
        this.updateChoiceValues(choiceValues, null);
    }

    protected void updateChoiceValues(Map choiceValues, Document doc) throws SMSException, SSOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append(XML_PREFIX).append(CHOICE_VALUES_BEGIN);
        Iterator items = choiceValues.keySet().iterator();
        while (items.hasNext()) {
            String[] vals = new String[2];
            String value = SMSSchema.escapeSpecialCharacters((String)items.next());
            String i18nKey = (String)choiceValues.get(value);
            if (i18nKey == null) {
                vals[0] = value;
                sb.append(MessageFormat.format(CHOICE_VALUE, vals));
                continue;
            }
            vals[0] = i18nKey;
            vals[1] = value;
            sb.append(MessageFormat.format(CHOICE_VALUE_KEY, vals));
        }
        sb.append(CHOICE_VALUES_END);
        this.updateXMLDocument(sb, "ChoiceValues", doc);
    }

    protected void updateBooleanValues(String trueValue, String trueValueI18nKey, String falseValue, String falseValueI18nKey, Document doc) throws SMSException, SSOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append(XML_PREFIX).append(BOOLEAN_VALUES_BEGIN);
        String[] trueVals = new String[2];
        if (trueValueI18nKey != null && trueValue != null) {
            trueVals[0] = trueValueI18nKey;
            trueVals[1] = SMSSchema.escapeSpecialCharacters(trueValue);
        } else {
            trueVals[0] = this.getTrueValueI18NKey();
            trueVals[1] = this.getTrueValue();
        }
        sb.append(MessageFormat.format(TRUE_BOOLEAN_KEY, trueVals));
        String[] falseVals = new String[2];
        if (falseValueI18nKey != null && falseValue != null) {
            falseVals[0] = falseValueI18nKey;
            falseVals[1] = SMSSchema.escapeSpecialCharacters(falseValue);
        } else {
            falseVals[0] = this.getFalseValueI18NKey();
            falseVals[1] = this.getFalseValue();
        }
        sb.append(MessageFormat.format(FALSE_BOOLEAN_KEY, falseVals));
        sb.append(BOOLEAN_VALUES_END);
        this.updateXMLDocument(sb, "BooleanValues", doc);
    }

    protected void updateXMLDocument(StringBuffer sb, String elementName, Document updateDoc) throws SMSException, SSOException {
        try {
            Node oNode;
            Document doc = SMSSchema.getXMLDocument(sb.toString(), false);
            Node node = XMLUtils.getRootNode((Document)doc, (String)elementName);
            Document schemaDoc = null;
            schemaDoc = updateDoc != null ? updateDoc : (this.ssm != null ? this.ssm.getDocumentCopy() : this.ps.getDocumentCopy());
            Node nNode = schemaDoc.importNode(node, true);
            Node schemaNode = null;
            schemaNode = this.ss != null ? this.ss.getSchemaNode(schemaDoc) : this.ps.getPluginSchemaNode(schemaDoc);
            Node attrSchemaNode = XMLUtils.getNamedChildNode((Node)schemaNode, (String)"AttributeSchema", (String)"name", (String)this.getName());
            if (attrSchemaNode == null) {
                schemaNode = this.ss.getOrgAttrSchemaNode(schemaDoc);
                attrSchemaNode = XMLUtils.getNamedChildNode((Node)schemaNode, (String)"AttributeSchema", (String)"name", (String)this.getName());
            }
            if ((oNode = XMLUtils.getChildNode((Node)attrSchemaNode, (String)elementName)) != null) {
                attrSchemaNode.replaceChild(nNode, oNode);
            } else {
                attrSchemaNode.appendChild(nNode);
            }
            if (updateDoc == null) {
                if (this.ssm != null) {
                    this.ssm.replaceSchema(schemaDoc);
                } else {
                    this.ps.replacePluginSchema(schemaDoc);
                }
            }
        }
        catch (Exception e) {
            throw new SMSException(e.getMessage(), e, "sms-cannot-update-xml-document");
        }
    }

    protected void updateXMLDocument(String attrName, String attrValue) throws SMSException, SSOException {
        try {
            Document schemaDoc = null;
            schemaDoc = this.ssm != null ? this.ssm.getDocumentCopy() : this.ps.getDocumentCopy();
            Node schemaNode = null;
            schemaNode = this.ss != null ? this.ss.getSchemaNode(schemaDoc) : this.ps.getPluginSchemaNode(schemaDoc);
            Node attrSchemaNode = XMLUtils.getNamedChildNode((Node)schemaNode, (String)"AttributeSchema", (String)"name", (String)this.getName());
            ((Element)attrSchemaNode).setAttribute(attrName, attrValue);
            if (this.ssm != null) {
                this.ssm.replaceSchema(schemaDoc);
            } else {
                this.ps.replacePluginSchema(schemaDoc);
            }
        }
        catch (Exception e) {
            throw new SMSException(e.getMessage(), e, "sms-cannot-update-xml-document");
        }
    }

    public static class Syntax {
        public static final Syntax BOOLEAN = new Syntax("boolean");
        public static final Syntax EMAIL = new Syntax("email");
        public static final Syntax URL = new Syntax("url");
        public static final Syntax STRING = new Syntax("string");
        public static final Syntax PARAGRAPH = new Syntax("paragraph");
        public static final Syntax XML = new Syntax("xml");
        public static final Syntax PASSWORD = new Syntax("password");
        public static final Syntax ENCRYPTED_PASSWORD = new Syntax("encrypted_password");
        public static final Syntax DATE = new Syntax("date");
        public static final Syntax NUMERIC = new Syntax("numeric");
        public static final Syntax NUMBER = new Syntax("number");
        public static final Syntax DECIMAL = new Syntax("decimal");
        public static final Syntax PERCENT = new Syntax("percent");
        public static final Syntax NUMBER_RANGE = new Syntax("number_range");
        public static final Syntax DECIMAL_RANGE = new Syntax("decimal_range");
        public static final Syntax DECIMAL_NUMBER = new Syntax("decimal_number");
        public static final Syntax DN = new Syntax("dn");
        private String attrSyntax;

        private Syntax() {
        }

        private Syntax(String syntax) {
            this.attrSyntax = syntax;
        }

        public String toString() {
            return this.attrSyntax;
        }

        public boolean equals(Object schemaAttrSyntax) {
            if (schemaAttrSyntax instanceof Syntax) {
                Syntax s = (Syntax)schemaAttrSyntax;
                return s.attrSyntax.equals(this.attrSyntax);
            }
            return false;
        }

        public int hashCode() {
            return this.attrSyntax.hashCode();
        }
    }

    public static class UIType {
        public static final UIType RADIO = new UIType("radio");
        public static final UIType LINK = new UIType("link");
        public static final UIType BUTTON = new UIType("button");
        public static final UIType NAME_VALUE_LIST = new UIType("name_value_list");
        public static final UIType UNORDEREDLIST = new UIType("unorderedlist");
        public static final UIType ORDEREDLIST = new UIType("orderedlist");
        public static final UIType MAPLIST = new UIType("maplist");
        public static final UIType GLOBALMAPLIST = new UIType("globalmaplist");
        public static final UIType ADDREMOVELIST = new UIType("addremovelist");
        private String attrType;

        private UIType() {
        }

        private UIType(String type) {
            this.attrType = type;
        }

        public String toString() {
            return this.attrType;
        }

        public boolean equals(Object schemaAttrType) {
            if (schemaAttrType instanceof UIType) {
                UIType s = (UIType)schemaAttrType;
                return s.attrType.equals(this.attrType);
            }
            return false;
        }

        public int hashCode() {
            return this.attrType.hashCode();
        }
    }

    public static class Type {
        public static final Type SINGLE = new Type("single");
        public static final Type LIST = new Type("list");
        public static final Type SINGLE_CHOICE = new Type("single_choice");
        public static final Type MULTIPLE_CHOICE = new Type("multiple_choice");
        public static final Type SIGNATURE = new Type("signature");
        public static final Type VALIDATOR = new Type("validator");
        private String attrType;

        private Type() {
        }

        private Type(String type) {
            this.attrType = type;
        }

        public String toString() {
            return this.attrType;
        }

        public boolean equals(Object schemaAttrType) {
            if (schemaAttrType instanceof Type) {
                Type s = (Type)schemaAttrType;
                return s.attrType.equals(this.attrType);
            }
            return false;
        }

        public int hashCode() {
            return this.attrType.hashCode();
        }
    }
}

