/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSThreadPool;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObject;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObjectImpl;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SMSNotificationManager
implements SMSObjectListener {
    private static SMSNotificationManager instance;
    private static Map changeListeners;
    private static SMSEventListenerManager internalEventListener;
    private static Debug debug;
    static final String AGENTGROUP_RDN = "ou=agentgroup,ou=Instances";
    static boolean enableDataStoreNotification;
    static boolean cachedEnabled;
    static boolean isClient;
    private static String serverURL;

    private SMSNotificationManager() {
        this.initializeProperties();
    }

    protected void initializeProperties() {
        boolean previousDataStoreNotification = enableDataStoreNotification;
        enableDataStoreNotification = Boolean.valueOf(SystemProperties.get("com.sun.identity.sm.enableDataStoreNotification"));
        boolean configTime = Boolean.valueOf(SystemProperties.get("installTime"));
        SMSObject object = SMSEntry.getSMSObject();
        isClient = object instanceof SMSJAXRPCObject;
        if (!isClient && !SystemProperties.isServerMode()) {
            enableDataStoreNotification = false;
        }
        if (!(isClient || enableDataStoreNotification || configTime || ServiceManager.isRealmEnabled())) {
            enableDataStoreNotification = true;
        }
        if (!(cachedEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.sdk.caching.enabled", "true")).booleanValue())) {
            cachedEnabled = Boolean.valueOf(SystemProperties.get("com.sun.identity.sm.cache.enabled", "false"));
        }
        if (debug.messageEnabled()) {
            debug.message("SMSNotificationManager.init DataStore Notification: " + enableDataStoreNotification + " CacheEnabled: " + cachedEnabled);
        }
        if (cachedEnabled && (enableDataStoreNotification || isClient) && previousDataStoreNotification != enableDataStoreNotification) {
            try {
                object.registerCallbackHandler(this);
                if (debug.messageEnabled()) {
                    debug.message("SMSNotificationManager.init Registered for notification with: " + object.getClass().getName());
                }
            }
            catch (SMSException ex) {
                debug.error("SMSNotificationManager.init Error during notification registration", (Throwable)ex);
            }
        } else if (previousDataStoreNotification != enableDataStoreNotification) {
            object.deregisterCallbackHandler(null);
            if (debug.messageEnabled()) {
                debug.message("SMSNotificationManager.init deregistering for notification with: " + object.getClass().getName());
            }
        }
    }

    protected synchronized void deregisterListener(SMSObject object) {
        if (enableDataStoreNotification) {
            object.deregisterCallbackHandler(null);
            enableDataStoreNotification = false;
        }
    }

    public static synchronized SMSNotificationManager getInstance() {
        if (instance == null) {
            instance = new SMSNotificationManager();
        }
        return instance;
    }

    public static boolean isCacheEnabled() {
        SMSNotificationManager.getInstance();
        return cachedEnabled;
    }

    public static boolean isDataStoreNotificationEnabled() {
        SMSNotificationManager.getInstance();
        return enableDataStoreNotification;
    }

    public String registerCallbackHandler(SMSObjectListener listener) {
        String id = SMSUtils.getUniqueID();
        if (listener instanceof SMSEventListenerManager) {
            internalEventListener = (SMSEventListenerManager)listener;
        } else {
            changeListeners.put(id, listener);
        }
        return id;
    }

    public void removeCallbackHandler(String id) {
        changeListeners.remove(id);
    }

    void localObjectChanged(String name, int type) {
        if (internalEventListener != null) {
            internalEventListener.objectChanged(name, type);
        }
        String configTime = SystemProperties.get("installTime", "false");
        boolean bConfigTime = configTime.equalsIgnoreCase("true");
        if (!cachedEnabled || isClient || !enableDataStoreNotification || bConfigTime) {
            LocalChangeNotifcationTask changes = new LocalChangeNotifcationTask(name, type, false);
            SMSThreadPool.scheduleTask(changes);
        }
    }

    public void objectChanged(String name, int type) {
        if (internalEventListener != null) {
            internalEventListener.objectChanged(name, type);
        }
        LocalChangeNotifcationTask changes = new LocalChangeNotifcationTask(name, type, true);
        SMSThreadPool.scheduleTask(changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotifications(String name, int type, boolean localOnly) {
        if (type == 0 && name.indexOf(AGENTGROUP_RDN) >= 0) {
            return;
        }
        String installTime = SystemProperties.get("installTime", "false");
        if (!(localOnly || enableDataStoreNotification || isClient || installTime.equals("true") || SystemProperties.isServerMode() && ServiceManager.getAMServerInstances().size() <= 1)) {
            ServerNotificationTask nt = new ServerNotificationTask(name, type);
            SMSThreadPool.scheduleTask(nt);
        }
        Set listenerIds = changeListeners.keySet();
        HashSet nlists = new HashSet();
        Map map = changeListeners;
        synchronized (map) {
            Iterator<Object> items = listenerIds.iterator();
            while (items.hasNext()) {
                nlists.add(changeListeners.get(items.next()));
            }
        }
        SMSObjectListener jaxrpclistener = null;
        for (SMSObjectListener listener : nlists) {
            try {
                if (listener instanceof SMSJAXRPCObjectImpl) {
                    jaxrpclistener = listener;
                    continue;
                }
                listener.objectChanged(name, type);
            }
            catch (Throwable t) {
                debug.error("SMSNotificationManager.objectChanged Exception for class: " + listener.getClass().getName(), t);
            }
        }
        if (jaxrpclistener != null) {
            try {
                jaxrpclistener.objectChanged(name, type);
            }
            catch (Throwable t) {
                debug.error("SMSNotificationManager.objectChanged Exception for JAXRPC class: " + jaxrpclistener.getClass().getName(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allObjectsChanged() {
        try {
            new ServiceManager((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance())).clearCache();
        }
        catch (SSOException ex) {
            debug.error("SMSNotificationManager.allObjectsChanged Invalid AdminSSOToken: ", (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            debug.error("SMSNotificationManager.allObjectsChanged SMSException in clearing cache: ", (Throwable)ex);
        }
        Set listenerIds = changeListeners.keySet();
        HashSet nlists = new HashSet();
        Map map = changeListeners;
        synchronized (map) {
            Iterator items = listenerIds.iterator();
            while (items.hasNext()) {
                nlists.add(changeListeners.get(items.next()));
            }
        }
        for (SMSObjectListener listener : nlists) {
            try {
                listener.allObjectsChanged();
            }
            catch (Throwable t) {
                debug.error("SMSNotificationManager.allObjectsChanged Exception for class: " + listener.getClass().getName(), t);
            }
        }
    }

    static {
        changeListeners = Collections.synchronizedMap(new HashMap());
        debug = Debug.getInstance((String)"amSMSEvent");
    }

    private class ServerNotificationTask
    implements Runnable {
        SSOToken adminSSOToken;
        String name;
        int type;

        ServerNotificationTask(String name, int type) {
            this.name = name;
            this.type = type;
            if (serverURL == null) {
                if (SystemProperties.isServerMode()) {
                    String namingURL = SystemProperties.get("com.iplanet.am.naming.url");
                    if (namingURL != null) {
                        int index = namingURL.toLowerCase().indexOf("/namingservice");
                        if (index != -1) {
                            serverURL = namingURL.substring(0, index).toLowerCase();
                        } else {
                            serverURL = "";
                        }
                    } else {
                        serverURL = SystemProperties.getServerInstanceName();
                        if (serverURL == null) {
                            serverURL = "";
                        } else {
                            serverURL = serverURL.toLowerCase();
                        }
                    }
                } else {
                    serverURL = "";
                }
            }
        }

        public void run() {
            block9: {
                if (this.type == 0 && (new StringTokenizer(this.name, ",").countTokens() <= SMSEntry.baseDNCount + 1 || this.name.indexOf(SMSNotificationManager.AGENTGROUP_RDN) >= 0)) {
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("ServerNotificationTask.run Sending notifications to servers. DN: " + this.name + " ChangeType: " + this.type);
                }
                try {
                    Iterator sl = ServiceManager.getAMServerInstances().iterator();
                    while (sl != null && sl.hasNext()) {
                        URL url = new URL((String)sl.next());
                        URL weburl = WebtopNaming.getServiceURL("jaxrpc", url, false);
                        String surl = weburl.toString();
                        if (serverURL.length() > 0 && surl.toLowerCase().startsWith(serverURL)) {
                            if (!debug.messageEnabled()) continue;
                            debug.message("ServerNotificationTask.run NOT sending notification to local server:" + surl);
                            continue;
                        }
                        surl = !surl.endsWith("/") ? surl + "/SMSObjectIF" : surl + "SMSObjectIF";
                        try {
                            SOAPClient client = new SOAPClient();
                            client.setURL(surl);
                            Object[] params = new Object[]{this.name, new Integer(this.type)};
                            if (debug.messageEnabled()) {
                                debug.message("ServerNotificationTask.run Sending to URL: " + surl);
                            }
                            client.send("notifyObjectChanged", params, null, null);
                        }
                        catch (Throwable t) {
                            if (!debug.errorEnabled()) continue;
                            debug.error("ServerNotificationTask.run Unable to send notification to: " + surl, t);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!debug.warningEnabled()) break block9;
                    debug.warning("ServerNotificationTask.run Unable to send notifications", t);
                }
            }
        }
    }

    private class LocalChangeNotifcationTask
    implements Runnable {
        String name;
        int type;
        boolean localOnly;

        private LocalChangeNotifcationTask(String name, int type, boolean localOnly) {
            this.name = name;
            this.type = type;
            this.localOnly = localOnly;
        }

        public void run() {
            instance.sendNotifications(this.name, this.type, this.localOnly);
        }
    }
}

