/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.sm.SMSDataEntry;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SearchResultIterator
implements Iterator {
    private LDAPSearchResults results;
    private Set excludeDNs;
    private boolean hasExcludeDNs;
    private SMSDataEntry current;

    public SearchResultIterator(LDAPSearchResults results, Set excludeDNs) {
        this.results = results;
        this.excludeDNs = excludeDNs;
        this.hasExcludeDNs = excludeDNs != null && !excludeDNs.isEmpty();
    }

    public boolean hasNext() {
        if (!this.results.hasMoreElements()) {
            return false;
        }
        try {
            LDAPEntry entry = this.results.next();
            String dn = entry.getDN();
            if (this.hasExcludeDNs) {
                while (this.excludeDNs.contains(dn)) {
                    if (this.results.hasMoreElements()) {
                        entry = this.results.next();
                        dn = entry.getDN();
                        continue;
                    }
                    entry = null;
                    break;
                }
            }
            this.current = entry == null ? null : new SMSDataEntry(dn, SearchResultIterator.convertLDAPAttributeSetToMap(entry.getAttributeSet()));
            return this.current != null;
        }
        catch (LDAPException ldape) {
            Debug.getInstance((String)"amSMSLdap").error("SearchResultIterator.hasNext", (Throwable)ldape);
            return false;
        }
    }

    public Object next() {
        SMSDataEntry tmp = this.current;
        this.current = null;
        return tmp;
    }

    public void remove() {
    }

    static Map convertLDAPAttributeSetToMap(LDAPAttributeSet attrSet) {
        Map answer = null;
        if (attrSet != null) {
            Enumeration enums = attrSet.getAttributes();
            while (enums.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)enums.nextElement();
                String attrName = attr.getName();
                if (attr == null) continue;
                HashSet<String> values = new HashSet<String>();
                String[] value = attr.getStringValueArray();
                for (int i = 0; i < value.length; ++i) {
                    values.add(value[i]);
                }
                if (answer == null) {
                    answer = new CaseInsensitiveHashMap(10);
                }
                answer.put(attrName, values);
            }
        }
        return answer;
    }
}

