/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.base;

import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModification;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.DSConfigInfo;
import com.sun.identity.tune.intr.TuneDS;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class AMTuneDSBase
extends TuneDS {
    protected AMTuneConfigInfo configInfo;
    protected int curNumberOfWorkerThreads;
    protected int newNumberOfWorkerThreads;
    protected String curAccessLogStatus = null;
    protected String instanceDir = null;
    protected String dsVersion = null;
    protected String dbDirectory = null;
    protected String dbDN = null;
    protected String dbSuffix = null;
    protected String dbEntryCacheSize = null;
    protected long curDBCacheSize;
    protected long newDBCacheSize;
    protected String dbLocation = null;
    protected String curDBHomeLocation = null;
    protected String newDBHomeLocation = null;
    protected MessageWriter mWriter;
    protected AMTuneLogger pLogger;
    protected String dseLdifPath;
    protected DSConfigInfo dsConfInfo;
    private long memAvail;
    private List dbDirs;
    private boolean init = false;
    private LDAPConnection ldapCon;
    private long memNeeded;

    protected AMTuneDSBase() {
    }

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        try {
            this.configInfo = configInfo;
            this.dsConfInfo = configInfo.getDSConfigInfo();
            if (!this.init) {
                this.pLogger = AMTuneLogger.getLoggerInst();
                this.mWriter = MessageWriter.getInstance();
                this.initializeLdapCon();
            }
            this.validateRootSuffix();
            this.instanceDir = this.dsConfInfo.getDsInstanceDir();
            this.dseLdifPath = this.instanceDir + "/" + "config" + "/" + "dse.ldif";
            this.validateInstanceDir();
            this.curNumberOfWorkerThreads = Integer.parseInt(this.getNumberOfWorkerThreads());
            this.curAccessLogStatus = this.getAccessLogStatus();
            this.curDBCacheSize = Long.parseLong(this.getDBCacheSize());
            this.dbSuffix = this.getBackEnd();
            this.curDBHomeLocation = this.getDBHomeLocation();
            this.dbDirectory = this.getDBDirectory();
            this.writePasswordToFile();
        }
        catch (Exception ex) {
            if (this.pLogger != null) {
                this.pLogger.logException("Error initialising Directory Server Base.", ex);
            }
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void validateInstanceDir() throws AMTuneException {
        File ldifFile = new File(this.dseLdifPath.trim());
        if (!ldifFile.exists()) {
            AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ds-instance-dir"));
        }
    }

    protected void validateRootSuffix() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "validateRootSuffix", "Validating Root Suffix " + this.dsConfInfo.getRootSuffix());
            this.searchLDAPAttrVal(this.dsConfInfo.getRootSuffix(), this.dsConfInfo.getRootSuffix(), null);
        }
        catch (AMTuneException aex) {
            this.pLogger.log(Level.SEVERE, "validateRootSuffix", "Root suffix validation failed: " + aex.getMessage());
            AMTuneUtil.printErrorMsg("ROOT_SUFFIX");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-root-suffix"));
        }
    }

    private void initializeLdapCon() throws AMTuneException {
        try {
            if (!this.init) {
                this.pLogger.log(Level.FINE, "initializeLdapCon", "Initializing LDAP Connection.");
                this.ldapCon = new LDAPConnection();
                this.ldapCon.connect(3, this.dsConfInfo.getDsHost(), Integer.parseInt(this.dsConfInfo.getDsPort()), this.dsConfInfo.getDirMgrUid(), this.dsConfInfo.getDsDirMgrPassword());
                this.init = true;
            }
        }
        catch (LDAPException ex) {
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.pLogger.logException("initializeLdapCon", ex);
            this.init = false;
            int errorCode = ex.getLDAPResultCode();
            if (errorCode == 50) {
                this.mWriter.writelnLocaleMsg("pt-error-check-ds-dn-and-password");
                throw new AMTuneException("pt-error-ldap-insufficient-access-rights");
            }
            if (errorCode == 52 || errorCode == 81 || errorCode == 91) {
                this.mWriter.writelnLocaleMsg("pt-error-check-ds-params-msg");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-cannot-connect-to-ds"));
            }
            if (errorCode == 49) {
                this.mWriter.writelnLocaleMsg("pt-error-check-ds-dn-and-password");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ds-vals"));
            }
            if (errorCode == 34) {
                AMTuneUtil.printErrorMsg("DIRMGR_BIND_DN");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-bind-dn"));
            }
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected String searchLDAPAttrVal(String base, String filter, String attr) throws AMTuneException {
        return this.searchLDAPAttrVal(base, 2, filter, attr);
    }

    protected String searchLDAPAttrVal(String base, int scope, String filter, String attr) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "searchLDAPAttrVal", "Searching for  attribute: " + attr);
            String[] ldapAttr = new String[]{attr};
            LDAPSearchResults myResults = this.ldapCon.search(base, scope, filter, ldapAttr, false);
            while (myResults.hasMoreElements()) {
                LDAPEntry myEntry = myResults.next();
                if (attr != null && attr.equals("dn")) {
                    return myEntry.getDN().replace("dn:", "").trim();
                }
                LDAPAttributeSet entryAttrs = myEntry.getAttributeSet();
                Enumeration attrsInSet = entryAttrs.getAttributes();
                while (attrsInSet.hasMoreElements()) {
                    LDAPAttribute nextAttr = (LDAPAttribute)attrsInSet.nextElement();
                    Enumeration valsInAttr = nextAttr.getStringValues();
                    if (!valsInAttr.hasMoreElements()) continue;
                    String attrVal = (String)valsInAttr.nextElement();
                    return attrVal;
                }
            }
        }
        catch (LDAPException lex) {
            this.pLogger.log(Level.SEVERE, "searchLDAPAttrVal", "Error getting ldap attribute value " + attr + " from base " + base);
            this.pLogger.logException("searchLDAPAttrVal", lex);
            throw new AMTuneException(lex.getMessage());
        }
        return null;
    }

    private String getNumberOfWorkerThreads() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getNumberOfWorkerThreads", "Getting number of worker threads.");
        String val = this.searchLDAPAttrVal("cn=config", 0, "(objectclass=*)", "nsslapd-threadnumber");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getNumberOfWorkerThreads", "Number of worker thread is null");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-no-worker-threads-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-worker-threads"));
        }
        this.pLogger.log(Level.FINEST, "getNumberOfWorkerThreads", "Returning value " + val);
        return val;
    }

    private String getAccessLogStatus() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getAccessLogStatus", "Getting access log status.");
        String val = this.searchLDAPAttrVal("cn=config", 0, "(objectclass=*)", "nsslapd-accesslog-logging-enabled");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-access-log-status");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-access-log-status"));
        }
        this.pLogger.log(Level.FINE, "getAccessLogStatus", "Returning value. " + val);
        return val;
    }

    private String getDBDirectory() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDirectory", "Getting DB Directory.");
        String val = this.searchLDAPAttrVal("cn=config", "(nsslapd-suffix=" + this.dsConfInfo.getRootSuffix() + ")", "nsslapd-directory");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-directory");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-db-directory"));
        }
        this.pLogger.log(Level.FINEST, "getDBDirectory", "Returning value " + val);
        return val;
    }

    protected String getDBDN() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDN", "Getting DB DN.");
        String val = this.searchLDAPAttrVal("cn=config", "(nsslapd-suffix=" + this.dsConfInfo.getRootSuffix() + ")", "dn");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-dn-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-db-dn"));
        }
        this.pLogger.log(Level.FINEST, "getDBDN", "Returning DB DN. " + val);
        return val;
    }

    protected String getDBDNbyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDNbyBackend", "Get DBDN by Back end " + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(&(nsslapd-suffix=*" + this.dsConfInfo.getRootSuffix() + ")(cn=" + backEnd + "))", "dn");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeln("DB DN value for " + backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            String msg = AMTuneUtil.getResourceBundle().getString("pt-error-null-db-db-msg");
            Object[] param = new Object[]{backEnd};
            throw new AMTuneException(MessageFormat.format(msg, param));
        }
        this.pLogger.log(Level.FINEST, "getDBDNbyBackend", "Returning value " + val);
        return val;
    }

    private String getBackEnd() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getBackEnd", "Get Back end name.");
        String val = this.searchLDAPAttrVal("cn=mapping tree,cn=config", "(&(|(cn=" + this.dsConfInfo.getRootSuffix() + ")(cn=\"" + this.dsConfInfo.getRootSuffix() + "\")(" + "nsslapd-parent-suffix" + "=" + this.dsConfInfo.getRootSuffix() + "))(" + "nsslapd-backend" + "=*))", "nsslapd-backend");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-backend-db");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-back-end"));
        }
        val = val.replaceFirst("NetscapeRoot", "");
        this.pLogger.log(Level.FINEST, "getBackEnd", "Returning value " + val);
        return val;
    }

    protected String getDBEntryCacheSizebyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBEntryCacheSizebyBackend", "Get DB entry cache size by back end " + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(&(nsslapd-suffix=*" + this.dsConfInfo.getRootSuffix() + ")(cn=" + backEnd + "))", "nsslapd-cachememsize");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBEntryCacheSizebyBackend", "Null DB Entry cache size for back end " + backEnd);
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeLocaleMsg("pt-entry-size-msg");
            this.mWriter.writeln(backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            String msg = AMTuneUtil.getResourceBundle().getString("pt-error-null-db-entry-cache-size");
            Object[] param = new Object[]{backEnd};
            throw new AMTuneException(MessageFormat.format(msg, param));
        }
        this.pLogger.log(Level.FINEST, "getDBEntryCacheSizebyBackend", "Returning value " + val);
        return val;
    }

    private String getSuffixbyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getSuffixbyBackend", "Get Suffix by back end" + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(cn=" + backEnd + ")", "nsslapd-suffix");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeLocaleMsg("pt-back-end-suffix-msg");
            this.mWriter.writeln(backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            String msg = AMTuneUtil.getResourceBundle().getString("pt-error-null-suffix-back-end");
            Object[] param = new Object[]{backEnd};
            throw new AMTuneException(MessageFormat.format(msg, param));
        }
        this.pLogger.log(Level.FINEST, "getSuffixbyBackend", "Returning value " + val);
        return val;
    }

    private String getDBCacheSize() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBCacheSize", "Get DB cache size.");
        String val = this.searchLDAPAttrVal("cn=config,cn=ldbm database,cn=plugins,cn=config", 0, "(objectclass=*)", "nsslapd-dbcachesize");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-size-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-db-cache-size"));
        }
        this.pLogger.log(Level.FINEST, "getDBCacheSize", "Returning value " + val);
        return val;
    }

    private String getDBHomeLocation() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBHomeLocation", "Get DB Home location");
        String val = this.searchLDAPAttrVal("cn=config,cn=ldbm database,cn=plugins,cn=config", 0, "(objectclass=*)", "nsslapd-db-home-directory");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-home-location");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-db-home-location"));
        }
        this.pLogger.log(Level.FINEST, "getDBHomeLocation", "Getting DB Home location.");
        return val;
    }

    protected String getDBName() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBName", "Get DB Name.");
        String val = this.searchLDAPAttrVal("cn=config", 2, "(&(|(cn=" + this.dsConfInfo.getRootSuffix() + ")(cn=\"" + this.dsConfInfo.getRootSuffix() + "\"))(" + "nsslapd-backend" + "=*))", "nsslapd-backend");
        if (val == null || val != null && val.length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-name-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-db-name"));
        }
        this.pLogger.log(Level.FINEST, "getDBName", "Returing value. " + val);
        return val;
    }

    protected void releaseCon() {
        try {
            if (this.ldapCon != null && this.init) {
                this.ldapCon.disconnect();
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Tune DSE ldif.");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writeLocaleMsg("pt-tuning");
            this.mWriter.writeln(this.dseLdifPath);
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(this.dseLdifPath);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-home-dir");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("nsslapd-db-home-directory: ");
            this.mWriter.writeln(this.curDBHomeLocation);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write("nsslapd-db-home-directory: ");
            this.mWriter.writeln(this.newDBHomeLocation);
            this.mWriter.writeln(" ");
            this.mWriter.writeln(" ");
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void ldapTuningRecommendations() throws AMTuneException {
        try {
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-root-suffix-msg");
            this.mWriter.writeln(this.dsConfInfo.getRootSuffix());
            this.mWriter.writelnLocaleMsg("pt-db-db-suffix-msg");
            StringTokenizer st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                this.mWriter.writeln("                                          : " + this.getDBDNbyBackend(st.nextToken()));
            }
            this.mWriter.writeLocaleMsg("pt-db-dir-suffix-msg");
            this.mWriter.writeln(this.dbDirectory);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-ds-worker-threads-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-threadnumber");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(Integer.toString(this.curNumberOfWorkerThreads));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(Integer.toString(this.newNumberOfWorkerThreads));
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-access-log-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-accesslog-logging-enabled");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(this.curAccessLogStatus);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("on");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-cache-size-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config,cn=ldbm database,cn=plugins,cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-dbcachesize");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(Long.toString(this.curDBCacheSize));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(Long.toString(this.newDBCacheSize));
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-entry-size-msg");
            this.mWriter.writeln(" ");
            st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                String curDbEntryCacheSize = this.getDBEntryCacheSizebyBackend(curToken);
                if (curDbEntryCacheSize == null || curDbEntryCacheSize != null && curDbEntryCacheSize.trim().length() == 0) {
                    this.mWriter.writeLocaleMsg("pt-fail-ds-conf");
                    this.mWriter.writeln("DB Entry Cache Size " + curToken);
                    this.mWriter.writelnLocaleMsg("pt-inval-config");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-db-entry-cache-size"));
                }
                long newDBEntryCacheSize = this.suggestDBEntryCacheSizebyBackend(curToken);
                if (newDBEntryCacheSize == 0L) {
                    this.mWriter.writeLocaleMsg("pt-cannot-compute-rec-val");
                    this.mWriter.writeln("DB Cache Size for " + curToken);
                    this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-new-db-entry-cache-size"));
                }
                this.mWriter.writeLocaleMsg("pt-suffix-msg");
                this.mWriter.writeln(this.getSuffixbyBackend(curToken));
                this.mWriter.writeLocaleMsg("pt-dn-msg");
                this.mWriter.writeln(this.getDBDNbyBackend(curToken));
                this.mWriter.writeLocaleMsg("pt-attribute-msg");
                this.mWriter.writeln("nsslapd-cachememsize");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.writeln(curDbEntryCacheSize);
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeln(Long.toString(newDBEntryCacheSize));
                this.mWriter.writeln(" ");
                this.mWriter.writeln(" ");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "ldapTuningRecomendations", "Error computing LDAP Recommendaionts");
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void addLDAPEntry(LDAPEntry newEntry) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINEST, "addLDAPEntry", "Adding entry " + newEntry.toString());
            this.ldapCon.add(newEntry);
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected boolean applyRecommendations() throws AMTuneException {
        boolean status = false;
        try {
            this.pLogger.log(Level.FINE, "applyRecommendations", "Applying recommendations. ");
            if (this.curNumberOfWorkerThreads < this.newNumberOfWorkerThreads) {
                this.mWriter.writeLocaleMsg("pt-modify");
                this.mWriter.writelnLocaleMsg("pt-no-worker-threads-msg");
                LDAPAttribute threadNoAttr = new LDAPAttribute("nsslapd-threadnumber", "24");
                LDAPModification threadNo = new LDAPModification(2, threadNoAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying worker threads. " + threadNoAttr.toString());
                this.ldapCon.modify("cn=config", threadNo);
                status = true;
            } else {
                this.mWriter.writeLocaleMsg("pt-enough");
                this.mWriter.writelnLocaleMsg("pt-ds-worker-msg");
            }
            if (!this.curAccessLogStatus.equals("on")) {
                this.mWriter.writelnLocaleMsg("pt-modify-access-log-status");
                LDAPAttribute accessLogAttr = new LDAPAttribute("nsslapd-accesslog-logging-enabled", "on");
                LDAPModification accessLogModif = new LDAPModification(2, accessLogAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying access log status. " + accessLogAttr.toString());
                this.ldapCon.modify("cn=config", accessLogModif);
                status = true;
            } else {
                this.mWriter.writelnLocaleMsg("pt-access-log-on");
            }
            if (this.newDBCacheSize > this.curDBCacheSize) {
                this.mWriter.writeLocaleMsg("pt-modify");
                this.mWriter.writelnLocaleMsg("pt-db-size-msg");
                LDAPAttribute cacheSizeAttr = new LDAPAttribute("nsslapd-dbcachesize", Long.toString(this.newDBCacheSize));
                LDAPModification cachesizeModif = new LDAPModification(2, cacheSizeAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying db cache size. " + cacheSizeAttr.toString());
                this.ldapCon.modify("cn=config,cn=ldbm database,cn=plugins,cn=config", cachesizeModif);
                status = true;
            } else {
                this.mWriter.writeLocaleMsg("pt-db-size-msg");
                this.mWriter.writelnLocaleMsg("pt-already-enough");
            }
            StringTokenizer st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                long curDBEntryCacheSize = Long.parseLong(this.getDBEntryCacheSizebyBackend(curToken));
                long newDBEntryCacheSize = this.suggestDBEntryCacheSizebyBackend(curToken);
                if (newDBEntryCacheSize > curDBEntryCacheSize) {
                    this.mWriter.writeLocaleMsg("pt-modify");
                    this.mWriter.writeln("DB Entry Cache Size for " + curToken);
                    String dn = this.getDBDNbyBackend(curToken);
                    LDAPAttribute cacheMemSizeAttr = new LDAPAttribute("nsslapd-cachememsize", Long.toString(newDBEntryCacheSize));
                    LDAPModification cacheMemSizeMod = new LDAPModification(2, cacheMemSizeAttr);
                    this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying db cache size. " + cacheMemSizeAttr.toString());
                    this.ldapCon.modify(dn, cacheMemSizeMod);
                    status = true;
                    continue;
                }
                this.mWriter.write("DB Entry Cache Size ");
                this.mWriter.writeLocaleMsg("pt-already-enough");
                this.mWriter.writeln(" for " + curToken);
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "applyRecommendations", ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
        return status;
    }

    private List mergeLists(List list1, List list2) {
        for (String attr : list2) {
            boolean found = false;
            Iterator itr1 = list1.iterator();
            while (itr1.hasNext()) {
                String curAttr = itr1.next().toString();
                if (!curAttr.equalsIgnoreCase(attr)) continue;
                found = true;
            }
            if (found) continue;
            list1.add(attr);
        }
        return list1;
    }

    protected void tuneFuture() {
        this.pLogger.log(Level.FINE, "tuneFuture", "Tuning future.");
        this.mWriter.writeln("---------------------------------------------------------------------");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg1");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg2");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg3");
        this.mWriter.write("1. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: db_dn");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-sizelimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-b");
        this.mWriter.writeln("nsslapd-timelimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-c");
        this.mWriter.writeln("nsslapd-lookthroughlimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-d");
        this.mWriter.writeln("nsslapd-require-index");
        this.mWriter.writeln(" ");
        this.mWriter.write("2. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: cn=config,cn=ldbm database,cn=plugins,cn=config");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-db-transaction-batch-val");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-b");
        this.mWriter.writeln("nsslapd-db-logbuf-size");
        this.mWriter.writeln(" ");
        this.mWriter.write("3. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: cn=referential integrity postoperation,cn=plugins,cn=config");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-pluginarg0");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-split-comp-msg");
        this.mWriter.writelnLocaleMsg("pt-database-trans-logs-msg");
        this.mWriter.writelnLocaleMsg("pt-isolate-msg");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-delegated-admin-msg1");
        this.mWriter.writelnLocaleMsg("pt-delegated-admin-msg2");
        this.mWriter.writeln(" ");
        this.mWriter.writeln("=====================================================================");
    }

    protected void computeTuneValues() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "computeTuneValues", "Compute Tuning values for DS.");
            this.memAvail = Long.parseLong(AMTuneUtil.getSystemMemory());
            this.memAvail = this.memAvail * 1024L * 1024L;
            this.mWriter.writelnLocaleMsg("pt-calc-ds-mem");
            this.dbDirs = this.availableDBDirs();
            if (this.dbDirs.size() == 0) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-loc-db-dir"));
            }
            this.newDBCacheSize = this.calculateDBCacheSize();
            if (this.newDBCacheSize == 0L) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-compute-db-size"));
            }
            this.memNeeded = this.newDBCacheSize + this.calculateTotalNewEntryDBCacheSize();
            if (this.memNeeded == 0L) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-mem-req"));
            }
            this.mWriter.writeLocaleMsg("pt-avail-mem-size");
            this.mWriter.writeln(Long.toString(this.memAvail));
            this.mWriter.writeLocaleMsg("pt-mem-need-ds-cache");
            this.mWriter.writeln(Long.toString(this.memNeeded));
            if (this.memNeeded > this.memAvail) {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-no-enough-mem"));
            }
            this.mWriter.writelnLocaleMsg("pt-enough-mem");
            String dbDirName = new File(this.instanceDir).getName();
            this.newDBHomeLocation = AMTuneUtil.TMP_DIR + dbDirName;
            File newDBHome = new File(this.newDBHomeLocation);
            boolean createStat = true;
            if (!newDBHome.isDirectory()) {
                createStat = newDBHome.mkdir();
            }
            if (!createStat) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-cannot-new-db-home"));
            }
            this.newNumberOfWorkerThreads = Integer.parseInt("24");
            if (this.newNumberOfWorkerThreads == 0) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-cannot-new-ds-threads"));
            }
        }
        catch (NumberFormatException ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    private long suggestDBEntryCacheSizebyBackend(String backEnd) {
        String dbDir = this.instanceDir + "/" + "db" + "/" + backEnd;
        long dbSize = (long)((double)AMTuneUtil.getDirSize(dbDir) * 1.2) / 1L;
        return dbSize;
    }

    private long calculateTotalNewEntryDBCacheSize() throws AMTuneException {
        this.pLogger.log(Level.FINE, "calculateTotalNewEntryDBCacheSize", "Caliculating total new entry db cache size.");
        StringTokenizer suffixTokens = new StringTokenizer(this.dbSuffix, " ");
        long totalVal = 0L;
        while (suffixTokens.hasMoreTokens()) {
            String curSuffix = suffixTokens.nextToken();
            long sugVal = this.suggestDBEntryCacheSizebyBackend(curSuffix);
            if (sugVal == 0L) {
                this.mWriter.writeLocaleMsg("pt-cannot-proceed");
                String msg = AMTuneUtil.getResourceBundle().getString("pt-cannot-compute-rec-db-size");
                Object[] param = new Object[]{curSuffix + " "};
                throw new AMTuneException(MessageFormat.format(msg, param));
            }
            totalVal += sugVal;
        }
        this.pLogger.log(Level.FINE, "calculateTotalNewEntryDBCacheSize", "Returning total size ." + totalVal);
        return totalVal;
    }

    private long calculateDBCacheSize() {
        this.pLogger.log(Level.FINE, "calculateDBCacheSize", "Caliculate DB cache size.");
        List l = this.dbDirs;
        long size = 0L;
        for (int i = 0; i < l.size(); ++i) {
            size += AMTuneUtil.getDirSize((String)l.get(i));
        }
        size = (long)((double)size * 1.2) / 1L;
        this.pLogger.log(Level.FINE, "calculateDBCacheSize", "Returning size " + size);
        return size;
    }

    private List availableDBDirs() {
        this.pLogger.log(Level.FINE, "availableDBDirs", "Getting DB dirs. ");
        File iDir = new File(this.instanceDir + "/" + "db");
        String[] list = iDir.list();
        ArrayList<String> dirList = new ArrayList<String>();
        int arrLen = 0;
        for (int i = 0; i < list.length; ++i) {
            File curFile = new File(iDir.getAbsolutePath() + "/" + list[i]);
            if (!curFile.isDirectory()) continue;
            dirList.add(arrLen++, curFile.getAbsolutePath());
        }
        this.pLogger.log(Level.FINEST, "availableDBDirs", "Available DB dirs are " + dirList.toString());
        return dirList;
    }

    protected void writePasswordToFile() throws AMTuneException {
    }

    protected void deletePasswordFile() {
    }
}

