/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileHandler {
    private String fileName = null;
    private ArrayList lines = null;

    public FileHandler(String fileName) throws FileNotFoundException, IOException {
        this.fileName = fileName;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String str = null;
        this.lines = new ArrayList();
        while ((str = in.readLine()) != null) {
            this.lines.add(str);
        }
        in.close();
    }

    public String getLine(String regExp) {
        int iLineNum = this.getLineNum(regExp);
        return iLineNum != -1 ? (String)this.lines.get(iLineNum) : "";
    }

    public int getLineNum(String regExp) {
        Pattern p = Pattern.compile(regExp);
        int size = this.lines.size();
        int i = 0;
        for (i = 0; i < size; ++i) {
            String line = (String)this.lines.get(i);
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            return i;
        }
        return -1;
    }

    public String[] getMattchingLines(String pattern, boolean invert) {
        ArrayList<String> matList = new ArrayList<String>();
        Pattern p = Pattern.compile(pattern);
        int size = this.lines.size();
        int i = 0;
        for (i = 0; i < size; ++i) {
            String line = (String)this.lines.get(i);
            Matcher m = p.matcher(line);
            boolean found = m.find();
            if (!invert && found) {
                matList.add(this.getLine(i));
                continue;
            }
            if (!invert || found) continue;
            matList.add(this.getLine(i));
        }
        String[] arr = new String[matList.size()];
        for (i = 0; i < matList.size(); ++i) {
            arr[i] = new String(matList.get(i).toString());
        }
        return arr;
    }

    public int lineContains(String text) {
        int size = this.lines.size();
        int i = 0;
        for (i = 0; i < size; ++i) {
            String str = (String)this.lines.get(i);
            if (str.indexOf(text) == -1) continue;
            return i;
        }
        return -1;
    }

    public int lineEquals(String text) {
        int size = this.lines.size();
        int i = 0;
        for (i = 0; i < size; ++i) {
            String str = (String)this.lines.get(i);
            if (!str.equals(text)) continue;
            return i;
        }
        return -1;
    }

    public String getLine(int lineNum) {
        return (String)this.lines.get(lineNum);
    }

    public int getPatternMatchLine(String patternBegin, String patternEnd, String patternFind) {
        int size = this.lines.size();
        int i = 0;
        int start = 0;
        int end = 0;
        for (i = 0; i < size && !((String)this.lines.get(i)).trim().startsWith(patternBegin); ++i) {
        }
        if (i == size) {
            return size - 1;
        }
        start = i;
        while (i < size && !((String)this.lines.get(i)).trim().startsWith(patternEnd)) {
            ++i;
        }
        end = i == size ? i - 1 : i;
        for (i = end; i >= start && !((String)this.lines.get(i)).trim().startsWith(patternFind); --i) {
        }
        if (i == start - 1) {
            return end - 1;
        }
        return i;
    }

    public int startsWith(String str) {
        int size = this.lines.size();
        int i = 0;
        for (i = 0; i < size && !((String)this.lines.get(i)).startsWith(str); ++i) {
        }
        if (i == size) {
            i = -1;
        }
        return i;
    }

    public int startsWithAndEndsWith(String startStr, String endStr) {
        String line;
        int size = this.lines.size();
        int i = 0;
        for (i = 0; !(i >= size || (line = ((String)this.lines.get(i)).trim()).startsWith(startStr) && line.endsWith(endStr)); ++i) {
        }
        if (i == size) {
            i = -1;
        }
        return i;
    }

    public void removeLine(int lineNum) {
        this.lines.remove(lineNum);
    }

    public void removeMatchingLines(String[] matchStrings) {
        int lineNum = -1;
        for (int i = 0; i < matchStrings.length; ++i) {
            lineNum = this.lineContains(matchStrings[i]);
            if (lineNum < 0) continue;
            this.removeLine(lineNum);
        }
    }

    public void insertLine(int lineNum, String text) {
        this.lines.add(lineNum, text);
    }

    public String replaceLine(int lineNum, String text) {
        String retVal = (String)this.lines.remove(lineNum);
        this.lines.add(lineNum, text);
        return retVal;
    }

    public void appendLine(String line) {
        if (this.lines == null) {
            throw new RuntimeException("File is already closed.");
        }
        this.lines.add(line);
    }

    public void close() throws IOException {
        int size = this.lines.size();
        BufferedWriter out = new BufferedWriter(new FileWriter(this.fileName));
        for (int i = 0; i < size; ++i) {
            out.write((String)this.lines.get(i));
            if (i == size) continue;
            out.write(10);
        }
        out.close();
    }
}

