/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AS9ContainerConfigInfo
extends WebContainerConfigInfoBase {
    private String asAdminUser;
    private String asAdminHost;
    private String asAdminPort;
    private String asAdminSecure;
    private boolean isInteractive;
    private String asAdminTarget;
    private String asAdminDir;
    private String asAdminHttpListener;
    private boolean tuneWebContainerJavaPolicy;
    private StringBuffer asAdminCommonParamsNoTarget;
    private StringBuffer asAdminCommonParams;
    private String asAdminCmd;
    private Map cfgMap;
    private String tempFile;
    private String acceptorThreadParam;
    private String adminPassFile;
    private String asAdminPass;
    String passwordStr;

    public AS9ContainerConfigInfo(ResourceBundle confRbl, String passFilePath) throws AMTuneException {
        try {
            this.setWebContainer("AS91");
            this.adminPassFile = AMTuneUtil.TMP_DIR + "asadminpass";
            this.tempFile = AMTuneUtil.TMP_DIR + "cmdoutput";
            this.setContainerInstanceDir(confRbl.getString("CONTAINER_INSTANCE_DIR"));
            this.setASAdminDir(confRbl.getString("ASADMIN_DIR"));
            this.setASAdminCmd();
            this.setASAdminUser(confRbl.getString("ASADMIN_USER"));
            this.setASAdminHost(confRbl.getString("ASADMIN_HOST"));
            this.setASAdminPort(confRbl.getString("ASADMIN_PORT"));
            this.setASAdminSecure(confRbl.getString("ASADMIN_SECURE"));
            this.setASAdminTarget(confRbl.getString("ASADMIN_TARGET"));
            this.setASAdminHttpListener(confRbl.getString("ASADMIN_HTTPLISTENER"));
            this.setTuneWebContainerJavaPolicy(confRbl.getString("AMTUNE_WEB_CONTAINER_JAVA_POLICY"));
            this.setIsInteractive();
            this.asAdminCommonParamsNoTarget = new StringBuffer("--user ");
            this.asAdminCommonParamsNoTarget.append(this.getASAdminUser());
            this.asAdminCommonParamsNoTarget.append(" --passwordfile ");
            this.asAdminCommonParamsNoTarget.append(this.adminPassFile);
            this.asAdminCommonParamsNoTarget.append(" --host ");
            this.asAdminCommonParamsNoTarget.append(this.getWSAdminHost());
            this.asAdminCommonParamsNoTarget.append(" --port ");
            this.asAdminCommonParamsNoTarget.append(this.getASAdminPort());
            if (this.getASAdminSecure() != null) {
                this.asAdminCommonParamsNoTarget.append(" ");
                this.asAdminCommonParamsNoTarget.append(this.getASAdminSecure());
            }
            this.asAdminCommonParamsNoTarget.append(" --interactive=");
            this.asAdminCommonParamsNoTarget.append(this.isInteractive());
            this.asAdminCommonParams = new StringBuffer(this.asAdminCommonParamsNoTarget.toString());
            this.asAdminCommonParams.append(" --target ");
            this.asAdminCommonParams.append(this.getASAdminTarget());
            this.acceptorThreadParam = "server.http-service.http-listener." + this.getASAdminHttpListener() + ".acceptor-threads";
            FileHandler pHdl = new FileHandler(passFilePath);
            String reqLine = pHdl.getLine("ASADMIN_PASSWORD");
            if (reqLine == null || reqLine != null && reqLine.trim().length() < "ASADMIN_PASSWORD".length() + 1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writelnLocaleMsg("pt-as-password-not-found-msg");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-as-password-not-found"));
            }
            this.setAsAdminPass(AMTuneUtil.getLastToken(reqLine, "="));
            this.passwordStr = "AS_ADMIN_PASSWORD=" + this.getAsAdminPass();
            this.checkAppServer64BitEnabled();
            this.fillCfgMap();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "AS91ContainerConfigInfo", "Failed to set Appserver 91 configuration information. ");
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            AMTuneUtil.deleteFile(this.tempFile);
            this.deletePasswordFile();
        }
    }

    private void setAsAdminPass(String asAdminPass) throws AMTuneException {
        if (asAdminPass == null || asAdminPass.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-as-password-not-found-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-as-password-null"));
        }
        this.asAdminPass = asAdminPass.trim();
    }

    public String getAsAdminPass() {
        return this.asAdminPass;
    }

    protected void deletePasswordFile() {
        AMTuneUtil.deleteFile(this.getAdminPassfilePath());
    }

    public String getAdminPassfilePath() {
        return this.adminPassFile;
    }

    private void fillCfgMap() throws AMTuneException {
        block13: {
            try {
                StringBuffer getCmd = new StringBuffer(this.getASAdminCmd());
                getCmd.append("get ");
                getCmd.append(this.asAdminCommonParamsNoTarget.toString());
                getCmd.append(" ");
                getCmd.append(this.acceptorThreadParam);
                getCmd.append(" ");
                getCmd.append("server.http-service.request-processing.initial-thread-count");
                getCmd.append(" ");
                getCmd.append("server.http-service.request-processing.thread-count");
                getCmd.append(" ");
                getCmd.append("server.http-service.connection-pool.max-pending-count");
                getCmd.append(" ");
                getCmd.append("server.http-service.connection-pool.queue-size-in-bytes");
                StringBuffer resultBuffer = new StringBuffer();
                String reqLine = "";
                this.cfgMap = new HashMap();
                int retVal = AMTuneUtil.executeCommand(getCmd.toString(), this.passwordStr, this.adminPassFile, resultBuffer);
                if (resultBuffer.toString().indexOf("No object matches the specified name") != -1) {
                    AMTuneUtil.printErrorMsg("ASADMIN_HTTPLISTENER");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-as-http-listener"));
                }
                if (retVal != 0) {
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-get-as-thread-queue-size"));
                }
                AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
                FileHandler cfgF = new FileHandler(this.tempFile);
                reqLine = cfgF.getLine(this.acceptorThreadParam);
                this.cfgMap.put(".acceptor-threads", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.request-processing.initial-thread-count");
                this.cfgMap.put("server.http-service.request-processing.initial-thread-count", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.request-processing.thread-count");
                this.cfgMap.put("server.http-service.request-processing.thread-count", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.connection-pool.max-pending-count");
                this.cfgMap.put("server.http-service.connection-pool.max-pending-count", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.connection-pool.queue-size-in-bytes");
                this.cfgMap.put("server.http-service.connection-pool.queue-size-in-bytes", AMTuneUtil.getLastToken(reqLine, "="));
                cfgF.close();
                String jvmOptParam = this.getASAdminTarget() + ".java-config.jvm-options";
                StringBuffer getJvmOptCmd = new StringBuffer(this.getASAdminCmd());
                getJvmOptCmd.append("get ");
                getJvmOptCmd.append(this.asAdminCommonParamsNoTarget.toString());
                getJvmOptCmd.append(" ");
                getJvmOptCmd.append(jvmOptParam);
                resultBuffer.setLength(0);
                retVal = AMTuneUtil.executeCommand(getJvmOptCmd.toString(), this.passwordStr, this.adminPassFile, resultBuffer);
                ArrayList<String> curJVMOptList = new ArrayList<String>();
                if (resultBuffer.toString().indexOf("No object matches the specified name") != -1) {
                    AMTuneUtil.printErrorMsg("ASADMIN_TARGET");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-as-target"));
                }
                if (retVal == 0) {
                    String cmdOutput = resultBuffer.toString().replace(jvmOptParam + " = ", "");
                    StringTokenizer st = new StringTokenizer(cmdOutput, ",");
                    while (st.hasMoreTokens()) {
                        String flagStr = st.nextToken();
                        curJVMOptList.add(flagStr);
                    }
                    this.cfgMap.put("-Xms", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xms", true));
                    this.cfgMap.put("-Xmx", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xmx", true));
                    this.cfgMap.put("-Xloggc", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xloggc", true));
                    if (cmdOutput.indexOf("-client") != -1) {
                        this.cfgMap.put("-client", "-client");
                    } else {
                        this.cfgMap.put("-client", "");
                    }
                    if (cmdOutput.indexOf("-server") != -1) {
                        this.cfgMap.put("-server", "-server");
                    } else {
                        this.cfgMap.put("-server", "");
                    }
                    this.cfgMap.put("-Xss", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xss", true));
                    this.cfgMap.put("-XX:NewSize", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:NewSize", false));
                    this.cfgMap.put("-XX:MaxNewSize", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:MaxNewSize", false));
                    this.cfgMap.put("-XX:+DisableExplicitGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+DisableExplicitGC".replace("-XX:+", ""), true));
                    this.cfgMap.put("-XX:+UseParNewGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+UseParNewGC".replace("-XX:+", ""), true));
                    this.cfgMap.put("-XX:+PrintClassHistogram", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+PrintClassHistogram".replace("-XX:+", ""), true));
                    this.cfgMap.put("-XX:+PrintGCTimeStamps", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+PrintGCTimeStamps".replace("-XX:+", ""), true));
                    this.cfgMap.put("-XX:+UseConcMarkSweepGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+UseConcMarkSweepGC".replace("-XX:+", ""), true));
                    if (this.isTuneWebContainerJavaPolicy()) {
                        this.cfgMap.put("-Djava.security.policy", AMTuneUtil.getASJVMOption(curJVMOptList, "-Djava.security.policy", true));
                    }
                    if (AMTuneUtil.isNiagara()) {
                        this.cfgMap.put("-XX:ParallelGCThreads", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:ParallelGCThreads", true));
                    }
                    break block13;
                }
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-getting-jvm-options"));
            }
            catch (Exception ex) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting Application server configuration information. " + ex.getMessage());
                throw new AMTuneException(ex.getMessage());
            }
        }
    }

    private void setASAdminUser(String asAdminUser) throws AMTuneException {
        if (asAdminUser == null || asAdminUser.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("ASADMIN_USER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-as-admin-user-null"));
        }
        this.asAdminUser = asAdminUser.trim();
    }

    public String getASAdminUser() {
        return this.asAdminUser;
    }

    private void setASAdminHost(String asAdminHost) throws AMTuneException {
        if (asAdminHost == null || asAdminHost.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("ASADMIN_HOST");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-as-admin-host"));
        }
        this.asAdminHost = asAdminHost.trim();
    }

    public String getWSAdminHost() {
        return this.asAdminHost;
    }

    private void setASAdminPort(String asAdminPort) throws AMTuneException {
        if (asAdminPort != null && asAdminPort.trim().length() > 0) {
            try {
                Integer.parseInt(asAdminPort.trim());
            }
            catch (NumberFormatException ne) {
                AMTuneUtil.printErrorMsg("ASADMIN_PORT");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-port-no"));
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("ASADMIN_PORT");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-as-admin-port"));
        }
        this.asAdminPort = asAdminPort.trim();
    }

    public String getASAdminPort() {
        return this.asAdminPort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setASAdminSecure(String asAdminSecure) throws AMTuneException {
        if (asAdminSecure != null && asAdminSecure.trim().length() > 0) {
            if (!asAdminSecure.equals("--secure")) {
                AMTuneUtil.printErrorMsg("ASADMIN_SECURE");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-as-secure-prop"));
            }
        } else {
            this.pLogger.log(Level.INFO, "setAdminSecure", "Application Server Admin port is not secured. ");
            return;
        }
        this.asAdminSecure = asAdminSecure.trim();
    }

    public String getASAdminSecure() {
        return this.asAdminSecure;
    }

    private void setIsInteractive() {
        this.isInteractive = false;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    private void setASAdminTarget(String asAdminTarget) throws AMTuneException {
        if (asAdminTarget == null || asAdminTarget.trim().length() <= 0) {
            AMTuneUtil.printErrorMsg("ASADMIN_TARGET");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-as-target"));
        }
        this.asAdminTarget = asAdminTarget.trim();
    }

    public String getASAdminTarget() {
        return this.asAdminTarget;
    }

    private void setASAdminDir(String asAdminDir) throws AMTuneException {
        if (asAdminDir != null && asAdminDir.trim().length() > 0) {
            File cmdF = new File(asAdminDir);
            if (!cmdF.isDirectory()) {
                this.mWriter.writeLocaleMsg("pt-not-valid-dir");
                this.mWriter.writeln(" " + asAdminDir);
                AMTuneUtil.printErrorMsg("ASADMIN_DIR");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-as-admin-dir"));
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("ASADMIN_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-as-admin-dir"));
        }
        this.asAdminDir = asAdminDir.trim();
    }

    public String getASAdminDir() {
        return this.asAdminDir;
    }

    private void setASAdminCmd() throws AMTuneException {
        this.asAdminCmd = AMTuneUtil.isWindows() ? this.getASAdminDir() + "/" + "asadmin.bat " : this.getASAdminDir() + "/" + "asadmin ";
        File asToolF = new File(this.asAdminCmd.trim());
        if (!asToolF.isFile()) {
            this.mWriter.write(this.asAdminCmd);
            this.mWriter.writelnLocaleMsg("pt-tool-not-found");
            AMTuneUtil.printErrorMsg("ASADMIN_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-as-admin-tool-not-found"));
        }
    }

    public String getASAdminCmd() {
        return this.asAdminCmd;
    }

    private void setASAdminHttpListener(String asAdminHttpListener) {
        if (asAdminHttpListener != null && asAdminHttpListener.trim().length() > 0) {
            this.asAdminHttpListener = asAdminHttpListener.trim();
        } else {
            this.pLogger.log(Level.SEVERE, "setASAdminHttpListener", "Using default value \"http-listener-1\" for ASADMIN_HTTPLISTENER ");
            this.asAdminHttpListener = "http-listener-1";
        }
    }

    public String getASAdminHttpListener() {
        return this.asAdminHttpListener;
    }

    private void setTuneWebContainerJavaPolicy(String tuneWebContainerJavaPolicy) {
        if (tuneWebContainerJavaPolicy != null && tuneWebContainerJavaPolicy.trim().length() > 0) {
            this.tuneWebContainerJavaPolicy = Boolean.parseBoolean(tuneWebContainerJavaPolicy);
        } else {
            this.pLogger.log(Level.INFO, "setTuneWebContainerJavaPolicy", "Using default value false for AMTUNE_WEB_CONTAINER_JAVA_POLICY");
            this.tuneWebContainerJavaPolicy = false;
        }
    }

    public boolean isTuneWebContainerJavaPolicy() {
        return this.tuneWebContainerJavaPolicy;
    }

    public Map getCurASConfigInfo() {
        return this.cfgMap;
    }

    public String getAcceptorThreadString() {
        return this.acceptorThreadParam;
    }

    public String getAsAdminCommonParamsNoTarget() {
        return this.asAdminCommonParamsNoTarget.toString();
    }

    public String getAsAdminCommonParams() {
        return this.asAdminCommonParams.toString();
    }

    private void checkAppServer64BitEnabled() throws AMTuneException {
        this.mWriter.writelnLocaleMsg("pt-app-check-jvmbits");
        StringBuffer jvmcmd = new StringBuffer(this.getASAdminCmd());
        jvmcmd.append("generate-jvm-report");
        jvmcmd.append(" ");
        jvmcmd.append(this.getAsAdminCommonParamsNoTarget());
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(jvmcmd.toString(), this.passwordStr, this.adminPassFile, resultBuffer);
        if (resultBuffer.indexOf("Unable to connect to admin-server") != -1) {
            this.mWriter.writelnLocaleMsg("pt-web-not-running-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-unable-to-connect-to-asadmin-srv"));
        }
        if (resultBuffer.indexOf("Unknown host") != -1) {
            this.mWriter.writelnLocaleMsg("pt-web-not-running-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-unknow-host"));
        }
        if (resultBuffer.indexOf("Invalid user or password") != -1) {
            this.mWriter.writelnLocaleMsg("pt-error-as-check-user-password-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-as-invalid-user-password"));
        }
        if (resultBuffer.toString().indexOf("SSL peer shut down incorrectly") != -1) {
            this.mWriter.writelnLocaleMsg("pt-error-as-port-ssl-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-as-secure-prop"));
        }
        if (retVal == 0) {
            if (resultBuffer.toString().indexOf("sun.arch.data.model = 64") == -1) {
                this.setJVM64BitEnabled(false);
            } else {
                this.setJVM64BitEnabled(true);
            }
        } else {
            this.pLogger.log(Level.SEVERE, "checkAppServer64BitEnabled", "Error checking jvm bits so using 32 bit. ");
            this.setJVM64BitEnabled(false);
        }
    }
}

