/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.constants.DSConstants;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class DSConfigInfo
implements DSConstants {
    private String dsDirMgrPassword;
    private String dsInstanceDir;
    private String dsHost;
    private String dsPort;
    private String rootSuffix;
    private String dirMgrUid;
    private String dsVersion;
    private String dsToolsDir;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;
    private boolean isRemoteDS;

    public DSConfigInfo(ResourceBundle confBundle, String passFilePath) throws AMTuneException {
        try {
            this.pLogger = AMTuneLogger.getLoggerInst();
            this.mWriter = MessageWriter.getInstance();
            this.setDsHost(confBundle.getString("DS_HOST"));
            this.checkIsDSHostRemote();
            this.setDsPort(confBundle.getString("DS_PORT"));
            this.setRootSuffix(confBundle.getString("ROOT_SUFFIX"));
            this.setDsInstanceDir(confBundle.getString("DS_INSTANCE_DIR"));
            if (!this.isRemoteDS) {
                if (passFilePath == null || passFilePath != null && !new File(passFilePath).exists()) {
                    this.mWriter.writelnLocaleMsg("pt-password-file-keys-msg");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-password-file-not-found"));
                }
                FileHandler pHdl = new FileHandler(passFilePath);
                String reqLine = pHdl.getLine("DIRMGR_PASSWORD");
                if (reqLine == null || reqLine != null && reqLine.trim().length() < "DIRMGR_PASSWORD".length() + 1) {
                    this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                    this.mWriter.writelnLocaleMsg("pt-ds-password-not-found-msg");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ds-password-not-found"));
                }
                this.setDsDirMgrPassword(AMTuneUtil.getLastToken(reqLine, "="));
            }
            this.setDsVersion(confBundle.getString("DS_VERSION"));
            if (this.getDsVersion().indexOf("6.") != -1) {
                this.setDSToolsBinDir(confBundle.getString("DS_TOOLS_DIR"));
            }
            this.setDirMgrUid(confBundle.getString("DIRMGR_BIND_DN"));
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void checkIsDSHostRemote() {
        this.pLogger.log(Level.FINEST, "checkIsDSHostRemote", "DS host is " + this.getDsHost());
        this.pLogger.log(Level.FINEST, "checkIsDSHostRemote", "Local host is " + AMTuneUtil.getHostName());
        this.isRemoteDS = AMTuneUtil.getHostName().toLowerCase().indexOf(this.getDsHost().substring(0, this.getDsHost().indexOf(46)).toLowerCase()) == -1;
    }

    private void setDsDirMgrPassword(String dsDirMgrPassword) throws AMTuneException {
        if (dsDirMgrPassword == null || dsDirMgrPassword.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-ds-password-not-found-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ds-password-null"));
        }
        this.dsDirMgrPassword = dsDirMgrPassword.trim();
    }

    public String getDsDirMgrPassword() {
        return this.dsDirMgrPassword;
    }

    private void setDsInstanceDir(String dsInstanceDir) throws AMTuneException {
        if (dsInstanceDir != null && dsInstanceDir.trim().length() > 0) {
            File dirTest = new File(dsInstanceDir);
            if (!dirTest.isDirectory() && !this.isRemoteDS) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-not-valid-dir"));
            }
            this.dsInstanceDir = dsInstanceDir.trim();
        } else if (!this.isRemoteDS) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-not-valid-dir"));
        }
    }

    public String getDsInstanceDir() {
        return this.dsInstanceDir;
    }

    private void setDsHost(String dsHost) throws AMTuneException {
        if (dsHost != null && dsHost.trim().length() > 0) {
            if (dsHost.indexOf(".") <= 0) {
                AMTuneUtil.printErrorMsg("DS_HOST");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-fqdn-ds-host-name"));
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_HOST");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-host"));
        }
        this.dsHost = dsHost.trim();
    }

    public String getDsHost() {
        return this.dsHost;
    }

    private void setDsPort(String dsPort) throws AMTuneException {
        if (dsPort != null && dsPort.trim().length() > 0) {
            try {
                Integer.parseInt(dsPort.trim());
            }
            catch (NumberFormatException ne) {
                AMTuneUtil.printErrorMsg("DS_PORT");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-port-no"));
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_PORT");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-port"));
        }
        this.dsPort = dsPort.trim();
    }

    public String getDsPort() {
        return this.dsPort;
    }

    private void setRootSuffix(String rootSuffix) throws AMTuneException {
        if (rootSuffix == null || rootSuffix.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("ROOT_SUFFIX");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-root-suffix"));
        }
        this.rootSuffix = rootSuffix.trim();
    }

    public String getRootSuffix() {
        return this.rootSuffix;
    }

    private void setDirMgrUid(String dirMgrUid) throws AMTuneException {
        if (dirMgrUid == null || dirMgrUid.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DIRMGR_BIND_DN");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-bind-dn"));
        }
        this.dirMgrUid = dirMgrUid.trim();
    }

    public String getDirMgrUid() {
        return this.dirMgrUid;
    }

    private void setDsVersion(String dsVersion) throws AMTuneException {
        if (dsVersion == null || dsVersion.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_VERSION");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-version"));
        }
        this.dsVersion = dsVersion.trim();
    }

    public String getDsVersion() {
        return this.dsVersion;
    }

    private void setDSToolsBinDir(String dsToolsDir) throws AMTuneException {
        if (dsToolsDir != null && dsToolsDir.trim().length() > 0) {
            File dir = new File(dsToolsDir);
            if (!dir.isDirectory() && !this.isRemoteDS) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("DS_TOOLS_DIR");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-not-valid-dir"));
            }
            this.dsToolsDir = dsToolsDir.trim();
        } else if (!this.isRemoteDS) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_TOOLS_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ds-tools-dir"));
        }
    }

    public String getDSToolsBinDir() {
        return this.dsToolsDir;
    }

    public boolean isRemoteDS() {
        return this.isRemoteDS;
    }
}

