/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.WS7ContainerConfigInfo;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.intr.TuneWebServer;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TuneWS7Container
extends TuneWebServer
implements WebContainerConstants {
    private AMTuneConfigInfo configInfo;
    private WS7ContainerConfigInfo wsConfigInfo;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;
    private String tuneFile;
    private Map curCfgMap;
    private String passwordStr = null;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.configInfo = configInfo;
        this.wsConfigInfo = (WS7ContainerConfigInfo)configInfo.getWSConfigInfo();
        this.passwordStr = "wadm_password=" + this.wsConfigInfo.getWsAdminPass();
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.tuneFile = this.wsConfigInfo.getContainerInstanceDir() + "/" + "config" + "/" + "server.xml";
        this.validateInstanceDir();
        this.curCfgMap = this.wsConfigInfo.getServerCfgMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.tuneServerConfigFile();
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning WS7");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-web-tuning-error-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.deletePasswordFile();
            }
            catch (Exception exception) {}
        }
    }

    protected void tuneServerConfigFile() throws AMTuneException {
        try {
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-web-server-inst");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(this.tuneFile + " " + "(using wadm command line tool)");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-minthreads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            String curMinThreads = this.curCfgMap.get("min-threads").toString();
            this.mWriter.writeln("min-threads=" + curMinThreads);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("min-threads=" + curMinThreads);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-maxthreads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            String curMaxThreads = this.curCfgMap.get("max-threads").toString();
            this.mWriter.writeln("max-threads=" + curMaxThreads);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("max-threads=" + this.getMaxThreadPoolVal());
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-queuesize-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("queue-size=" + this.curCfgMap.get("queue-size"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("queue-size=8192");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-nativestacksize-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("stack-size=" + this.curCfgMap.get("stack-size"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            if (this.wsConfigInfo.isJVM64Bit()) {
                this.mWriter.writeln("stack-size=262144");
            } else {
                this.mWriter.writeln("Use current value");
            }
            this.mWriter.writelnLocaleMsg("pt-acceptorthreads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("acceptor-threads=" + this.curCfgMap.get("acceptor-threads"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("acceptor-threads=" + this.configInfo.getAcceptorThreads());
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-stats-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("enabled=" + this.curCfgMap.get("enabled"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("enabled=false");
            this.mWriter.writeln(" ");
            int newMinHeapVal = this.configInfo.getMaxHeapSize();
            int newMaxHeapVal = this.configInfo.getMaxHeapSize();
            if (newMinHeapVal > 12288) {
                newMinHeapVal = 12288;
            }
            String wsAdminNewMinHeap = "-Xms" + newMinHeapVal + "M";
            String wsAdminNewMaxHeap = "-Xmx" + newMaxHeapVal + "M";
            this.mWriter.writelnLocaleMsg("pt-maxminheap-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("Min Heap: " + this.curCfgMap.get("-Xms"));
            this.mWriter.writeln(" Max Heap: " + this.curCfgMap.get("-Xmx"));
            if (this.wsConfigInfo.isJVM64Bit() && this.configInfo.getMemToUse() > this.configInfo.getFAMTuneMaxMemoryToUseInMB()) {
                this.displayJVM64bitMessage(wsAdminNewMinHeap, wsAdminNewMaxHeap);
            } else {
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeln(wsAdminNewMinHeap + " " + wsAdminNewMaxHeap);
            }
            this.mWriter.writeln(" ");
            String wsAdminNewLoggcOutput = "-Xloggc:" + this.wsConfigInfo.getContainerInstanceDir() + "/" + "logs" + "/" + "gc.log";
            this.mWriter.writelnLocaleMsg("pt-loggcoutput-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xloggc"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewLoggcOutput);
            this.mWriter.writeln(" ");
            String wsAdminNewServerMode = "-server";
            this.mWriter.writelnLocaleMsg("pt-jvmserver-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-server"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewServerMode);
            this.mWriter.writeln(" ");
            String wsAdminNewStackSize = "";
            wsAdminNewStackSize = this.wsConfigInfo.isJVM64Bit() ? "-Xss" + this.configInfo.getFAMTunePerThreadStackSizeInKB64Bit() + "k" : "-Xss" + this.configInfo.getFAMTunePerThreadStackSizeInKB() + "k";
            this.mWriter.writelnLocaleMsg("pt-jvmstacksize-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xss"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewStackSize);
            this.mWriter.writeln(" ");
            String wsAdminNewNewSize = "-XX:NewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-newsize-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:NewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewNewSize);
            this.mWriter.writeln(" ");
            String wsAdminNewMaxNewSize = "-XX:MaxNewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-maxnewsize-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:MaxNewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewMaxNewSize);
            this.mWriter.writeln(" ");
            String wsAdminNewDisableExplicitGc = "-XX:+DisableExplicitGC";
            this.mWriter.writelnLocaleMsg("pt-disableexp-gc-mg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+DisableExplicitGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewDisableExplicitGc);
            this.mWriter.writeln(" ");
            String wsAdminNewUseParallelGc = "-XX:+UseParNewGC";
            this.mWriter.writelnLocaleMsg("pt-newpar-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseParNewGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewUseParallelGc);
            this.mWriter.writeln(" ");
            String wsAdminNewPrintClassHistogram = "-XX:+PrintClassHistogram";
            this.mWriter.writelnLocaleMsg("pt-prnclasshistogc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintClassHistogram"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewPrintClassHistogram);
            this.mWriter.writeln(" ");
            String wsAdminNewPrintGcTimeStamps = "-XX:+PrintGCTimeStamps";
            this.mWriter.writelnLocaleMsg("pt-prngctimestamp-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewPrintGcTimeStamps);
            this.mWriter.writeln(" ");
            String wsAdminNewUseConMarkSweepGc = "-XX:+UseConcMarkSweepGC";
            this.mWriter.writelnLocaleMsg("pt-concmskgc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(wsAdminNewUseConMarkSweepGc);
            this.mWriter.writeln(" ");
            String wsAdminCurParellelGCThreads = "";
            if (AMTuneUtil.isNiagara()) {
                this.mWriter.writelnLocaleMsg("pt-parallel-gc-threads-msg");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                wsAdminCurParellelGCThreads = "-XX:ParallelGCThreads=" + this.curCfgMap.get("-XX:ParallelGCThreads");
                this.mWriter.writeln(wsAdminCurParellelGCThreads);
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeLocaleMsg("pt-rec-none");
                this.mWriter.writeln(" ");
            }
            if (this.configInfo.isReviewMode()) {
                return;
            }
            String bakFile = this.wsConfigInfo.getContainerInstanceDir() + "/" + "server.xml-orig-" + AMTuneUtil.getRandomStr();
            AMTuneUtil.CopyFile(new File(this.tuneFile), new File(bakFile));
            boolean isThreadPoolPropChanged = false;
            if (!curMaxThreads.equals("default")) {
                int curMax = Integer.parseInt(curMaxThreads);
                if (curMax != this.getMaxThreadPoolVal()) {
                    isThreadPoolPropChanged = this.setThreadPoolProp();
                }
            } else {
                isThreadPoolPropChanged = this.setThreadPoolProp();
            }
            boolean isHttpListnerPropChanged = false;
            if (!this.curCfgMap.get("acceptor-threads").toString().equals("default")) {
                int curAcceptorT = Integer.parseInt(this.curCfgMap.get("acceptor-threads").toString());
                if (curAcceptorT != this.configInfo.getAcceptorThreads()) {
                    isHttpListnerPropChanged = this.setHttpListenerProp();
                }
            } else {
                isHttpListnerPropChanged = this.setHttpListenerProp();
            }
            boolean statsEnb = Boolean.parseBoolean(this.curCfgMap.get("enabled").toString());
            boolean isStatsChanged = false;
            if (statsEnb) {
                isStatsChanged = this.setStatsProp();
            }
            ArrayList curJVMHeapOptList = new ArrayList();
            ArrayList<String> newJVMHeapOptList = new ArrayList<String>();
            ArrayList<Object> curJVMOptList = new ArrayList<Object>();
            ArrayList<String> newJVMOptList = new ArrayList<String>();
            if (!this.curCfgMap.get("-Xms").toString().equals(wsAdminNewMinHeap)) {
                curJVMHeapOptList.add(this.curCfgMap.get("-Xms"));
                newJVMHeapOptList.add(wsAdminNewMinHeap);
            }
            if (!this.curCfgMap.get("-Xmx").toString().equals(wsAdminNewMaxHeap)) {
                curJVMHeapOptList.add(this.curCfgMap.get("-Xmx"));
                newJVMHeapOptList.add(wsAdminNewMaxHeap);
            }
            if (!this.curCfgMap.get("-server").toString().equals(wsAdminNewServerMode)) {
                curJVMOptList.add(this.curCfgMap.get("-server"));
                newJVMOptList.add(wsAdminNewServerMode);
            }
            if (!this.curCfgMap.get("-Xss").toString().equals(wsAdminNewStackSize)) {
                curJVMOptList.add(this.curCfgMap.get("-Xss"));
                newJVMOptList.add(wsAdminNewStackSize);
            }
            if (!this.curCfgMap.get("-Xloggc").toString().equals(wsAdminNewLoggcOutput)) {
                curJVMOptList.add(this.curCfgMap.get("-Xloggc"));
                newJVMOptList.add(wsAdminNewLoggcOutput);
            }
            if (!this.curCfgMap.get("-XX:NewSize").toString().equals(wsAdminNewNewSize)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:NewSize"));
                newJVMOptList.add(wsAdminNewNewSize);
            }
            if (!this.curCfgMap.get("-XX:MaxNewSize").toString().equals(wsAdminNewMaxNewSize)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:MaxNewSize"));
                newJVMOptList.add(wsAdminNewMaxNewSize);
            }
            if (!this.curCfgMap.get("-XX:+DisableExplicitGC").toString().equals(wsAdminNewDisableExplicitGc)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:+DisableExplicitGC"));
                newJVMOptList.add(wsAdminNewDisableExplicitGc);
            }
            if (!this.curCfgMap.get("-XX:+UseParNewGC").toString().equals(wsAdminNewUseParallelGc)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:+UseParNewGC"));
                newJVMOptList.add(wsAdminNewUseParallelGc);
            }
            if (!this.curCfgMap.get("-XX:+PrintClassHistogram").toString().equals(wsAdminNewPrintClassHistogram)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:+PrintClassHistogram"));
                newJVMOptList.add(wsAdminNewPrintClassHistogram);
            }
            if (!this.curCfgMap.get("-XX:+PrintGCTimeStamps").toString().equals(wsAdminNewPrintGcTimeStamps)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
                newJVMOptList.add(wsAdminNewPrintGcTimeStamps);
            }
            if (!this.curCfgMap.get("-XX:+UseConcMarkSweepGC").toString().equals(wsAdminNewUseConMarkSweepGc)) {
                curJVMOptList.add(this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
                newJVMOptList.add(wsAdminNewUseConMarkSweepGc);
            }
            if (AMTuneUtil.isNiagara() && wsAdminCurParellelGCThreads.indexOf("<No value set>") == -1) {
                curJVMOptList.add(wsAdminCurParellelGCThreads);
            }
            boolean isHeapOptDel = this.deleteJVMOptionUsingWSAdmin(curJVMHeapOptList, true);
            boolean isJvmOptDel = this.deleteJVMOptionUsingWSAdmin(curJVMOptList, false);
            boolean isInsertHeapOpt = this.insertJVMOptionUsingWSAdmin(newJVMHeapOptList, true);
            boolean isInsertJVMOpt = this.insertJVMOptionUsingWSAdmin(newJVMOptList, false);
            if (isThreadPoolPropChanged || isHttpListnerPropChanged || isStatsChanged || isHeapOptDel || isJvmOptDel || isInsertHeapOpt || isInsertJVMOpt) {
                boolean retVal = this.deployConfig();
                if (retVal) {
                    AMTuneUtil.reStartWS7Serv(this.wsConfigInfo);
                } else {
                    this.mWriter.writelnLocaleMsg("pt-error-ws-deployment-failed");
                }
            } else {
                this.mWriter.writelnLocaleMsg("pt-web-conf-same-rec-msg");
            }
        }
        catch (AMTuneException amex) {
            this.pLogger.log(Level.SEVERE, "tuneServerConfigFile", "Error tuning webserver7 configuration.");
            throw amex;
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneServerConfigFile", ex);
            throw new AMTuneException(ex.getMessage());
        }
    }

    private boolean deployConfig() {
        try {
            this.pLogger.log(Level.INFO, "deployConfig", "Deploying configuration.");
            String deployCmd = this.wsConfigInfo.getWSAdminCmd() + "deploy-config" + " --force " + this.wsConfigInfo.getWSAdmCommonParamsNoConfig() + " " + this.wsConfigInfo.getWSAdminConfig();
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(deployCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
            if (retVal == -1 && resultBuffer.toString().indexOf(":125") == -1) {
                this.pLogger.log(Level.SEVERE, "deployConfig", "Error executing command " + deployCmd);
                return false;
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "deployConfig", "Deploying configuration failed. " + ex.getMessage());
        }
        return true;
    }

    private boolean setStatsProp() {
        boolean statsChange = false;
        try {
            String statsCmd = this.wsConfigInfo.getWSAdminCmd() + "set-stats-prop" + this.wsConfigInfo.getWSAdminCommonParams() + " " + "enabled" + "=" + false;
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(statsCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "setStatsProp", "Error executing command " + statsCmd);
            } else {
                statsChange = true;
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "setStatsProp", "Error setting set-thread-pool-prop " + ex.getMessage());
        }
        return statsChange;
    }

    private boolean setHttpListenerProp() {
        boolean listenerChange = false;
        try {
            String setListenerCmd = this.wsConfigInfo.getWSAdminCmd() + "set-http-listener-prop" + this.wsConfigInfo.getWSAdminCommonParams() + " --http-listener=" + this.wsConfigInfo.getWSAdminHttpListener() + " acceptor-threads=" + this.configInfo.getAcceptorThreads();
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(setListenerCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "setHttpListenerProp", "Error executing command " + setListenerCmd);
            } else {
                listenerChange = true;
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "setHttpListenerProp", "Error setting set-http-listener-prop " + ex.getMessage());
        }
        return listenerChange;
    }

    private boolean setThreadPoolProp() {
        boolean threadPoolPropChange = false;
        try {
            this.pLogger.log(Level.INFO, "setThreadPoolProp", "Setting set-thread-pool-prop using wadm command.");
            String commonParam = "max-threads=" + this.getMaxThreadPoolVal() + " " + "queue-size" + "=" + 8192;
            String parmStr64Bit = commonParam + " " + "stack-size" + "=" + 262144;
            String setProp64Cmd = this.wsConfigInfo.getWSAdminCmd() + "set-thread-pool-prop" + this.wsConfigInfo.getWSAdminCommonParams() + " " + parmStr64Bit;
            String setPropCmd = this.wsConfigInfo.getWSAdminCmd() + "set-thread-pool-prop" + this.wsConfigInfo.getWSAdminCommonParams() + " " + commonParam;
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = 0;
            if (this.wsConfigInfo.isJVM64Bit()) {
                retVal = AMTuneUtil.executeCommand(setProp64Cmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
                if (retVal == -1) {
                    this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                    this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                    this.pLogger.log(Level.SEVERE, "setThreadPoolProp", "Error executing command " + setProp64Cmd);
                } else {
                    threadPoolPropChange = true;
                }
            } else {
                retVal = AMTuneUtil.executeCommand(setPropCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
                if (retVal == -1) {
                    this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                    this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                    this.pLogger.log(Level.SEVERE, "setThreadPoolProp", "Error executing command " + setPropCmd);
                } else {
                    threadPoolPropChange = true;
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "setThreadPoolProp", "Error setting set-thread-pool-prop " + ex.getMessage());
        }
        return threadPoolPropChange;
    }

    private void displayJVM64bitMessage(String calMaxHeapSize, String calMinHeapSize) {
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg1");
        this.mWriter.write("                     : " + this.configInfo.getMemToUse());
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg2");
        this.mWriter.write("                     : ");
        this.mWriter.writeLocaleMsg("pt-web-64bit-jvm-rec-msg3");
        this.mWriter.writeln("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO, in amtune-env");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg4");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg5");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg6");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg7");
        this.mWriter.writeln(" ");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-cur-msg1");
        this.mWriter.write("                     : ");
        this.mWriter.writeln("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO=" + this.configInfo.getFAMTuneMemMaxHeapSizeRatioExp());
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-cur-msg2");
        this.mWriter.write("                     : ");
        this.mWriter.writeln("Min Heap: " + calMaxHeapSize + " Max Heap: " + calMinHeapSize);
    }

    private boolean deleteJVMOptionUsingWSAdmin(List jvmOptions, boolean combined) {
        if (jvmOptions.size() == 0) {
            this.pLogger.log(Level.WARNING, "deleteJVMOptionUsingWSAdmin", "JVM to be deleted are null");
            return false;
        }
        this.mWriter.writeln(" ");
        this.mWriter.writeLocaleMsg("pt-web-del-jvm-options");
        this.mWriter.writeln(jvmOptions.toString().replace("<No value set>", ""));
        StringBuffer jvmOpts = new StringBuffer();
        Iterator optItr = jvmOptions.iterator();
        if (combined) {
            jvmOpts.append("\"");
        }
        while (optItr.hasNext()) {
            String val = (String)optItr.next();
            if (val == null || val.trim().length() <= 0 || val.equals("<No value set>")) continue;
            jvmOpts.append(val);
            jvmOpts.append(" ");
        }
        if (jvmOpts.toString().trim().length() < 1) {
            this.pLogger.log(Level.INFO, "deleteJVMOptionUsingWSAdmin", "Nothing to delete from webserver config.");
            return false;
        }
        String delJVMCmd = this.wsConfigInfo.getWSAdminCmd() + "delete-jvm-options" + this.wsConfigInfo.getWSAdminCommonParams() + " -- " + jvmOpts.toString();
        delJVMCmd = delJVMCmd.trim();
        if (combined) {
            delJVMCmd = delJVMCmd + "\"";
        }
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = -1;
        try {
            retVal = !AMTuneUtil.isWindows() ? AMTuneUtil.executeScriptCmd(delJVMCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer) : AMTuneUtil.executeCommand(delJVMCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
        }
        catch (AMTuneException aex) {
            this.pLogger.log(Level.WARNING, "deleteJVMOptionUsingWSAdmin", "Deleting jvm opt failed" + aex.getMessage());
            retVal = -1;
        }
        if (retVal == -1) {
            this.mWriter.writelnLocaleMsg("pt-del-jvm-error-msg");
            return false;
        }
        return true;
    }

    private boolean insertJVMOptionUsingWSAdmin(List jvmOptions, boolean combined) {
        if (jvmOptions.size() == 0) {
            this.pLogger.log(Level.WARNING, "insertJVMOptionUsingWSAdmin", "JVM options to add are null");
            return false;
        }
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-web-add-jvm-options");
        this.mWriter.writeln(jvmOptions.toString());
        StringBuffer jvmOpts = new StringBuffer();
        Iterator optItr = jvmOptions.iterator();
        if (combined) {
            jvmOpts.append("\"");
        }
        while (optItr.hasNext()) {
            String val = (String)optItr.next();
            if (val == null || val.trim().length() <= 0) continue;
            jvmOpts.append(val);
            jvmOpts.append(" ");
        }
        String addJVMCmd = this.wsConfigInfo.getWSAdminCmd() + "create-jvm-options" + this.wsConfigInfo.getWSAdminCommonParams() + " -- " + jvmOpts.toString();
        addJVMCmd = addJVMCmd.trim();
        if (combined) {
            addJVMCmd = addJVMCmd + "\"";
        }
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = 0;
        try {
            retVal = AMTuneUtil.isWindows() ? AMTuneUtil.executeCommand(addJVMCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer) : AMTuneUtil.executeScriptCmd(addJVMCmd, this.passwordStr, this.wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
        }
        catch (AMTuneException ex) {
            this.pLogger.log(Level.WARNING, "insertJVMOptionUsingWSAdmin", "Inserting jvm opts failed " + ex.getMessage());
            retVal = -1;
        }
        if (retVal == -1) {
            this.mWriter.writelnLocaleMsg("pt-create-jvm-opts-error-msg");
            this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
            return false;
        }
        return true;
    }

    protected void deletePasswordFile() {
        AMTuneUtil.deleteFile(this.wsConfigInfo.getWSAdminPassFilePath());
    }

    private int getMaxThreadPoolVal() {
        int recMaxThreadPool = this.configInfo.getNumOfMaxThreadPool();
        if (recMaxThreadPool < 256) {
            recMaxThreadPool = 256;
        }
        if (recMaxThreadPool > 512) {
            recMaxThreadPool = 512;
        }
        return recMaxThreadPool;
    }

    private void validateInstanceDir() throws AMTuneException {
        File serConfFile = new File(this.tuneFile);
        if (!serConfFile.exists()) {
            this.mWriter.writelnLocaleMsg("pt-error-ws-conf-file-not-found");
            AMTuneUtil.printErrorMsg("CONTAINER_INSTANCE_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ws-invalid-instance-dir"));
        }
    }
}

