/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.util;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneFileFilter;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.common.OutputReaderThread;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.WS7ContainerConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AMTuneUtil
implements AMTuneConstants {
    private static AMTuneLogger pLogger;
    private static MessageWriter mWriter;
    private static boolean isWindows2003;
    private static boolean isWinVista;
    private static boolean isWindows2008;
    private static boolean isSunOs;
    private static boolean isLinux;
    private static boolean isAix;
    private static String tempFile;
    private static Map sysInfoMap;
    private static boolean utilInit;
    private static String osArch;
    private static boolean isNiagara_I;
    private static boolean isNiagara_II;
    private static boolean isNiagara_II_Plus;
    private static String date;
    private static ResourceBundle rb;
    public static String TMP_DIR;

    public static boolean initializeUtil() throws AMTuneException {
        date = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz").format(new Date());
        mWriter = MessageWriter.getInstance();
        AMTuneUtil.checkSystemEnv();
        AMTuneUtil.setTmpDir();
        tempFile = TMP_DIR + "perftune-temp.txt";
        sysInfoMap = new HashMap();
        try {
            if (AMTuneUtil.isWindows()) {
                AMTuneUtil.getWinSystemInfo();
                File temp = new File(tempFile);
                if (temp.isFile()) {
                    temp.delete();
                }
            } else if (AMTuneUtil.isSunOs()) {
                AMTuneUtil.checkRootUser();
                AMTuneUtil.getSunOSSystemInfo();
            } else if (AMTuneUtil.isLinux()) {
                AMTuneUtil.checkRootUser();
                AMTuneUtil.getLinuxSystemInfo();
            } else if (isAix) {
                AMTuneUtil.checkRootUser();
                AMTuneUtil.getAIXSystemInfo();
            } else {
                utilInit = false;
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-os"));
            }
            pLogger.log(Level.FINEST, "initializeUtil", "System configuration : " + sysInfoMap.toString());
        }
        catch (Exception ex) {
            pLogger.logException("perftuneutilinit", ex);
            utilInit = false;
            throw new AMTuneException(ex.getMessage());
        }
        return utilInit;
    }

    private static void checkSystemEnv() throws AMTuneException {
        mWriter.writelnLocaleMsg("pt-checking-system-env");
        osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        pLogger.log(Level.INFO, "checkSystemEnv", "OS name :" + osName);
        pLogger.log(Level.INFO, "checkSystemEnv", "OS Version :" + osVersion);
        pLogger.log(Level.INFO, "checkSystemEnv", "OS Arch :" + osArch);
        if (osName.equalsIgnoreCase("SUNOS")) {
            isSunOs = true;
            if (osArch.contains("sparc") || osArch.contains("86")) {
                int solVersion = Integer.parseInt(osVersion.replace("5.", ""));
                if (solVersion > 8) {
                    return;
                }
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-sol"));
            }
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-arch"));
        }
        if (osName.equalsIgnoreCase("Windows 2003")) {
            isWindows2003 = true;
        } else if (osName.equalsIgnoreCase("Windows Vista")) {
            isWinVista = true;
        } else if (osName.equalsIgnoreCase("Windows Server 2008")) {
            isWindows2008 = true;
        } else if (osName.equalsIgnoreCase("Linux")) {
            isLinux = true;
        } else if (osName.equalsIgnoreCase("AIX")) {
            isAix = true;
        } else {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-os"));
        }
    }

    private static void getAIXSystemInfo() throws AMTuneException {
        AMTuneUtil.getCommonNXSystemInfo();
        String nCmd = "/usr/sbin/prtconf";
        String memSizeStr = "Memory Size: ";
        String noProcessorStr = "Number Of Processors:";
        StringBuffer rBuf = new StringBuffer();
        int extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
        if (extVal == -1) {
            mWriter.writelnLocaleMsg("pt-cannot-proceed");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-avmem"));
        }
        try {
            StringTokenizer st = new StringTokenizer(rBuf.toString(), "\n");
            while (st.hasMoreTokens()) {
                String noProcessors;
                String reqLine = st.nextToken();
                if (reqLine.indexOf(memSizeStr) == 0) {
                    String size = reqLine.replace(memSizeStr, "").replace(" MB", "");
                    pLogger.log(Level.FINEST, "getAIXSystemInfo", "RAM size is " + size);
                    sysInfoMap.put("Total Physical Memory:", size);
                    continue;
                }
                if (reqLine.indexOf(noProcessorStr) == -1 || (noProcessors = reqLine.replace(noProcessorStr, "")) == null || noProcessors.trim().length() <= 0) continue;
                pLogger.log(Level.FINEST, "getAIXSystemInfo", "Number of Processors " + noProcessors);
                sysInfoMap.put("Processor", noProcessors.trim());
            }
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getAIXSystemInfo", "Error finding AIX system info : ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void getSunOSSystemInfo() throws AMTuneException {
        try {
            AMTuneUtil.getCommonNXSystemInfo();
            String nCmd = "/bin/uname -i";
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-hw-pt"));
            }
            String hwPlatform = rBuf.toString();
            if (hwPlatform == null || hwPlatform.trim().length() <= 0) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-hw-pt"));
            }
            sysInfoMap.put("HWPLATFORM", hwPlatform.trim());
            nCmd = "/usr/sbin/psrinfo";
            rBuf.setLength(0);
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-no-cpu"));
            }
            int noCpus = AMTuneUtil.getWordCount(rBuf.toString(), "on-line");
            if (noCpus == 0) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-no-cpu"));
            }
            AMTuneUtil.setNiagaraBoxType(hwPlatform);
            if (AMTuneUtil.isNiagara_I()) {
                pLogger.log(Level.INFO, "getSunOSSystemInfo", "Tuning T1 box");
                noCpus = noCpus >= 4 ? (noCpus /= 4) : 1;
            } else if (AMTuneUtil.isNiagara_II() || AMTuneUtil.isNiagara_II_Plus()) {
                pLogger.log(Level.INFO, "getSunOSSystemInfo", "Tuning T2 or T2 Plus box");
                noCpus = noCpus >= 8 ? (noCpus /= 8) : 1;
            }
            sysInfoMap.put("Processor", Integer.toString(noCpus));
            rBuf.setLength(0);
            nCmd = "/usr/sbin/prtconf";
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-avmem"));
            }
            StringTokenizer st = new StringTokenizer(rBuf.toString(), "\n");
            while (st.hasMoreTokens()) {
                String reqLine = st.nextToken();
                if (reqLine.indexOf("Memory size: ") < 0) continue;
                String size = reqLine.replace("Memory size: ", "").replace(" Megabytes", "");
                sysInfoMap.put("Total Physical Memory:", size);
            }
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getSunOSSystemInfo", "Error finding SUNOS system information ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void getCommonNXSystemInfo() throws AMTuneException {
        try {
            String nCmd = "/bin/domainname";
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-domainname"));
            }
            String domainName = rBuf.toString();
            if (domainName == null || domainName.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-domainname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-domain-name"));
            }
            sysInfoMap.put("Domain:", domainName.trim());
            nCmd = "/bin/hostname";
            rBuf.setLength(0);
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-hostname"));
            }
            String hostName = rBuf.toString();
            if (hostName != null && hostName.trim().length() > 1) {
                if (hostName.indexOf(".") != -1) {
                    hostName = hostName.substring(0, hostName.indexOf("."));
                }
            } else {
                mWriter.writeLocaleMsg("pt-unable-hostname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-host-name"));
            }
            sysInfoMap.put("Host Name:", hostName.trim() + "." + domainName.trim());
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getCommonNXSystemInfo", "Error finding hostname or domain name.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void getLinuxSystemInfo() throws AMTuneException {
        try {
            AMTuneUtil.getCommonNXSystemInfo();
            FileHandler fh = new FileHandler("/proc/meminfo");
            String memSize = fh.getLine("MemTotal:").replace("MemTotal:", "");
            memSize = memSize.replace("kB", "");
            memSize = memSize.trim();
            if (memSize == null) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-avmem"));
            }
            int size = Integer.parseInt(memSize) / 1024;
            sysInfoMap.put("Total Physical Memory:", Integer.toString(size));
            FileHandler fh2 = new FileHandler("/proc/cpuinfo");
            String[] lines = fh2.getMattchingLines("processor", false);
            if (lines.length < 0) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-no-cpu"));
            }
            sysInfoMap.put("Processor", Integer.toString(lines.length));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getLinuxSystemInfo", "Error finding LINUX System information");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void checkRootUser() throws AMTuneException {
        String userName = System.getProperty("user.name");
        mWriter.writelnLocaleMsg("pt-check-user");
        if (userName.indexOf("root") < 0) {
            mWriter.writelnLocaleMsg("pt-cannot-proceed");
            mWriter.writelnLocaleMsg("pt-should-be-root-user");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-root-user-error"));
        }
    }

    private static void getWinSystemInfo() throws AMTuneException {
        try {
            String hostNameCmd = "cmd /C systeminfo > " + tempFile;
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(hostNameCmd, rBuf);
            if (extVal == -1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-finding-sys-info"));
            }
            FileHandler fh = new FileHandler(tempFile);
            String reqLine = fh.getLine("Domain:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-domainname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-domain-name"));
            }
            int startIdx = reqLine.lastIndexOf(":");
            String domainName = reqLine.substring(startIdx + 1).trim();
            reqLine = fh.getLine("Host Name:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-hostname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-host-name"));
            }
            int startIdx2 = reqLine.lastIndexOf(":");
            String hostName = reqLine.substring(startIdx2 + 1).trim();
            domainName = domainName.replace(hostName + ".", "");
            sysInfoMap.put("Host Name:", hostName + "." + domainName.trim());
            sysInfoMap.put("Domain:", domainName);
            reqLine = fh.getLine("Processor");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-no-cpu"));
            }
            int startIdx3 = reqLine.lastIndexOf(":");
            String numProcessors = reqLine.substring(startIdx3 + 1).trim();
            numProcessors = numProcessors.substring(0, 2).trim();
            sysInfoMap.put("Processor", numProcessors);
            reqLine = fh.getLine("Total Physical Memory:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-avmem"));
            }
            int startIdx4 = reqLine.lastIndexOf(":");
            String memSize = reqLine.substring(startIdx4 + 1).trim();
            StringTokenizer st = new StringTokenizer(memSize, " ");
            st.hasMoreTokens();
            memSize = st.nextToken();
            memSize = memSize.replace(",", "");
            sysInfoMap.put("Total Physical Memory:", memSize);
            if (hostName != null && domainName != null) {
                domainName = domainName.replace(hostName.toLowerCase() + ".", "");
                sysInfoMap.put("Host Name:", hostName + "." + domainName);
            }
            fh.close();
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getWinSystemInfo", "Error finding system information ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getHostName() {
        return (String)sysInfoMap.get("Host Name:");
    }

    public static String getDomainName() {
        return (String)sysInfoMap.get("Domain:");
    }

    public static String getNumberOfCPUS() {
        return (String)sysInfoMap.get("Processor");
    }

    public static String getSystemMemory() {
        return (String)sysInfoMap.get("Total Physical Memory:");
    }

    public static String getOSPlatform() {
        return osArch;
    }

    public static String getHardWarePlatform() {
        return (String)sysInfoMap.get("HWPLATFORM");
    }

    public static int executeCommand(String command, StringBuffer resultBuffer) {
        pLogger.log(Level.FINEST, "executeCommand", "Executing command : " + command);
        try {
            Process execProcess = null;
            execProcess = Runtime.getRuntime().exec(command);
            if (resultBuffer != null) {
                resultBuffer.setLength(0);
            }
            OutputReaderThread outReaderThread = new OutputReaderThread(execProcess.getInputStream());
            OutputReaderThread errorReaderThread = new OutputReaderThread(execProcess.getErrorStream());
            outReaderThread.start();
            errorReaderThread.start();
            execProcess.waitFor();
            int exitValue = execProcess.exitValue();
            outReaderThread.join(3000L);
            errorReaderThread.join(3000L);
            execProcess.destroy();
            outReaderThread.interrupt();
            errorReaderThread.interrupt();
            boolean errorOccured = false;
            if (resultBuffer != null) {
                StringBuffer outBuffer = outReaderThread.getBuffer();
                StringBuffer errorBuffer = errorReaderThread.getBuffer();
                if (outBuffer != null && outBuffer.length() != 0) {
                    pLogger.log(Level.FINEST, "executeCommand", "Out buffer content : " + outBuffer.toString());
                    resultBuffer.append(outBuffer.toString());
                }
                if (errorBuffer != null && errorBuffer.length() != 0) {
                    pLogger.log(Level.FINEST, "executeCommand", "Error buffer content : " + errorBuffer.toString());
                    resultBuffer.append(errorBuffer.toString());
                    errorOccured = true;
                }
            }
            if (exitValue != 0 && errorOccured) {
                resultBuffer.append("\n Exit value:" + exitValue);
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-cmd-error"));
            }
            pLogger.log(Level.INFO, "executeCommand", "Command exit value " + exitValue);
            return exitValue;
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "executeCommand", "Executing command " + command + " failed.");
            pLogger.logException("executeCommand", ex);
            pLogger.log(Level.SEVERE, "executeCommand", "Error is : " + resultBuffer.toString());
            resultBuffer.insert(0, ex.getMessage());
            return -1;
        }
    }

    public static int executeScriptCmd(String command, StringBuffer resultBuffer) throws AMTuneException {
        int extVal = -1;
        String tempF = TMP_DIR + "amtunecmdhelper.sh";
        try {
            if (!AMTuneUtil.isWindows()) {
                pLogger.log(Level.FINE, "executeScriptCmd", "Command in the file :" + command);
                File tempSh = new File(tempF);
                BufferedWriter br = new BufferedWriter(new FileWriter(tempSh));
                br.write(command);
                br.close();
                AMTuneUtil.changeFilePerm(tempF, "700");
                extVal = AMTuneUtil.executeCommand(tempF, resultBuffer);
                tempSh.delete();
            }
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            File tempSh = new File(tempF);
            if (tempSh.isFile()) {
                tempSh.delete();
            }
        }
        return extVal;
    }

    public static double evaluteDivExp(String divExp) throws NumberFormatException, NullPointerException {
        StringTokenizer st = new StringTokenizer(divExp, "/");
        st.hasMoreTokens();
        double operand1 = Double.parseDouble(st.nextToken().trim());
        st.hasMoreTokens();
        double operand2 = Double.parseDouble(st.nextToken().trim());
        return operand1 / operand2;
    }

    public static long getDirSize(String directory) {
        long size = 0L;
        File instanceDir = new File(directory);
        String[] list = instanceDir.list();
        for (int i = 0; i < list.length; ++i) {
            File tFile = new File(directory + "/" + list[i]);
            if (tFile.isDirectory()) {
                size += AMTuneUtil.getDirSize(directory + "/" + list[i]);
                continue;
            }
            size += tFile.length();
        }
        return size;
    }

    public static void replaceToken(StringBuffer buf, String key, String value) {
        if (key == null || value == null || buf == null) {
            return;
        }
        int loc = 0;
        int keyLen = key.length();
        int valLen = value.length();
        while ((loc = buf.toString().indexOf(key, loc)) != -1) {
            buf.replace(loc, loc + keyLen, value);
            loc += valLen;
        }
    }

    public static String getRandomStr() {
        String DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss";
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String rand = df.format(new Date(System.currentTimeMillis()));
        return rand;
    }

    public static void CopyFile(File source, File dest) throws Exception {
        if (source == null || dest == null) {
            throw new IllegalArgumentException();
        }
        pLogger.log(Level.FINEST, "CopyFile", "Copying file from " + source.toString() + " to " + dest.toString());
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static boolean isWindows() {
        return isWinVista || isWindows2003 || isWindows2008;
    }

    public static boolean isSunOs() {
        return isSunOs;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isAIX() {
        return isAix;
    }

    public static boolean isNiagara() {
        return isNiagara_I || isNiagara_II || isNiagara_II_Plus;
    }

    public static boolean isNiagara_I() {
        return isNiagara_I;
    }

    public static boolean isNiagara_II() {
        return isNiagara_II;
    }

    public static boolean isNiagara_II_Plus() {
        return isNiagara_II_Plus;
    }

    private static void setNiagaraBoxType(String hwPlatform) {
        pLogger.log(Level.FINEST, "setNiagaraBoxType", "Finding box type");
        if (hwPlatform != null) {
            if (hwPlatform.indexOf("T100") != -1 || hwPlatform.indexOf("T200") != -1) {
                isNiagara_I = true;
                pLogger.log(Level.FINEST, "setNiagaraBoxType", "T1 ");
            } else if (hwPlatform.indexOf("T5120") != -1 || hwPlatform.indexOf("T5220") != -1) {
                isNiagara_II = true;
                pLogger.log(Level.FINEST, "setNiagaraBoxType", "T2");
            } else if (hwPlatform.indexOf("T5140") != -1 || hwPlatform.indexOf("T5240") != -1 || hwPlatform.indexOf("T5440") != -1) {
                isNiagara_II_Plus = true;
                pLogger.log(Level.FINEST, "setNiagaraBoxType", "T2 Plus");
            }
        }
    }

    public static String getLastToken(String stream, String delim) {
        String val = " ";
        if (stream != null && stream.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(stream, delim);
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
            }
        }
        return val;
    }

    public static void backupConfigFile(String confFile, String backupDir) throws AMTuneException {
        try {
            File confF = new File(confFile);
            if (!confF.isFile()) {
                mWriter.writelnLocaleMsg("pt-conf-file-missing");
                throw new AMTuneException("Config file " + confFile + " is missing.");
            }
            File bkDir = new File(AMTuneUtil.getCurDir() + ".." + "/" + ".." + "/" + backupDir);
            if (!bkDir.isDirectory()) {
                bkDir.mkdirs();
            }
            String baseFileName = confF.getName();
            String bkFileName = bkDir + "/" + baseFileName + "-orig-" + AMTuneUtil.getRandomStr();
            mWriter.writeLocaleMsg("pt-bk-file");
            mWriter.writeln(" " + confFile + " to " + bkFileName);
            AMTuneUtil.CopyFile(new File(confFile), new File(bkFileName));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "backupConfigFile", "Couldn't backup file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static void backupConfigFile(String confFile) throws AMTuneException {
        try {
            File confF = new File(confFile);
            if (!confF.exists()) {
                mWriter.writelnLocaleMsg("pt-conf-file-missing");
                throw new AMTuneException("Config file " + confFile + " is missing.");
            }
            String bkDir = confF.getParent();
            String baseFileName = confF.getName();
            String bkFileName = bkDir + "/" + baseFileName + "-orig-" + AMTuneUtil.getRandomStr();
            mWriter.writeLocaleMsg("pt-bk-file");
            mWriter.writeln(" " + confFile + " to " + bkFileName);
            AMTuneUtil.CopyFile(new File(confFile), new File(bkFileName));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "backupConfigFile", "Couldn't backup file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getCurDir() {
        File tempF = new File("tempdbk");
        String filePath = tempF.getAbsolutePath();
        filePath = filePath.replace("tempdbk", "");
        return filePath;
    }

    public static void writeResultBufferToTempFile(StringBuffer buf, String tFile) throws AMTuneException {
        try {
            FileWriter fw = new FileWriter(new File(tFile));
            fw.write(buf.toString());
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "writeResultBufferToTempFile", "Couldn't write buffer to file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getASJVMOption(List curOptList, String reqFlag, boolean lastToken) {
        for (String curFlag : curOptList) {
            if (curFlag.indexOf(reqFlag) == -1) continue;
            if (lastToken) {
                return AMTuneUtil.getLastToken(curFlag, "=");
            }
            return curFlag;
        }
        return "<No value set>";
    }

    public static int getWordCount(String str, String reqWord) {
        StringTokenizer st = new StringTokenizer(str, "\n");
        pLogger.log(Level.FINEST, "getWordCount", "Source string :" + str);
        pLogger.log(Level.FINEST, "getWordCount", "Word to find :" + reqWord);
        int count = 0;
        while (st.hasMoreTokens()) {
            String reqStr = st.nextToken();
            if (!reqStr.contains(reqWord)) continue;
            ++count;
        }
        return count;
    }

    public static String[] getMatchedLines(String[] lines, String pattern) {
        ArrayList<String> matList = new ArrayList<String>();
        Pattern p = Pattern.compile(pattern);
        int size = lines.length;
        int i = 0;
        for (i = 0; i < size; ++i) {
            Matcher m = p.matcher(lines[i]);
            if (!m.find()) continue;
            matList.add(lines[i]);
        }
        String[] arr = new String[matList.size()];
        for (i = 0; i < matList.size(); ++i) {
            arr[i] = new String(matList.get(i).toString());
        }
        return arr;
    }

    public static String getMatchedLine(List lines, String pattern) {
        Iterator itr = lines.iterator();
        while (itr.hasNext()) {
            String curLine = itr.next().toString();
            if (curLine.indexOf(pattern) == -1) continue;
            return curLine;
        }
        return null;
    }

    public static String getTodayDateStr() {
        return date;
    }

    public static void printErrorMsg(String propertyName) {
        mWriter.writelnLocaleMsg("pt-cannot-proceed");
        mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
        mWriter.writeln(propertyName);
    }

    public static List getTokensList(String line, String delim) {
        StringTokenizer str = new StringTokenizer(line, delim);
        ArrayList<String> tokens = new ArrayList<String>();
        while (str.hasMoreTokens()) {
            tokens.add(str.nextToken());
        }
        return tokens;
    }

    public static void reStartWS7Serv(WS7ContainerConfigInfo wsConfigInfo) {
        try {
            pLogger.log(Level.INFO, "reStartServ", "Deploying configuration.");
            StringBuffer restartCmd = new StringBuffer(wsConfigInfo.getWSAdminCmd());
            restartCmd.append("restart-instance");
            restartCmd.append(wsConfigInfo.getWSAdminCommonParams());
            String passwordStr = "wadm_password=" + wsConfigInfo.getWsAdminPass();
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(restartCmd.toString(), passwordStr, wsConfigInfo.getWSAdminPassFilePath(), resultBuffer);
            if (retVal == -1) {
                mWriter.writelnLocaleMsg("pt-error-ws-deployment-failed");
                pLogger.log(Level.SEVERE, "reStartServ", "Error executing command " + restartCmd);
            }
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "reStartServ", "Restart failed. " + ex.getMessage());
        }
    }

    public static boolean isSupportedWebContainer(String webContainer) {
        return webContainer.equalsIgnoreCase("WS7") || webContainer.equalsIgnoreCase("AS91");
    }

    public static boolean isSupportedUMDSVersion(String dsVersion) {
        return (dsVersion.indexOf("6.") != -1 || dsVersion.indexOf("5.") != -1) && !dsVersion.equalsIgnoreCase("6.2");
    }

    private static void setTmpDir() {
        TMP_DIR = AMTuneUtil.isSunOs() || AMTuneUtil.isLinux() || AMTuneUtil.isAIX() ? "/tmp/" : System.getProperty("java.io.tmpdir");
    }

    public static List getFileList(String directory) throws AMTuneException {
        ArrayList<String> allFiles = new ArrayList<String>();
        File instanceDir = new File(directory);
        if (instanceDir != null && !instanceDir.isDirectory()) {
            pLogger.log(Level.SEVERE, "getFileList", "Directory not present :" + directory);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-not-valid-dir"));
        }
        String[] list = instanceDir.list();
        for (int i = 0; i < list.length; ++i) {
            File tFile = new File(directory + "/" + list[i]);
            if (tFile.isDirectory()) {
                List curList = AMTuneUtil.getFileList(tFile.toString());
                Iterator itr = curList.iterator();
                while (itr.hasNext()) {
                    allFiles.add(itr.next().toString());
                }
            }
            allFiles.add(tFile.toString());
        }
        pLogger.log(Level.FINEST, "getFileList", "Returning files " + ((Object)allFiles).toString());
        return allFiles;
    }

    public static String createZipFile(String directory, String zipName) throws AMTuneException {
        ZipOutputStream out = null;
        FileInputStream in = null;
        File zipFile = new File(zipName + ".zip");
        if (zipFile.isFile()) {
            pLogger.log(Level.FINEST, "createZipFile", "Deleting existing zip file.");
            zipFile.delete();
        }
        try {
            List entries = AMTuneUtil.getFileList(directory);
            byte[] buffer = new byte[4096];
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                int bytesRead;
                File f = new File(itr.next().toString());
                pLogger.log(Level.FINEST, "createZipFile", "Zipping file " + f.toString());
                if (f.isDirectory()) continue;
                in = new FileInputStream(f);
                ZipEntry entry = new ZipEntry(f.getPath());
                out.putNextEntry(entry);
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                in.close();
            }
            String string = zipFile.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "createZipFile", "Exception while creating zip file " + ex.getMessage());
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-zip-file"));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static void deleteDirectory(String directory) {
        try {
            List delFiles = AMTuneUtil.getFileList(directory);
            Iterator dlItr = delFiles.iterator();
            while (dlItr.hasNext()) {
                File delFile = new File(dlItr.next().toString());
                delFile.delete();
            }
            File delD = new File(directory);
            delD.delete();
        }
        catch (Exception ex) {
            pLogger.log(Level.WARNING, "deleteDirectory", "Error occured while deleting the files :" + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRemoteDSTuningZipFile(AMTuneConfigInfo configInfo) {
        String baseDir = "remotedstune/";
        try {
            pLogger.log(Level.INFO, "createRemoteDSTuningZipFile", "Creating amtune.zip file.");
            mWriter.writelnLocaleMsg("pt-ds-create-tar");
            String curDir = AMTuneUtil.getCurDir();
            String zBinDir = baseDir + "bin";
            String zLibDir = baseDir + "lib";
            String zLocaleDir = baseDir + "resources";
            String zLdifDir = baseDir + "ldif";
            String zBinWinDir = zBinDir + "/" + "windows";
            String zBinUnxDir = zBinDir + "/" + "unix";
            String[] reqDirs = new String[]{zBinDir, zLibDir, zLocaleDir, zLdifDir, zBinWinDir, zBinUnxDir};
            for (int i = 0; i < reqDirs.length; ++i) {
                File dir = new File(reqDirs[i]);
                if (dir.isDirectory()) continue;
                pLogger.log(Level.FINEST, "createRemoteDSTuningZipFile", "Creating directory " + dir.toString());
                dir.mkdirs();
            }
            String[][] filesToCopy = new String[][]{{"../../../lib/amtune.jar", zLibDir + "/" + "amtune.jar"}, {"../../../lib/opensso-sharedlib.jar", zLibDir + "/" + "opensso-sharedlib.jar"}, {"../../../template/unix/bin/amtune/amtune.template", zBinUnxDir + "/" + "amtune"}, {"../../../template/windows/bin/amtune/amtune.bat.template", zBinWinDir + "/" + "amtune.bat"}, {"../../../template/unix/bin/amtune/amtune-env.properties.template", zBinUnxDir + "/" + "amtune-env.properties"}, {"../../../template/windows/bin/amtune/amtune-env.properties.template", zBinWinDir + "/" + "amtune-env.properties"}, {"../../../template/unix/bin/amtune/amtune-samplepasswordfile.template", zBinUnxDir + "/" + "amtune-samplepasswordfile"}, {"../../../template/windows/bin/amtune/amtune-samplepasswordfile.template", zBinWinDir + "/" + "amtune-samplepasswordfile"}};
            for (int i = 0; i < filesToCopy.length; ++i) {
                File source = new File(filesToCopy[i][0]);
                File dest = new File(filesToCopy[i][1]);
                if (source.exists()) {
                    AMTuneUtil.CopyFile(source, dest);
                    continue;
                }
                pLogger.log(Level.INFO, "createRemoteDSTuningZipFile", "File " + source + " not found.");
            }
            File localeFiles = new File(curDir + "../../../resources");
            File[] lFiles = localeFiles.listFiles(new AMTuneFileFilter("amtune"));
            for (int i = 0; i < lFiles.length; ++i) {
                String fileName = lFiles[i].getName();
                AMTuneUtil.CopyFile(lFiles[i], new File(zLocaleDir + "/" + fileName));
            }
            AMTuneUtil.updateDSParamsInEnvFile(configInfo, zBinWinDir + "/" + "amtune-env.properties");
            AMTuneUtil.updateDSParamsInEnvFile(configInfo, zBinUnxDir + "/" + "amtune-env.properties");
            String zipPath = AMTuneUtil.createZipFile(baseDir, "amtune");
            mWriter.writeLocaleMsg("pt-ds-tar-file-location");
            mWriter.writeln(" " + zipPath);
            mWriter.writelnLocaleMsg("pt-ds-steps");
            mWriter.writelnLocaleMsg("pt-ds-copy-tar-file");
            mWriter.writelnLocaleMsg("pt-ds-untar-file");
            mWriter.writelnLocaleMsg("pt-ds-set-values");
            mWriter.writelnLocaleMsg("pt-ds-set-env-values");
            mWriter.writelnLocaleMsg("pt-ds-execute-review-mode");
            mWriter.writelnLocaleMsg("pt-ds-review");
            mWriter.writelnLocaleMsg("pt-ds-change-mode");
            mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "createRemoteDSTuningZipFile", "Error creating amtune.zip file." + ex.getMessage());
        }
        finally {
            AMTuneUtil.deleteDirectory(baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDSParamsInEnvFile(AMTuneConfigInfo configInfo, String fileName) {
        FileHandler fh = null;
        try {
            fh = new FileHandler(fileName);
            String propName = "DS_HOST=";
            int reqIdx = fh.getLineNum(propName);
            String reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.getDSConfigInfo().getDsHost());
            fh.replaceLine(reqIdx, reqLine);
            propName = "DS_PORT=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.getDSConfigInfo().getDsPort());
            fh.replaceLine(reqIdx, reqLine);
            propName = "ROOT_SUFFIX=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.getDSConfigInfo().getRootSuffix());
            fh.replaceLine(reqIdx, reqLine);
            propName = "DS_VERSION=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.getDSConfigInfo().getDsVersion());
            fh.replaceLine(reqIdx, reqLine);
            propName = "DIRMGR_BIND_DN=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.getDSConfigInfo().getDirMgrUid());
            fh.replaceLine(reqIdx, reqLine);
            propName = "DS_TOOLS_DIR=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            String toolsBinDir = configInfo.getDSConfigInfo().getDSToolsBinDir();
            if (toolsBinDir != null && toolsBinDir.trim().length() > 0) {
                reqLine = reqLine.replace(propName, propName + toolsBinDir);
                fh.replaceLine(reqIdx, reqLine);
            }
            propName = "DS_INSTANCE_DIR=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            String instDir = configInfo.getDSConfigInfo().getDsInstanceDir();
            if (instDir != null && instDir.trim().length() > 0) {
                reqLine = reqLine.replace(propName, propName + instDir);
                fh.replaceLine(reqIdx, reqLine);
            }
            propName = "AMTUNE_MODE=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + "REVIEW");
            fh.replaceLine(reqIdx, reqLine);
            propName = "AMTUNE_TUNE_DS=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + configInfo.isTuneDS());
            fh.replaceLine(reqIdx, reqLine);
            propName = "AMTUNE_TUNE_OS=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + "false");
            fh.replaceLine(reqIdx, reqLine);
            propName = "AMTUNE_TUNE_WEB_CONTAINER=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + "false");
            fh.replaceLine(reqIdx, reqLine);
            propName = "AMTUNE_TUNE_OPENSSO=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + "false");
            fh.replaceLine(reqIdx, reqLine);
            propName = "AMTUNE_LOG_LEVEL=";
            reqIdx = fh.getLineNum(propName);
            reqLine = fh.getLine(reqIdx);
            reqLine = reqLine.replace(propName, propName + "FILE");
            fh.replaceLine(reqIdx, reqLine);
        }
        catch (Exception ex) {
            pLogger.log(Level.WARNING, "replaceDSParamsInEnvFile", "Error replacing DS params: " + ex.getMessage());
        }
        finally {
            if (fh != null) {
                try {
                    fh.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void changeFilePerm(String fileName, String perm) {
        if (!AMTuneUtil.isWindows()) {
            StringBuffer rBuff = new StringBuffer();
            int n = AMTuneUtil.executeCommand("chmod " + perm + " " + fileName, rBuff);
        }
    }

    public static void validatePwdFilePermissions(String fileName) throws AMTuneException {
        if (System.getProperty("path.separator").equals(":")) {
            String permission;
            int idx;
            StringBuffer lsCmd = new StringBuffer("/bin/ls");
            lsCmd.append(" -l ");
            lsCmd.append(fileName);
            StringBuffer rBuf = new StringBuffer();
            AMTuneUtil.executeCommand(lsCmd.toString(), rBuf);
            String s = rBuf.toString();
            if (s != null && (idx = s.indexOf(" ")) != -1 && !(permission = s.substring(0, idx)).equals("-r--------")) {
                String msg = AMTuneUtil.getResourceBundle().getString("pt-error-password-file-not-readonly");
                Object[] param = new Object[]{fileName};
                throw new AMTuneException(MessageFormat.format(msg, param));
            }
        }
    }

    public static ResourceBundle getResourceBundle() throws AMTuneException {
        try {
            if (rb == null) {
                rb = ResourceBundle.getBundle("amtune");
            }
        }
        catch (MissingResourceException me) {
            throw new AMTuneException("Couldn't find resource file: amtune");
        }
        return rb;
    }

    public static void writePasswordToFile(String password, String passFilePath) throws IOException {
        pLogger.log(Level.FINE, "writePasswordToFile", "Creating password file.");
        File passFile = new File(passFilePath);
        BufferedWriter pOut = new BufferedWriter(new FileWriter(passFile));
        pOut.write(password);
        pOut.flush();
        pOut.close();
        AMTuneUtil.changeFilePerm(passFilePath, "400");
    }

    public static void deleteFile(String filePath) {
        File f = new File(filePath);
        if (f.isFile()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommand(String cmd, String password, String passFilePath, StringBuffer resultBuffer) throws AMTuneException {
        int extVal = -1;
        try {
            AMTuneUtil.writePasswordToFile(password, passFilePath);
            extVal = AMTuneUtil.executeCommand(cmd, resultBuffer);
        }
        catch (IOException ioe) {
            pLogger.log(Level.SEVERE, "executeScriptCmd", "Error creating password file " + ioe.getMessage());
        }
        finally {
            AMTuneUtil.deleteFile(passFilePath);
        }
        return extVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeScriptCmd(String cmd, String password, String passFilePath, StringBuffer resultBuffer) throws AMTuneException {
        int extVal = -1;
        try {
            AMTuneUtil.writePasswordToFile(password, passFilePath);
            extVal = AMTuneUtil.executeScriptCmd(cmd, resultBuffer);
        }
        catch (IOException ioe) {
            pLogger.log(Level.SEVERE, "executeScriptCmd", "Error writing password to file " + ioe.getMessage());
        }
        finally {
            AMTuneUtil.deleteFile(passFilePath);
        }
        return extVal;
    }

    static {
        utilInit = true;
        isNiagara_I = false;
        isNiagara_II = false;
        isNiagara_II_Plus = false;
        rb = null;
        pLogger = AMTuneLogger.getLoggerInst();
    }
}

