/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DeleteMetaData
extends AuthenticatedCommand {
    static final String ARGUMENT_REALM = "realm";
    private boolean extendedOnly;
    private String realm = "/";
    private String entityID;
    private SAML2MetaManager metaManager;

    public void handleRequest(RequestContext rc) throws CLIException {
        block5: {
            super.handleRequest(rc);
            this.ldapLogin();
            this.superAdminUserValidation();
            this.extendedOnly = this.isOptionSet("extendedonly");
            this.realm = this.getStringOptionValue(ARGUMENT_REALM);
            this.entityID = this.getStringOptionValue("entityid");
            String spec = FederationManager.getIDFFSubCommandSpecification(rc);
            String[] params = new String[]{this.realm, this.entityID, spec};
            this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_ENTITY", params);
            try {
                if (spec.equals("saml2")) {
                    this.handleSAML2Request(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_ENTITY", params);
                    break block5;
                }
                if (spec.equals("idff")) {
                    this.handleIDFFRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_ENTITY", params);
                    break block5;
                }
                if (spec.equals("wsfed")) {
                    this.handleWSFedRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_ENTITY", params);
                    break block5;
                }
                throw new CLIException(this.getResourceString("unsupported-specification"), 127);
            }
            catch (CLIException e) {
                String[] args = new String[]{this.realm, this.entityID, spec, e.getMessage()};
                this.writeLog(1, Level.INFO, "FAILED_DELETE_ENTITY", args);
                throw e;
            }
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        try {
            this.metaManager = new SAML2MetaManager();
            if (this.metaManager.getEntityDescriptor(this.realm, this.entityID) == null) {
                Object[] param = new Object[]{this.entityID};
                throw new CLIException(MessageFormat.format(this.getResourceString("delete-entity-entity-not-exist"), param), 127);
            }
            if (this.extendedOnly) {
                this.metaManager.deleteEntityConfig(this.realm, this.entityID);
                Object[] objs = new Object[]{this.entityID};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-config-deleted"), objs));
            } else {
                this.metaManager.deleteEntityDescriptor(this.realm, this.entityID);
                Object[] objs = new Object[]{this.entityID};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-descriptor-deleted"), objs));
            }
        }
        catch (SAML2MetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            if (metaManager.getEntityDescriptor(this.realm, this.entityID) == null) {
                Object[] param = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("delete-entity-entity-not-exist"), param), 127);
            }
            if (this.extendedOnly) {
                metaManager.deleteEntityConfig(this.realm, this.entityID);
                Object[] objs = new Object[]{this.entityID, this.realm};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-config-deleted"), objs));
            } else {
                metaManager.deleteEntityDescriptor(this.realm, this.entityID);
                Object[] objs = new Object[]{this.entityID, this.realm};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-descriptor-deleted"), objs));
            }
        }
        catch (IDFFMetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        try {
            if (WSFederationMetaManager.getEntityDescriptor((String)this.realm, (String)this.entityID) == null) {
                Object[] param = new Object[]{this.entityID};
                throw new CLIException(MessageFormat.format(this.getResourceString("delete-entity-entity-not-exist"), param), 127);
            }
            if (this.extendedOnly) {
                WSFederationMetaManager.deleteEntityConfig((String)this.realm, (String)this.entityID);
                Object[] objs = new Object[]{this.entityID};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-config-deleted"), objs));
            } else {
                WSFederationMetaManager.deleteFederation((String)this.realm, (String)this.entityID);
                Object[] objs = new Object[]{this.entityID};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-entity-descriptor-deleted"), objs));
            }
        }
        catch (WSFederationMetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

