/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHelperMethodCreator {
    private String scmdName;
    private String description;
    private String methodName;
    private List<String> formalParameters = new ArrayList<String>();
    private Map<String, String> nameToDescription = new HashMap<String, String>();
    private Map<String, String> nameToShortName = new HashMap<String, String>();
    private Set<String> textAreaUI = new HashSet<String>();
    private Set<String> checkboxUI = new HashSet<String>();
    private Set<String> unaryOptionNames = new HashSet<String>();
    private Set<String> singleOptionNames = new HashSet<String>();
    private Set<String> aliases = new HashSet<String>();
    private static final String TEXTAREA_TEMPLATE = "        if (@opt@ != null) {\n            HtmlTextArea ta@opt@ = (HtmlTextArea)form.getTextAreasByName(\"@opt@\").get(0);\n            ta@opt@.setText(@opt@);\n        }\n";
    private static final String STRING_TEMPLATE = "        if (@opt@ != null) {\n            HtmlTextInput txt@opt@ = (HtmlTextInput)form.getInputByName(\"@opt@\");\n            txt@opt@.setValueAttribute(@opt@);\n        }\n";
    private static final String BOOLEAN_TEMPLATE = "        HtmlCheckBoxInput cb@opt@ = (HtmlCheckBoxInput)form.getInputByName(\"@opt@\");\n        cb@opt@.setChecked(@opt@);\n";
    private static final String LIST_TEMPLATE = "        if (@opt@ != null) {\n            HtmlSelect sl@opt@= (HtmlSelect)form.getSelectByName(\"@opt@\");\n            String[] fakeOptions = new String[@opt@.size()];\n            int cnt = 0;\n            for (Iterator i = @opt@.iterator(); i.hasNext(); ) {\n                fakeOptions[cnt++] = (String)i.next();\n            }\n            sl@opt@.fakeSelectedAttribute(fakeOptions);\n        }\n";

    WebHelperMethodCreator(String cmdName, String description, List<String> mandatory, List<String> optional, List<String> aliases) {
        this.scmdName = cmdName.replaceAll("_", "-");
        this.methodName = WebHelperMethodCreator.getMethodName(cmdName);
        this.description = description;
        this.validateOptions(mandatory);
        this.validateOptions(optional);
        this.registerAliases(aliases);
    }

    private static String getMethodName(String name) {
        int idx = name.indexOf(95);
        while (idx != -1) {
            name = name.substring(0, idx) + name.substring(idx + 1, idx + 2).toUpperCase() + name.substring(idx + 2);
            idx = name.indexOf(95);
        }
        return name;
    }

    private void validateOptions(List<String> options) {
        for (String token : options) {
            String description;
            int idxWeb;
            StringTokenizer t = new StringTokenizer(token, "|");
            String name = t.nextToken();
            String shortName = t.nextToken();
            String type = t.nextToken();
            boolean unary = type.equals("u");
            boolean single = type.equals("s");
            if (t.countTokens() == 2) {
                String webUI = t.nextToken();
                if (webUI.equals("t")) {
                    this.textAreaUI.add(name);
                } else if (webUI.equals("c")) {
                    this.checkboxUI.add(name);
                }
            }
            if ((idxWeb = (description = t.nextToken()).indexOf("<web>")) != -1) {
                this.nameToDescription.put(name, description.substring(idxWeb + 5));
            } else {
                this.nameToDescription.put(name, description);
            }
            this.nameToShortName.put(name, shortName);
            if (unary) {
                this.unaryOptionNames.add(name);
            } else if (single) {
                this.singleOptionNames.add(name);
            }
            this.formalParameters.add(name);
        }
    }

    private void registerAliases(List<String> list) {
        for (String opt : list) {
            StringTokenizer st = new StringTokenizer(opt, "|");
            st.nextToken();
            this.aliases.add(st.nextToken());
        }
    }

    public void genMethod(StringBuffer buff) {
        this.createJavaDoc(buff);
        buff.append("    public HtmlPage ").append(this.methodName).append("(\n");
        this.createFormalParameters(buff);
        buff.append("    ) throws Exception {\n");
        this.createImplementations(buff);
        buff.append("    }\n");
    }

    private void createJavaDoc(StringBuffer buff) {
        buff.append("\n    /**\n");
        buff.append("     * ").append(this.description).append("\n     *\n");
        buff.append("     * @param webClient HTML Unit Web Client object.\n");
        for (String opt : this.formalParameters) {
            if (this.aliases.contains(opt) || this.isAuthField(opt) || this.isIgnored(opt)) continue;
            buff.append("     * @param ").append(opt).append(" ").append(this.nameToDescription.get(opt)).append("\n");
        }
        buff.append("     */\n");
    }

    private void createFormalParameters(StringBuffer buff) {
        buff.append("        WebClient webClient");
        for (String opt : this.formalParameters) {
            if (this.aliases.contains(opt) || this.isAuthField(opt) || this.isIgnored(opt)) continue;
            if (this.isTextareaUI(opt)) {
                buff.append(",\n        String ").append(opt);
                continue;
            }
            if (this.isCheckboxUI(opt)) {
                buff.append(",\n        boolean ").append(opt);
                continue;
            }
            if (this.singleOptionNames.contains(opt)) {
                buff.append(",\n        String ").append(opt);
                continue;
            }
            buff.append(",\n        List ").append(opt);
        }
        buff.append("\n");
    }

    private void createImplementations(StringBuffer buff) {
        buff.append("        URL cmdUrl = new URL(amadmUrl + \"" + this.scmdName + "\");\n");
        buff.append("        HtmlPage page = (HtmlPage)webClient.getPage(cmdUrl);\n");
        buff.append("        HtmlForm form = (HtmlForm)page.getForms().get(0);\n\n");
        for (String opt : this.formalParameters) {
            if (this.aliases.contains(opt) || this.isAuthField(opt) || this.isIgnored(opt)) continue;
            if (this.isTextareaUI(opt)) {
                buff.append(TEXTAREA_TEMPLATE.replaceAll("@opt@", opt)).append("\n");
                continue;
            }
            if (this.isCheckboxUI(opt)) {
                buff.append(BOOLEAN_TEMPLATE.replaceAll("@opt@", opt)).append("\n");
                continue;
            }
            if (this.singleOptionNames.contains(opt)) {
                buff.append(STRING_TEMPLATE.replaceAll("@opt@", opt)).append("\n");
                continue;
            }
            buff.append(LIST_TEMPLATE.replaceAll("@opt@", opt)).append("\n");
        }
        buff.append("        return (HtmlPage)form.submit();\n");
    }

    private boolean isAuthField(String opt) {
        return opt.equals("adminid") || opt.equals("password");
    }

    private boolean isIgnored(String opt) {
        return opt.equals("continue") || opt.equals("outfile") || opt.equals("password-file") || opt.equals("datafile") && this.formalParameters.contains("attributevalues") || opt.equals("datafile") && this.formalParameters.contains("choicevalues");
    }

    private boolean isTextareaUI(String opt) {
        String shortName = this.nameToShortName.get(opt);
        return !shortName.equals(shortName.toLowerCase()) || this.textAreaUI.contains(opt);
    }

    private boolean isCheckboxUI(String opt) {
        return this.unaryOptionNames.contains(opt) || this.checkboxUI.contains(opt);
    }
}

