/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KeyIdentifier {
    private String valueType = null;
    private String encodingType = null;
    private String value = null;
    private String id = null;
    private X509Certificate cert = null;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static Debug debug = WSSUtils.debug;

    public KeyIdentifier(String valueType, String encodingType, String value) {
        this.valueType = valueType;
        this.encodingType = encodingType;
        this.value = value;
        this.id = SAMLUtils.generateID();
    }

    public KeyIdentifier(Element element) throws SecurityException {
        if (element == null) {
            throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
        }
        if (!"KeyIdentifier".equals(element.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(element.getNamespaceURI())) {
            debug.error("KeyIdentifier.Constructor:: Invalid key identifier");
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        this.valueType = element.getAttribute("ValueType");
        this.encodingType = element.getAttribute("EncodingType");
        if (this.valueType == null || this.encodingType == null) {
            debug.error("KeyIdentifier.constructor:: Key Identifier does not have ValueType or EncodingType");
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        this.value = element.getFirstChild().getNodeValue().trim();
    }

    public X509Certificate getX509Certificate() throws SecurityException {
        if (this.cert != null) {
            return this.cert;
        }
        this.cert = AMTokenProvider.getX509CertForKeyIdentifier(this.value);
        return this.cert;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getReferenceValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public Element getTokenElement(Document doc) throws SecurityException {
        Element tokenElement = null;
        try {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.valueType)) {
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@AssertionID=\"" + this.value + "\"]");
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.valueType)) {
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@ID=\"" + this.value + "\"]");
            } else {
                Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@wsu:Id=\"" + this.value + "\"]");
            }
            return tokenElement;
        }
        catch (TransformerException te) {
            debug.error("SecurityTokenReference.getTokenElement: XPath exception.", (Throwable)te);
            throw new SecurityException(te.getMessage());
        }
    }

    public void addToParent(Element parent) throws SecurityException {
        try {
            if (parent == null) {
                throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
            }
            Document doc = parent.getOwnerDocument();
            Element keyIdentifier = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
            keyIdentifier.setPrefix("wsse");
            keyIdentifier.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.id);
            if (this.valueType != null) {
                keyIdentifier.setAttributeNS(null, "ValueType", this.valueType);
            }
            if (this.value == null) {
                throw new SecurityException(bundle.getString("invalidKeyIdentifier"));
            }
            Text text = doc.createTextNode(this.value);
            keyIdentifier.appendChild(text);
            parent.appendChild(keyIdentifier);
        }
        catch (Exception ex) {
            debug.error("KeyIdentifier.addToParent::can not add to parent", (Throwable)ex);
            throw new SecurityException(bundle.getString("cannotAddElement"));
        }
    }
}

