/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.trust.wst13;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.trust.RequestSecurityToken;
import com.sun.identity.wss.trust.WSTException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestSecurityToken_Impl
extends RequestSecurityToken {
    private Element rstE = null;

    public RequestSecurityToken_Impl() {
    }

    public RequestSecurityToken_Impl(Element element) throws WSTException {
        if (element == null) {
            throw new WSTException("NullElement");
        }
        if (!"RequestSecurityToken".equals(element.getLocalName())) {
            throw new WSTException("InvalidElement");
        }
        if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(element.getNamespaceURI())) {
            throw new WSTException("InvalidNameSpace");
        }
        this.rstE = element;
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String localName = child.getLocalName();
            if ("TokenType".equals(localName)) {
                this.tokenType = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if ("RequestType".equals(localName)) {
                this.requestType = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if ("AppliesTo".equals(localName)) {
                this.appliesTo = STSUtils.getAppliesTo(child);
                continue;
            }
            if ("OnBehalfOf".equals(localName)) {
                this.oboToken = (Element)child.getFirstChild();
                continue;
            }
            if (!"KeyType".equals(localName)) continue;
            this.keyType = XMLUtils.getElementValue((Element)child);
        }
    }

    public Element toDOMElement() throws WSTException {
        if (this.rstE != null) {
            return this.rstE;
        }
        return XMLUtils.toDOMDocument((String)this.toXMLString(), (Debug)STSUtils.debug).getDocumentElement();
    }

    public String toXMLString() throws WSTException {
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append("wst:").append("RequestSecurityToken").append(" ").append("xmlns:wst").append("=\"").append("http://docs.oasis-open.org/ws-sx/ws-trust/200512").append("\"").append(" ").append("xmlns:wsp").append("=").append("\"").append("http://schemas.xmlsoap.org/ws/2004/09/policy").append("\"").append(" ").append("xmlns:wsa").append("=").append("\"").append("http://www.w3.org/2005/08/addressing").append("\"").append(">");
        if (this.tokenType != null) {
            sb.append("<").append("wst:").append("TokenType").append(">").append(this.tokenType).append("</").append("wst:").append("TokenType").append(">");
        }
        if (this.requestType == null || this.requestType.length() == 0) {
            throw new WSTException("RequestType is null");
        }
        sb.append("<").append("wst:").append("RequestType").append(">").append(this.requestType).append("</").append("wst:").append("RequestType").append(">");
        if (this.appliesTo != null) {
            sb.append("<").append("wsp:").append("AppliesTo").append(">").append("<").append("wsa:").append("EndpointReference").append(">").append("<").append("wsa:").append("Address").append(">").append(this.appliesTo).append("</").append("wsa:").append("Address").append(">").append("</").append("wsa:").append("EndpointReference").append(">").append("</").append("wsp:").append("AppliesTo").append(">");
        }
        if (this.oboToken != null) {
            sb.append("<").append("wst:").append("OnBehalfOf").append(">").append(XMLUtils.print((Node)this.oboToken)).append("</").append("wst:").append("OnBehalfOf").append(">");
        }
        if (this.keyType != null) {
            sb.append("<").append("wst:").append("KeyType").append(">").append(this.keyType).append("</").append("wst:").append("KeyType").append(">");
        }
        sb.append("</").append("wst:").append("RequestSecurityToken").append(">");
        return sb.toString();
    }
}

