/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class SessionEncodeURL {
    public static Debug debug;
    public final String delimiter = "_";
    public static Hashtable sidHash;
    public static final String SESS_DELIMITER = ";";
    public static final String SLASH_SESS_DELIMITER = "/";
    public static final String QUERY = "?";
    public static final String AMPERSAND = "&";
    public static final String AMPERSAND_ESC = "&amp;";
    public static final String EQUAL = "=";
    private static SessionEncodeURL se;
    static boolean cookieEncoding;

    public static String encodeURL(String sidString, String url, short encodingScheme, boolean escape) {
        String encodedURL = se.encodeSidURL(url, sidString, encodingScheme, escape);
        if (debug.messageEnabled()) {
            debug.message("URL recd.. " + url);
            debug.message("encodeURL .. " + encodedURL);
            debug.message("encodingScheme is.. " + encodingScheme);
            debug.message("escape is.. " + escape);
        }
        return encodedURL;
    }

    private static String getCookieName() {
        String name = System.getProperty("com.iplanet.am.cookie.name");
        if (name == null) {
            name = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        return name;
    }

    public static String getSidFromURL(HttpServletRequest request) {
        return SessionEncodeURL.getSidFromURL(request, SessionEncodeURL.getCookieName());
    }

    public static String getSidFromURL(HttpServletRequest request, String cookieName) {
        String url;
        String sidString = "";
        if (request != null && (url = request.getRequestURI()) != null) {
            sidString = url.indexOf(SLASH_SESS_DELIMITER + cookieName) != -1 || url.indexOf(SESS_DELIMITER + cookieName) != -1 ? SessionEncodeURL.getSidFromURI(url, cookieName) : SessionEncodeURL.getSidFromQuery(request, cookieName);
        }
        if (debug.messageEnabled()) {
            debug.message("before decoding getSidFromURL:sidString=" + sidString);
        }
        if (cookieEncoding && sidString != null) {
            sidString = URLEncDec.decode((String)sidString);
        }
        if (debug.messageEnabled()) {
            debug.message("after decoding: getSidFromURL:sidString=" + sidString);
        }
        return sidString;
    }

    private static String getSidFromURI(String url, String cookieName) {
        String sid = "";
        if (url != null) {
            int start;
            if (debug.messageEnabled()) {
                debug.message("getSidFromURI: url=" + url);
            }
            if (url != null && url.length() > 0 && (start = url.indexOf(cookieName)) != -1) {
                int end = url.indexOf(QUERY, start = start + cookieName.length() + 1);
                sid = end != -1 ? url.substring(start, end - 1) : url.substring(start);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("getSidFromURL: sid =" + sid);
        }
        return sid;
    }

    private static String getSidFromQuery(HttpServletRequest request, String cookieName) {
        String sid = "";
        if (request != null) {
            sid = request.getParameter(cookieName);
        }
        if (debug.messageEnabled()) {
            debug.message("getSidFromQuery: request =" + request);
            debug.message("getSidFromQuery: sid =" + sid);
        }
        return sid;
    }

    private String encodeSidURL(String url, String cookieStr, short encodingScheme, boolean escape) {
        String uri = url;
        String qString = null;
        int index = url.indexOf(QUERY);
        if (index != -1) {
            uri = url.substring(0, index);
            qString = url.substring(index + 1);
        }
        String encodedURL = url;
        encodedURL = encodingScheme == 0 ? SessionEncodeURL.encodeSidInQueryString(uri, qString, cookieStr, escape) : SessionEncodeURL.encodeSidInURLPath(uri, qString, cookieStr, encodingScheme);
        if (debug.messageEnabled()) {
            debug.message("encodeSidURL :: URI  :" + uri);
            debug.message("encodeSidURL :: qString :" + qString);
            debug.message("encodeSidURL :: cookieStr:" + cookieStr);
            debug.message("encodeSidURL :: URL  :" + encodedURL);
        }
        return encodedURL;
    }

    public static String buildCookieString(String url, String cookieStr, short encodingScheme, boolean escape) {
        return encodingScheme == 0 ? SessionEncodeURL.writeUrlInQuery(url, cookieStr, escape) : SessionEncodeURL.writeUrlInPath(url, cookieStr, encodingScheme);
    }

    private static String writeUrlInPath(String url, String cookieStr, short encodingScheme) {
        String sessionDelimiter = SLASH_SESS_DELIMITER;
        if (encodingScheme == 2) {
            sessionDelimiter = SESS_DELIMITER;
        }
        StringBuffer encodedURLBuf = new StringBuffer();
        if (url.indexOf(cookieStr) == -1) {
            int i = url.indexOf(QUERY);
            if (i != -1) {
                String uri = url.substring(0, i);
                String query = url.substring(i, url.length());
                encodedURLBuf.append(uri).append(sessionDelimiter).append(cookieStr).append(query);
            } else {
                encodedURLBuf.append(url).append(sessionDelimiter).append(cookieStr);
            }
        } else {
            encodedURLBuf.append(url);
        }
        String encodedURL = encodedURLBuf.toString();
        if (debug.messageEnabled()) {
            debug.message("writeUrlInPath : encoded URL : " + encodedURL);
        }
        return encodedURL;
    }

    private static String writeUrlInQuery(String url, String cookieStr, boolean escape) {
        StringBuffer encodedURLBuf = new StringBuffer().append(url);
        if (cookieStr != null && url.indexOf(cookieStr) == -1) {
            int i = url.indexOf(QUERY);
            if (i != -1) {
                if (escape) {
                    encodedURLBuf.append(AMPERSAND_ESC).append(cookieStr);
                } else {
                    encodedURLBuf.append(AMPERSAND).append(cookieStr);
                }
            } else {
                encodedURLBuf.append(QUERY).append(cookieStr);
            }
        }
        String encodedURL = encodedURLBuf.toString();
        if (debug.messageEnabled()) {
            debug.message("writeUrlInQuery : encoded URL : " + encodedURL);
        }
        return encodedURL;
    }

    public static String createCookieString(String cookieName, String sessionID) {
        StringBuffer cookieStrBuf = new StringBuffer();
        cookieStrBuf.append(URLEncDec.encode((String)cookieName)).append(EQUAL);
        if (sessionID != null) {
            cookieStrBuf.append(URLEncDec.encode((String)sessionID));
        }
        return cookieStrBuf.toString();
    }

    private static String encodeSidInURLPath(String uri, String qString, String cookieStr, short encodingScheme) {
        int index;
        String sessionDelimiter = SLASH_SESS_DELIMITER;
        if (encodingScheme == 2) {
            sessionDelimiter = SESS_DELIMITER;
        }
        if ((index = uri.indexOf(sessionDelimiter + SessionEncodeURL.getCookieName())) != -1) {
            uri = uri.substring(0, index);
        }
        StringBuffer urlBuf = new StringBuffer();
        if (cookieStr != null) {
            urlBuf = urlBuf.append(sessionDelimiter).append(cookieStr);
        }
        if (qString != null && qString.length() > 0) {
            urlBuf.append(QUERY).append(qString);
        }
        if (uri != null) {
            urlBuf.insert(0, uri);
        }
        return urlBuf.toString();
    }

    private static String encodeSidInQueryString(String uri, String qString, String cookieStr, boolean escape) {
        String escapeChar = AMPERSAND_ESC;
        if (!escape) {
            escapeChar = AMPERSAND;
        }
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(QUERY);
        if (qString != null) {
            int index = qString.indexOf(SessionEncodeURL.getCookieName());
            String remQueryString = null;
            if (index != -1) {
                int ampIndex;
                if (index > 0) {
                    remQueryString = qString.substring(0, index - 1);
                }
                if ((ampIndex = qString.indexOf(AMPERSAND, index)) != -1) {
                    String remString = qString.substring(ampIndex + 1, qString.length());
                    remQueryString = remQueryString != null && remQueryString.length() > 0 ? remQueryString + escapeChar + remString : remString;
                }
            } else {
                remQueryString = qString;
            }
            if (debug.messageEnabled()) {
                debug.message("After extracting cookie from query: " + remQueryString);
            }
            if (remQueryString != null) {
                urlBuf.append(remQueryString).append(escapeChar);
            }
        }
        if (cookieStr != null && cookieStr.length() > 0) {
            urlBuf.append(cookieStr);
        }
        if (uri != null) {
            urlBuf.insert(0, uri);
        }
        return urlBuf.toString();
    }

    static {
        sidHash = new Hashtable();
        se = new SessionEncodeURL();
        cookieEncoding = SystemProperties.get("com.iplanet.am.cookie.encode") != null && SystemProperties.get("com.iplanet.am.cookie.encode").equalsIgnoreCase("true");
        debug = Debug.getInstance((String)"amSessionEncodeURL");
    }
}

