/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.logging.Level;

public class RemoveAttributeDefaults
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        HashSet attributeNames = new HashSet();
        attributeNames.addAll(rc.getOption("attributenames"));
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, schemaType, subSchemaName, ((Object)attributeNames).toString()};
            this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_SCHEMA_ATTR_DEFAULTS", params);
            ss.removeAttributeDefaults(attributeNames);
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_SCHEMA_ATTR_DEFAULTS", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("schema-remove-attribute-defaults-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, ((Object)attributeNames).toString(), e.getMessage()};
            this.debugError("RemoveAttributeDefaults.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SCHEMA_ATTR_DEFAULTS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, ((Object)attributeNames).toString(), e.getMessage()};
            this.debugError("RemoveAttributeDefaults.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SCHEMA_ATTR_DEFAULTS", args);
            throw new CLIException(e, 127);
        }
    }
}

