/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ConfigurationBase {
    protected static final String OLD_ATTR_SITE_LIST = "iplanet-am-platform-site-list";
    protected static final String OLD_ATTR_SERVER_LIST = "iplanet-am-platform-server-list";
    static final String CONFIG_SERVERS = "com-sun-identity-servers";
    protected static final String SUBSCHEMA_SERVER = "server";
    protected static final String ATTR_SERVER_ID = "serverid";
    protected static final String SUBSCHEMA_SITE = "site";
    protected static final String CONFIG_SITES = "com-sun-identity-sites";
    protected static final String SUBCONFIG_ACCESS_URL = "accesspoint";
    protected static final String ATTR_PRIMARY_SITE_ID = "primary-siteid";
    protected static final String ATTR_PRIMARY_SITE_URL = "primary-url";
    protected static final String SUBCONFIG_SEC_URLS = "secondary-urls";
    protected static final String ATTR_SEC_ID = "secondary-siteid";

    protected static String getNextId(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet currentIds = new HashSet();
        if (ConfigurationBase.isLegacy(ssoToken)) {
            currentIds.addAll(ConfigurationBase.legacyGetServerIds(ssoToken));
            currentIds.addAll(ConfigurationBase.legacyGetSiteIds(ssoToken));
        } else {
            currentIds.addAll(ConfigurationBase.getServerConfigurationId(ConfigurationBase.getRootServerConfig(ssoToken)));
            currentIds.addAll(ConfigurationBase.getSiteConfigurationId(ConfigurationBase.getRootSiteConfig(ssoToken)));
        }
        return ConfigurationBase.getNextId(currentIds);
    }

    protected static Set getServerConfigurationId(ServiceConfig svc) throws SMSException, SSOException {
        HashSet currentIds = new HashSet();
        Set names = svc.getSubConfigNames("*");
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                ServiceConfig sc = svc.getSubConfig(name);
                Map map = sc.getAttributes();
                Set set = (Set)map.get(ATTR_SERVER_ID);
                if (set == null || set.isEmpty()) continue;
                currentIds.add(set.iterator().next());
            }
        }
        return currentIds;
    }

    protected static Set getSiteConfigurationId(ServiceConfig svc) throws SMSException, SSOException {
        HashSet currentIds = new HashSet();
        Set names = svc.getSubConfigNames("*");
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                currentIds.addAll(ConfigurationBase.getSiteConfigurationIds(null, svc, name, false));
            }
        }
        return currentIds;
    }

    protected static Set getSiteConfigurationIds(SSOToken ssoToken, ServiceConfig rootNode, String name, boolean bPrimaryOnly) throws SMSException, SSOException {
        Set failovers;
        ServiceConfig sc;
        if (rootNode == null) {
            rootNode = ConfigurationBase.getRootSiteConfig(ssoToken);
        }
        if ((sc = rootNode.getSubConfig(name)) == null) {
            return Collections.EMPTY_SET;
        }
        HashSet currentIds = new HashSet();
        ServiceConfig accessPoint = sc.getSubConfig(SUBCONFIG_ACCESS_URL);
        Map map = accessPoint.getAttributes();
        Set set = (Set)map.get(ATTR_PRIMARY_SITE_ID);
        currentIds.add(set.iterator().next());
        if (!bPrimaryOnly && (failovers = accessPoint.getSubConfigNames("*")) != null && !failovers.isEmpty()) {
            for (String foName : failovers) {
                ServiceConfig s = accessPoint.getSubConfig(foName);
                Map mapValues = s.getAttributes();
                set = (Set)mapValues.get(ATTR_SEC_ID);
                if (set == null || set.isEmpty()) continue;
                currentIds.add(set.iterator().next());
            }
        }
        return currentIds;
    }

    protected static String getNextId(Set currentIds) {
        String id = null;
        if (!currentIds.isEmpty()) {
            int i = 1;
            while (id == null) {
                String test;
                String string = test = i < 10 ? "0" + Integer.toString(i) : Integer.toString(i);
                if (!currentIds.contains(test)) {
                    id = test;
                }
                ++i;
            }
        }
        return id == null ? "01" : id;
    }

    public static boolean isLegacy() {
        try {
            return ConfigurationBase.isLegacy((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
        }
        catch (SSOException e) {
            return true;
        }
        catch (SMSException e) {
            return true;
        }
    }

    public static boolean isLegacy(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceSchemaManager sm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
        return sm.getRevisionNumber() < 30;
    }

    protected static void updateOrganizationAlias(SSOToken ssoToken, String instanceName, boolean bAdd) throws SMSException {
        String hostName = null;
        try {
            URL url = new URL(instanceName);
            hostName = url.getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
        OrganizationConfigManager ocm = new OrganizationConfigManager(ssoToken, "/");
        Map allAttrs = ocm.getAttributes("sunidentityrepositoryservice");
        Set values = (Set)allAttrs.get("sunOrganizationAliases");
        if (bAdd) {
            if (!values.contains(hostName)) {
                values.add(hostName);
                ocm.setAttributes("sunidentityrepositoryservice", allAttrs);
            }
        } else if (values.contains(hostName)) {
            values.remove(hostName);
            ocm.setAttributes("sunidentityrepositoryservice", allAttrs);
        }
    }

    protected static ServiceConfig getRootServerConfig(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMPlatformService", ssoToken);
        ServiceConfig globalSvcConfig = scm.getGlobalConfig(null);
        return globalSvcConfig != null ? globalSvcConfig.getSubConfig(CONFIG_SERVERS) : null;
    }

    protected static ServiceConfig getServerConfig(SSOToken ssoToken, String name) throws SMSException, SSOException {
        ServiceConfig sc = ConfigurationBase.getRootServerConfig(ssoToken);
        return sc != null ? sc.getSubConfig(name) : null;
    }

    protected static ServiceConfig getRootSiteConfig(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMPlatformService", ssoToken);
        ServiceConfig globalSvcConfig = scm.getGlobalConfig(null);
        return globalSvcConfig != null ? globalSvcConfig.getSubConfig(CONFIG_SITES) : null;
    }

    protected static ServiceConfig getSiteConfig(SSOToken ssoToken, String name) throws SMSException, SSOException {
        ServiceConfig sc = ConfigurationBase.getRootSiteConfig(ssoToken);
        return sc != null ? sc.getSubConfig(name) : null;
    }

    private static Set legacyGetSiteIds(SSOToken token) throws SMSException, SSOException {
        HashSet<String> currentIds = new HashSet<String>();
        Set sites = ConfigurationBase.legacyGetSiteInfo(token);
        if (sites != null && !sites.isEmpty()) {
            for (String site : sites) {
                int idx = site.indexOf(124);
                if (idx == -1) continue;
                if ((idx = (site = site.substring(idx + 1)).indexOf(124)) != -1) {
                    site = site.substring(0, idx);
                }
                currentIds.add(site);
            }
        }
        return currentIds;
    }

    protected static Set legacyGetSiteInfo(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
        ServiceSchema global = scm.getSchema(SchemaType.GLOBAL);
        AttributeSchema as = global.getAttributeSchema(OLD_ATTR_SITE_LIST);
        return as == null ? null : as.getDefaultValues();
    }

    private static Set legacyGetServerIds(SSOToken token) throws SMSException, SSOException {
        HashSet<String> currentIds = new HashSet<String>();
        Set servers = ConfigurationBase.legacyGetServerInfo(token);
        if (servers != null && !servers.isEmpty()) {
            for (String server : servers) {
                int idx = server.indexOf(124);
                if (idx == -1) continue;
                if ((idx = (server = server.substring(idx + 1)).indexOf(124)) != -1) {
                    server = server.substring(0, idx);
                }
                currentIds.add(server);
            }
        }
        return currentIds;
    }

    protected static Set legacyGetServerInfo(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
        ServiceSchema global = scm.getSchema(SchemaType.GLOBAL);
        AttributeSchema as = global.getAttributeSchema(OLD_ATTR_SERVER_LIST);
        return as == null ? null : as.getDefaultValues();
    }
}

