/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMServiceProfileViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.realm.ServicesCannotAssignServiceViewBean;
import com.sun.identity.console.realm.ServicesSelectViewBean;
import com.sun.identity.console.realm.ServicesViewBean;
import com.sun.identity.console.realm.model.ServicesProfileModel;
import com.sun.identity.console.realm.model.ServicesProfileModelImpl;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServicesAddViewBean
extends AMServiceProfileViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/ServicesAdd.jsp";

    public ServicesAddViewBean() {
        super("ServicesAdd", DEFAULT_DISPLAY_URL, null);
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        if (serviceName != null) {
            this.initialize(serviceName);
        }
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        ServicesProfileModel model = (ServicesProfileModel)this.getModel();
        if (model.hasOrganizationAttributes()) {
            this.initialize(serviceName);
            super.forwardTo(reqContext);
        } else {
            try {
                model.assignService(Collections.EMPTY_MAP);
                this.forwardToServicesViewBean();
            }
            catch (AMConsoleException e) {
                ServicesCannotAssignServiceViewBean vb = (ServicesCannotAssignServiceViewBean)this.getViewBean(ServicesCannotAssignServiceViewBean.class);
                this.passPgSessionMap((ViewBean)vb);
                vb.message = e.getMessage();
                vb.forwardTo(reqContext);
            }
        }
    }

    protected void createPageTitleModel() {
        super.createThreeButtonPageTitleModel();
        ServicesProfileModel model = (ServicesProfileModel)this.getModel();
        String[] arg = new String[]{model.getLocalizedServiceName(this.serviceName)};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString("page.title.services.add"), arg));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        String location = (String)this.getPageSessionAttribute("currentRealm");
        try {
            return new ServicesProfileModelImpl(req, serviceName, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            return null;
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.forwardToServicesViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        ServicesSelectViewBean vb = (ServicesSelectViewBean)this.getViewBean(ServicesSelectViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        ServicesProfileModel model = (ServicesProfileModel)this.getModel();
        if (model != null) {
            try {
                Map values = this.getValues();
                model.assignService(values);
                this.forwardToServicesViewBean();
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.forwardTo();
        }
    }

    private void forwardToServicesViewBean() {
        ServicesViewBean vb = (ServicesViewBean)this.getViewBean(ServicesViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        ServicesProfileModel model;
        Map map;
        super.beginDisplay(event);
        if (!this.submitCycle && (map = (model = (ServicesProfileModel)this.getModel()).getDefaultAttributeValues()) != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
            ps.setAttributeValues(map, model);
        }
    }

    protected Map getValues() throws ModelControlException, AMConsoleException {
        Map values = null;
        ServicesProfileModel model = (ServicesProfileModel)this.getModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
            values = ps.getAttributeValues(model.getDefaultAttributeValues(), false, model);
        }
        return values;
    }

    protected Map getAttributeValues() {
        ServicesProfileModel model = (ServicesProfileModel)this.getModel();
        Map values = model.getDefaultAttributeValues();
        return values != null ? values : Collections.EMPTY_MAP;
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.realm.services.addService";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

