/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.tools.bundles.SetupConstants;
import java.util.Locale;
import java.util.ResourceBundle;

public class VersionCheck
implements SetupConstants {
    private static ResourceBundle bundle = ResourceBundle.getBundle(System.getProperty("file.setup", "com.sun.identity.tools.bundles.amadmtoolssetup"));

    public static int isValid() {
        try {
            Bootstrap.load();
        }
        catch (ConfiguratorException ex) {
            System.err.println(ex.getL10NMessage(Locale.getDefault()));
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println(bundle.getString("message.error.amconfig") + " " + System.getProperty("bootstrap.dir"));
            return 1;
        }
        return VersionCheck.isVersionValid();
    }

    public static int isVersionValid() {
        String javaExpectedVersion = System.getProperty("java.version.expected");
        String amExpectedVersion = System.getProperty("am.version.expected");
        String configVersion = SystemProperties.get(System.getProperty("am.version.current")).trim();
        if (!VersionCheck.versionCompatible(System.getProperty("java.vm.version"), javaExpectedVersion)) {
            System.out.println(bundle.getString("message.error.version.jvm") + " " + javaExpectedVersion + " .");
            return 1;
        }
        if (configVersion.length() != amExpectedVersion.length()) {
            System.out.println(bundle.getString("message.error.version.am") + " " + amExpectedVersion + " .");
            return 1;
        }
        if (!VersionCheck.versionCompatible(configVersion, amExpectedVersion)) {
            System.out.println(bundle.getString("message.error.version.am") + " " + amExpectedVersion + " .");
            return 1;
        }
        return 0;
    }

    protected static boolean versionCompatible(String currentVersion, String expectedVersion) {
        if (Character.isDigit(expectedVersion.charAt(expectedVersion.length() - 1))) {
            if (!currentVersion.startsWith(expectedVersion)) {
                return false;
            }
        } else {
            boolean backwardCom = false;
            int compareLength = Math.min(expectedVersion.length() - 1, currentVersion.length());
            if (expectedVersion.endsWith("-")) {
                backwardCom = true;
            }
            for (int i = 0; i < compareLength; ++i) {
                if (backwardCom) {
                    if (expectedVersion.charAt(i) >= currentVersion.charAt(i)) continue;
                    return false;
                }
                if (currentVersion.charAt(i) > expectedVersion.charAt(i)) break;
                if (currentVersion.charAt(i) >= expectedVersion.charAt(i)) continue;
                return false;
            }
        }
        return true;
    }
}

