/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.policy.RuleAddViewBean;
import com.sun.identity.console.policy.RuleNoResourceAddViewBean;
import com.sun.identity.console.policy.RuleWithPrefixAddViewBean;
import com.sun.identity.console.policy.SelectTypeViewBeanBase;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.Policy;
import com.sun.web.ui.view.html.CCRadioButton;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class SelectServiceTypeViewBean
extends SelectTypeViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/SelectServiceType.jsp";
    private static final String ATTR_RULE_NAME = "tfRuleName";
    private static final String ATTR_SERVICE_TYPE = "radioServiceType";
    private static final String WITH_RESOURCE_SUFFIX = "1";
    private static final String WITHOUT_RESOURCE_SUFFIX = "0";
    public static final String CALLING_VIEW_BEAN = "SelectServiceTypeViewBeanCallingVB";

    public SelectServiceTypeViewBean() {
        super("SelectServiceType", DEFAULT_DISPLAY_URL);
    }

    protected String getTypeOptionsChildName() {
        return ATTR_SERVICE_TYPE;
    }

    protected OptionList getTypeOptions() {
        PolicyModel model = (PolicyModel)this.getModel();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            Policy policy = this.getCachedPolicy().getPolicy();
            Map map = model.getServiceTypeNames();
            HashMap<String, String> options = new HashMap<String, String>();
            for (String name : map.keySet()) {
                String lbl;
                String[] param;
                String label = (String)map.get(name);
                if (model.requiredResourceName(policy, curRealm, name)) {
                    param = new String[]{label};
                    lbl = MessageFormat.format(model.getLocalizedString("policy.rules.withResourceName"), param);
                    options.put(name + "|" + WITH_RESOURCE_SUFFIX, lbl);
                }
                if (!model.notRequiredResourceName(policy, curRealm, name)) continue;
                param = new String[]{label};
                lbl = MessageFormat.format(model.getLocalizedString("policy.rules.withoutResourceName"), param);
                options.put(name + "|" + WITHOUT_RESOURCE_SUFFIX, lbl);
            }
            return AMFormatUtils.getSortedOptionList(options, model.getUserLocale());
        }
        catch (AMConsoleException e) {
            debug.message("SelectServiceTypeViewBean.getTypeOptions creating empty option list");
            return new OptionList();
        }
    }

    protected String getPropertyXMLFileName() {
        return "com/sun/identity/console/propertyPMSelectServiceType.xml";
    }

    protected String getCallingViewBeanPgSessionName() {
        return CALLING_VIEW_BEAN;
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        String realmName;
        PolicyModel model = (PolicyModel)this.getModel();
        String formatServiceType = (String)this.propertySheetModel.getValue(ATTR_SERVICE_TYPE);
        int idx = formatServiceType.indexOf("|");
        String serviceType = formatServiceType.substring(0, idx);
        boolean withResource = formatServiceType.substring(idx + 1).equals(WITH_RESOURCE_SUFFIX);
        this.setPageSessionAttribute("RuleOpViewBeanBaseCallingVB", (Serializable)((Object)((String)this.getPageSessionAttribute(CALLING_VIEW_BEAN))));
        this.setPageSessionAttribute("withResource", withResource ? Boolean.TRUE : Boolean.FALSE);
        RuleAddViewBean vb = null;
        vb = withResource ? (model.canCreateNewResource(realmName = (String)this.getPageSessionAttribute("currentRealm"), serviceType) ? (RuleAddViewBean)this.getViewBean(RuleAddViewBean.class) : (RuleAddViewBean)this.getViewBean(RuleWithPrefixAddViewBean.class)) : (RuleNoResourceAddViewBean)this.getViewBean(RuleNoResourceAddViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.serviceType = serviceType;
        vb.forwardTo(this.getRequestContext());
    }

    protected void setDefaultServiceOption(CCRadioButton rb) {
        rb.setValue((Object)"iPlanetAMWebAgentService|1");
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.selectServiceType";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

