/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogQuery;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.QueryElement;
import com.sun.identity.log.handlers.LogReadHandler;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.util.LogRecordSorter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LogReadFileHandler
implements LogReadHandler {
    private String logFileName;
    private LogQuery queryChriteria = null;
    private int maxNoOfRecs = -1;
    private String version = "#Version:";
    private String fieldName = "#Fields: ";
    private LogRecordSorter sorter = null;
    private String[][] queryResult;
    private ArrayList listOfValidRecords = new ArrayList();
    private ArrayList columnIndices = null;

    public String[][] logRecRead(String fileName, LogQuery logQuery, boolean sourceData) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String sortByField;
        this.cleaner();
        this.logFileName = fileName;
        boolean hdrExist = false;
        if (sourceData) {
            this.queryChriteria = logQuery;
        }
        try {
            hdrExist = this.getFieldNames(true, logQuery);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        if (!hdrExist) {
            return this.queryResult;
        }
        this.maxNoOfRecs = logQuery != null ? (logQuery.getNumRecordsWanted() == -1 || logQuery.getNumRecordsWanted() < -2 ? 1 : logQuery.getNumRecordsWanted()) : 1;
        try {
            if (sourceData) {
                this.getRecords(true);
            } else {
                this.getRecords(false);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        int recSize = this.listOfValidRecords.size();
        if (recSize <= 0) {
            return null;
        }
        if (this.queryChriteria != null && (sortByField = this.queryChriteria.getSortingField()) != null) {
            try {
                this.sorter = new LogRecordSorter(sortByField, this.listOfValidRecords);
                this.queryResult = this.sorter.getSortedRecords();
                return this.queryResult;
            }
            catch (NoSuchFieldException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        this.queryResult = new String[recSize][];
        for (int i = 0; i < recSize; ++i) {
            this.queryResult[i] = (String[])this.listOfValidRecords.get(i);
        }
        return this.queryResult;
    }

    public String[][] logRecRead(Set fileNames, LogQuery logQuery, boolean sourceData) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String sortByField;
        this.cleaner();
        HashSet<String> fNames = new HashSet<String>();
        boolean isFirstFile = true;
        for (String ss : fileNames) {
            fNames.add(ss);
            this.logFileName = ss;
            if (Debug.messageEnabled()) {
                Debug.message("File:logRecRead/2: processing file " + ss + ", sourceData = " + sourceData);
            }
            boolean hdrExist = false;
            if (sourceData) {
                this.queryChriteria = logQuery;
            }
            try {
                hdrExist = this.getFieldNames(isFirstFile, logQuery);
                isFirstFile = false;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            if (!hdrExist) {
                return this.queryResult;
            }
            this.maxNoOfRecs = logQuery != null ? (logQuery.getNumRecordsWanted() == -1 || logQuery.getNumRecordsWanted() < -2 ? 1 : logQuery.getNumRecordsWanted()) : 1;
            try {
                if (sourceData) {
                    this.getRecordsMulti(true);
                    continue;
                }
                this.getRecordsMulti(false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        int recSize = this.listOfValidRecords.size();
        if (recSize <= 0) {
            return null;
        }
        if (this.queryChriteria != null && (sortByField = this.queryChriteria.getSortingField()) != null) {
            try {
                this.sorter = new LogRecordSorter(sortByField, this.listOfValidRecords);
                this.queryResult = this.sorter.getSortedRecords();
                return this.queryResult;
            }
            catch (NoSuchFieldException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        this.queryResult = new String[recSize][];
        for (int i = 0; i < recSize; ++i) {
            this.queryResult[i] = (String[])this.listOfValidRecords.get(i);
        }
        return this.queryResult;
    }

    private boolean getFieldNames(boolean addFields, LogQuery logQry) throws IOException, RuntimeException, Exception {
        boolean foundHeader = false;
        try {
            String fieldBuffer;
            BufferedReader fileReader = new BufferedReader(new FileReader(this.logFileName));
            while ((fieldBuffer = fileReader.readLine()) != null) {
                if (fieldBuffer.trim().length() <= 0 || fieldBuffer.startsWith(this.version) || !fieldBuffer.startsWith(this.fieldName)) continue;
                String hdrStr = fieldBuffer.substring(this.fieldName.length());
                if (foundHeader) break;
                ArrayList tmpList = this.getFields(hdrStr, true);
                String[] spltHdrStr = null;
                ArrayList al = null;
                if (logQry != null) {
                    al = logQry.getColumns();
                    if (al != null) {
                        this.columnIndices = new ArrayList();
                        spltHdrStr = new String[al.size()];
                    } else {
                        spltHdrStr = new String[tmpList.size()];
                    }
                } else {
                    spltHdrStr = new String[tmpList.size()];
                }
                int j = 0;
                int tmpListSz = tmpList.size();
                for (int i = 0; i < tmpListSz; ++i) {
                    String tmps = (String)tmpList.get(i);
                    if (al != null) {
                        if (!al.contains(tmps)) continue;
                        this.columnIndices.add(j, Integer.toString(i));
                        spltHdrStr[j++] = tmps;
                        continue;
                    }
                    spltHdrStr[j++] = tmps;
                }
                if (addFields) {
                    this.listOfValidRecords.add(spltHdrStr);
                }
                foundHeader = true;
                break;
            }
            fileReader.close();
        }
        catch (IOException e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new IOException(msg);
        }
        catch (RuntimeException e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            throw e;
        }
        return foundHeader;
    }

    private boolean getRecords(boolean isSourceData) throws IOException, RuntimeException {
        String dummyStr = null;
        StringBuffer dummySbuf = new StringBuffer(" ");
        int dcnt = 0;
        dcnt = this.columnIndices != null ? this.columnIndices.size() : 14;
        for (int i = 1; i < dcnt; ++i) {
            dummySbuf.append("\t ");
        }
        dummyStr = dummySbuf.toString();
        BufferedReader flRead = null;
        try {
            String bufferedStr;
            flRead = new BufferedReader(new FileReader(this.logFileName));
            while ((bufferedStr = flRead.readLine()) != null) {
                if (bufferedStr.trim().length() <= 0) {
                    if (!LogReader.isLogSecure()) continue;
                    Debug.error("LogReadFileHandler.getRecords: Blank line in secure log");
                    bufferedStr = dummyStr;
                }
                if (bufferedStr.startsWith(this.version) || bufferedStr.startsWith(this.fieldName)) continue;
                ArrayList listOfFields = new ArrayList();
                listOfFields = this.getFields(bufferedStr, isSourceData);
                String[] spltStrArr = null;
                spltStrArr = this.columnIndices != null ? new String[this.columnIndices.size()] : new String[listOfFields.size()];
                int j = 0;
                for (int i = 0; i < listOfFields.size(); ++i) {
                    if (this.columnIndices != null) {
                        if (!this.columnIndices.contains(Integer.toString(i))) continue;
                        spltStrArr[j++] = (String)listOfFields.get(i);
                        continue;
                    }
                    spltStrArr[i] = (String)listOfFields.get(i);
                }
                if (this.queryChriteria == null) {
                    this.collect(spltStrArr);
                    continue;
                }
                if (!this.applyQuery(spltStrArr)) continue;
                this.collect(spltStrArr);
            }
        }
        catch (RuntimeException e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new IOException(msg);
        }
        catch (Exception e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new RuntimeException(msg);
        }
        finally {
            flRead.close();
        }
        return true;
    }

    private boolean getRecordsMulti(boolean isSourceData) throws IOException, RuntimeException {
        int localNumRecs = 0;
        ArrayList<String[]> localListOfValidRecords = new ArrayList<String[]>();
        try {
            String bufferedStr;
            BufferedReader flRead = new BufferedReader(new FileReader(this.logFileName));
            while ((bufferedStr = flRead.readLine()) != null) {
                if (bufferedStr.trim().length() <= 0 || bufferedStr.startsWith(this.version) || bufferedStr.startsWith(this.fieldName)) continue;
                ArrayList listOfFields = new ArrayList();
                listOfFields = this.getFields(bufferedStr, isSourceData);
                String[] spltStrArr = null;
                spltStrArr = this.columnIndices != null ? new String[this.columnIndices.size()] : new String[listOfFields.size()];
                int j = 0;
                for (int i = 0; i < listOfFields.size(); ++i) {
                    if (this.columnIndices != null) {
                        if (!this.columnIndices.contains(Integer.toString(i))) continue;
                        spltStrArr[j++] = (String)listOfFields.get(i);
                        continue;
                    }
                    spltStrArr[i] = (String)listOfFields.get(i);
                }
                int rec_size = localListOfValidRecords.size();
                if (this.queryChriteria != null && !this.applyQuery(spltStrArr)) continue;
                if (this.maxNoOfRecs != -2 && localNumRecs > this.maxNoOfRecs) {
                    localListOfValidRecords.remove(1);
                }
                localListOfValidRecords.add(spltStrArr);
                ++localNumRecs;
            }
            if (localNumRecs > this.maxNoOfRecs) {
                localNumRecs = this.maxNoOfRecs;
            }
            String[] tmpxx = null;
            for (int i = 0; i < localNumRecs; ++i) {
                tmpxx = (String[])localListOfValidRecords.get(i);
                this.listOfValidRecords.add(tmpxx);
            }
            flRead.close();
        }
        catch (RuntimeException e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new IOException(msg);
        }
        catch (Exception e) {
            String msg = "Problem in reading " + this.logFileName;
            throw new RuntimeException(msg);
        }
        return true;
    }

    private boolean applyQuery(String[] recordToBeQueried) {
        ArrayList queries = this.queryChriteria.getQueries();
        if (queries == null) {
            return true;
        }
        int qrySz = queries.size();
        if (qrySz == 0) {
            return true;
        }
        int queryCondition = this.queryChriteria.getGlobalOperand();
        boolean isMatch = false;
        for (int i = 0; i < qrySz; ++i) {
            isMatch = false;
            isMatch = this.doMatch(recordToBeQueried, (QueryElement)queries.get(i));
            if (!(queryCondition == 1 ? !isMatch : queryCondition == 2 && isMatch)) continue;
            return isMatch;
        }
        return isMatch;
    }

    private boolean doMatch(String[] record, QueryElement elem) {
        boolean isFound = false;
        int fieldPos = -1;
        String[] fields = (String[])this.listOfValidRecords.get(0);
        int fieldNo = fields.length;
        String fldName = elem.getFieldName();
        String fldValue = elem.getFieldValue();
        for (int i = 0; i < fieldNo; ++i) {
            if (fldName.compareTo(fields[i]) != 0) continue;
            fieldPos = i;
            break;
        }
        if (fieldPos == -1) {
            return isFound;
        }
        int result = 0;
        int rel = elem.getRelation();
        switch (rel) {
            case 7: {
                return record[fieldPos].indexOf(fldValue) != -1;
            }
            case 8: {
                return record[fieldPos].startsWith(fldValue);
            }
            case 9: {
                return record[fieldPos].endsWith(fldValue);
            }
        }
        result = record[fieldPos].compareTo(fldValue);
        switch (rel) {
            case 3: {
                if (result != 0) break;
                return true;
            }
            case 2: {
                if (result >= 0) break;
                return true;
            }
            case 1: {
                if (result <= 0) break;
                return true;
            }
            case 6: {
                if (result > 0) break;
                return true;
            }
            case 5: {
                if (result < 0) break;
                return true;
            }
            case 4: {
                if (result == 0) break;
                return true;
            }
        }
        return false;
    }

    private void collect(String[] recordValues) {
        int rec_size = this.listOfValidRecords.size();
        if (this.maxNoOfRecs != -2 && rec_size > this.maxNoOfRecs) {
            this.shiftRecordsUpward();
        }
        this.appendRecord(recordValues);
    }

    private void appendRecord(String[] record) {
        this.listOfValidRecords.add(record);
    }

    private void shiftRecordsUpward() {
        if (this.listOfValidRecords.size() <= 1) {
            return;
        }
        this.listOfValidRecords.remove(1);
    }

    private ArrayList getFields(String bufferedStr, boolean source) {
        String str = bufferedStr.trim();
        ArrayList<String> fields = new ArrayList<String>();
        char quote = '\"';
        char new_line = '\n';
        char cr_return = '\r';
        int current_position = 0;
        boolean isNewField = true;
        String tmpStr = new String();
        int str_len = str.length();
        while (current_position < str_len) {
            char read_char = str.charAt(current_position);
            if (read_char == quote) {
                String sub_str = str.substring(current_position);
                int current_sub_position = 1;
                boolean quotedFieldAdded = false;
                String buffer = new String();
                if (!source) {
                    buffer = buffer + quote;
                }
                boolean pending_quote = false;
                while (current_sub_position < str_len) {
                    char ch = sub_str.charAt(current_sub_position);
                    if (ch != quote && ch != new_line && ch != cr_return) {
                        buffer = buffer + ch;
                        ++current_sub_position;
                        continue;
                    }
                    if (current_sub_position == sub_str.length() - 1) {
                        if (!source) {
                            buffer = buffer + ch;
                        } else if (ch != quote) {
                            buffer = buffer + ch;
                        }
                        fields.add(buffer);
                        current_position += ++current_sub_position;
                        quotedFieldAdded = true;
                        break;
                    }
                    if (sub_str.charAt(current_sub_position + 1) != quote && sub_str.charAt(current_sub_position + 1) != new_line && sub_str.charAt(current_sub_position + 1) != cr_return) {
                        if (!source) {
                            buffer = buffer + ch;
                        }
                        ++current_sub_position;
                        if (pending_quote) {
                            pending_quote = false;
                            continue;
                        }
                        fields.add(buffer);
                        current_position += current_sub_position;
                        quotedFieldAdded = true;
                        break;
                    }
                    if (!source) {
                        buffer = buffer + ch;
                        pending_quote = true;
                    } else if (!pending_quote) {
                        buffer = buffer + ch;
                        pending_quote = true;
                    } else {
                        pending_quote = false;
                    }
                    ++current_sub_position;
                }
                if (quotedFieldAdded) continue;
                fields.add(buffer);
                current_position += current_sub_position;
                continue;
            }
            if (read_char == ' ' || read_char == '\t' || read_char == '\f' || read_char == '\r' || read_char == '\n') {
                if (isNewField) {
                    if (tmpStr.length() != 0) {
                        fields.add(tmpStr);
                    }
                    tmpStr = new String();
                    ++current_position;
                    continue;
                }
                isNewField = true;
                ++current_position;
                continue;
            }
            if (!isNewField) continue;
            tmpStr = tmpStr + read_char;
            if (++current_position != str_len) continue;
            fields.add(tmpStr);
        }
        return fields;
    }

    private void cleaner() {
        this.logFileName = null;
        this.queryChriteria = null;
        this.listOfValidRecords.clear();
        this.queryResult = null;
    }
}

