/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.ha.jmqdb;

import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.ha.FAMRecord;
import com.sun.identity.ha.FAMRecordPersister;
import com.sun.identity.ha.FAMRecordUtils;
import com.sun.identity.ha.jmqdb.ConnectionFactoryProvider;
import com.sun.identity.ha.jmqdb.ConnectionFactoryProviderFactory;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class FAMRecordJMQPersister
implements FAMRecordPersister,
MessageListener {
    public static final String NOT_FOUND = "notfound";
    public static final String OP_STATUS = "opstatus";
    public static final String DBREQUEST = "AM_DBREQUEST";
    public static final String DBRESPONSE = "AM_DRESPONSE";
    public static final String ID = "ID";
    public static int TIMEOUT = 1000;
    private String _id;
    TopicConnectionFactory tFactory = null;
    TopicConnection tConn = null;
    TopicSession tSession = null;
    Topic reqTopic = null;
    Topic resTopic = null;
    TopicPublisher reqPub = null;
    TopicSubscriber resSub = null;
    Hashtable processedMsgs = new Hashtable();
    Random rdmGen = new Random();
    int msgcount = 0;
    private String serverList = null;
    private String userName = null;
    private String password = null;
    private int readTimeOut = 5000;
    private int readTimeOutForConstraint = 6000;

    public FAMRecordJMQPersister(String id) throws Exception {
        this._id = id;
        ConnectionFactoryProvider provider = ConnectionFactoryProviderFactory.getProvider();
        this.tFactory = provider.newTopicConnectionFactory();
        this.tConn = this.tFactory.createTopicConnection();
        int flag = 3;
        this.tSession = this.tConn.createTopicSession(false, flag);
        this.reqTopic = this.tSession.createTopic(DBREQUEST);
        this.resTopic = this.tSession.createTopic(DBRESPONSE);
        this.reqPub = this.tSession.createPublisher(this.reqTopic);
        String selector = "ID = '" + this._id + "'";
        this.resSub = this.tSession.createSubscriber(this.resTopic, selector, true);
        this.resSub.setMessageListener((MessageListener)this);
        this.tConn.start();
    }

    public FAMRecordJMQPersister() throws Exception {
        String thisServerProtocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
        String thisServer = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
        String thisServerPortAsString = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
        String thisURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
        if (thisServerProtocol == null || thisServerPortAsString == null || thisServer == null) {
            throw new Exception(FAMRecordUtils.bundle.getString("propertyMustBeSet"));
        }
        this._id = WebtopNaming.getServerID(thisServerProtocol, thisServer, thisServerPortAsString, thisURI);
        this.serverList = SessionService.getJdbcURL();
        this.userName = SessionService.getSessionStoreUserName();
        this.password = SessionService.getSessionStorePassword();
        this.readTimeOut = SessionService.getConnectionMaxWaitTime();
        this.readTimeOutForConstraint = SessionService.getMaxWaitTimeForConstraint();
        ConnectionFactoryProvider provider = ConnectionFactoryProviderFactory.getProvider();
        this.tFactory = provider.newTopicConnectionFactory(this.serverList, true, true, this.userName, this.password);
        this.tConn = this.tFactory.createTopicConnection();
        int flag = 3;
        this.tSession = this.tConn.createTopicSession(false, flag);
        this.reqTopic = this.tSession.createTopic(DBREQUEST);
        this.resTopic = this.tSession.createTopic(DBRESPONSE);
        this.reqPub = this.tSession.createPublisher(this.reqTopic);
        this.reqPub.setDeliveryMode(1);
        String selector = "ID = '" + this._id + "'";
        this.resSub = this.tSession.createSubscriber(this.resTopic, selector, true);
        this.resSub.setMessageListener((MessageListener)this);
        this.tConn.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block5: {
            try {
                BytesMessage msg = (BytesMessage)message;
                long rndnum = msg.readLong();
                Long random = new Long(rndnum);
                Object rnd = this.processedMsgs.get(random);
                if (rnd == null) break block5;
                this.processedMsgs.put(rnd, message);
                Object v = rnd;
                synchronized (v) {
                    rnd.notify();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FAMRecord send(FAMRecord famRecord) throws Exception {
        Long random;
        Iterator it;
        HashMap mm;
        String tmp;
        long expirationTime;
        BytesMessage msg = this.tSession.createBytesMessage();
        msg.setStringProperty(ID, this._id);
        String op = famRecord.getOperation();
        msg.setStringProperty("op", op);
        String service = famRecord.getService();
        msg.setStringProperty("service", service);
        String pKey = famRecord.getPrimaryKey();
        if (pKey != null && !pKey.equals("")) {
            msg.writeLong((long)pKey.length());
            msg.writeBytes(pKey.getBytes());
        }
        if ((expirationTime = famRecord.getExpDate()) > 0L) {
            msg.writeLong(expirationTime);
        }
        if ((tmp = famRecord.getSecondarykey()) != null && !tmp.equals("")) {
            msg.writeLong((long)tmp.length());
            msg.writeBytes(tmp.getBytes());
        } else if (op.equals("WRITE")) {
            msg.writeLong(0L);
        }
        tmp = famRecord.getAuxData();
        if (tmp != null && !tmp.equals("")) {
            msg.writeLong((long)tmp.length());
            msg.writeBytes(tmp.getBytes());
        } else if (op.equals("WRITE")) {
            msg.writeLong(0L);
        }
        int state = famRecord.getState();
        if (state > 0) {
            msg.writeInt(state);
        } else if (op.equals("WRITE")) {
            msg.writeInt(0);
        }
        byte[] blob = famRecord.getBlob();
        if (blob != null) {
            msg.writeLong((long)blob.length);
            msg.writeBytes(blob);
        }
        if ((mm = famRecord.getExtraByteAttributes()) != null) {
            it = mm.keySet().iterator();
            while (it.hasNext()) {
                byte[] bt = famRecord.getBytes((String)it.next());
                msg.writeLong((long)bt.length);
                msg.writeBytes(bt);
            }
        }
        if ((mm = famRecord.getExtraStringAttributes()) != null) {
            it = mm.keySet().iterator();
            String key = null;
            while (it.hasNext()) {
                key = (String)it.next();
                tmp = famRecord.getString(key);
                msg.setStringProperty(key, tmp);
            }
        }
        if (op.equals("DELETE") || op.equals("DELETEBYDATE") || op.equals("WRITE") || op.equals("SHUTDOWN")) {
            this.reqPub.publish((Message)msg);
            return null;
        }
        if (op.equals("READ")) {
            random = new Long(this.rdmGen.nextLong());
            this.processedMsgs.put(random, random);
            msg.writeLong(random.longValue());
            Long l = random;
            synchronized (l) {
                this.reqPub.publish((Message)msg);
                random.wait(this.readTimeOut);
            }
            Object object = this.processedMsgs.remove(random);
            if (object instanceof Long) {
                return null;
            }
            BytesMessage message1 = (BytesMessage)object;
            String opStatus = message1.getStringProperty(OP_STATUS);
            if (opStatus != null && opStatus.equals(NOT_FOUND)) {
                throw new Exception(FAMRecordUtils.bundle.getString("notFoundSession"));
            }
            long len = message1.readLong();
            byte[] bytes = new byte[(int)len];
            message1.readBytes(bytes);
            FAMRecord ret = new FAMRecord(service, op, pKey, 0L, null, 0, null, bytes);
            return ret;
        }
        if (op.equals("GET_RECORD_COUNT")) {
            random = new Long(this.rdmGen.nextLong());
            this.processedMsgs.put(random, random);
            msg.writeLong(random.longValue());
            Long object = random;
            synchronized (object) {
                this.reqPub.publish((Message)msg);
                random.wait(this.readTimeOutForConstraint);
            }
            Object retMsg = this.processedMsgs.remove(random);
            if (retMsg instanceof Long) {
                return null;
            }
            BytesMessage message1 = (BytesMessage)retMsg;
            int retCount = 0;
            HashMap<String, Long> aMap = new HashMap<String, Long>();
            if (message1 != null) {
                retCount = message1.readInt();
                String hKey = null;
                for (int i = 0; i < retCount; ++i) {
                    int len = message1.readInt();
                    byte[] bytes = new byte[len];
                    message1.readBytes(bytes);
                    hKey = new String(bytes);
                    Long expireTime = new Long(message1.readLong());
                    aMap.put(hKey, expireTime);
                }
            }
            FAMRecord ret = new FAMRecord(service, op, pKey, 0L, null, 0, null, null);
            ret.setStringAttrs(aMap);
            return ret;
        }
        if (op.equals("READ_WITH_SEC_KEY")) {
            random = new Long(this.rdmGen.nextLong());
            this.processedMsgs.put(random, random);
            msg.writeLong(random.longValue());
            Long retMsg = random;
            synchronized (retMsg) {
                this.reqPub.publish((Message)msg);
                random.wait(this.readTimeOutForConstraint);
            }
            retMsg = this.processedMsgs.remove(random);
            if (retMsg instanceof Long) {
                return null;
            }
            BytesMessage message1 = (BytesMessage)retMsg;
            Vector<byte[]> blobs = new Vector<byte[]>();
            if (message1 != null) {
                int retCount = message1.readInt();
                for (int i = 0; i < retCount; ++i) {
                    int len = message1.readInt();
                    byte[] bytes = new byte[len];
                    message1.readBytes(bytes);
                    blobs.add(bytes);
                }
            }
            HashMap<String, Vector<byte[]>> aMap = new HashMap<String, Vector<byte[]>>();
            aMap.put("blobs", blobs);
            FAMRecord ret = new FAMRecord(service, op, pKey, 0L, null, 0, null, null);
            ret.setStringAttrs(aMap);
            return ret;
        }
        return null;
    }
}

