/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.dpro.session.share.SessionRequestParser;
import com.iplanet.dpro.session.share.SessionResponseParser;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SessionNotificationParser {
    private SessionNotification sessionNotification = null;
    private Document document;

    public SessionNotificationParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public SessionNotificationParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument((String)xmlString, (Debug)SessionRequestParser.debug);
    }

    public SessionNotification parseXML() {
        Element time;
        Element type;
        Element sess;
        if (this.document == null) {
            return null;
        }
        Element elem = this.document.getDocumentElement();
        this.sessionNotification = new SessionNotification();
        String temp = elem.getAttribute("vers");
        this.sessionNotification.setNotificationVersion(temp);
        temp = elem.getAttribute("notid");
        this.sessionNotification.setNotificationID(temp);
        NodeList nodelist = elem.getElementsByTagName("Session");
        if (nodelist != null && nodelist.getLength() != 0 && (sess = (Element)nodelist.item(0)) != null) {
            this.sessionNotification.setSessionInfo(SessionResponseParser.parseSessionElement(sess));
        }
        if ((nodelist = elem.getElementsByTagName("Type")) != null && nodelist.getLength() != 0 && (type = (Element)nodelist.item(0)) != null) {
            try {
                int sType = new Integer(SessionRequestParser.parseCDATA(type));
                this.sessionNotification.setNotificationType(sType);
            }
            catch (Exception e) {
                SessionRequestParser.debug.message("Session.Notif Type", (Throwable)e);
            }
        }
        if ((nodelist = elem.getElementsByTagName("Time")) != null && nodelist.getLength() != 0 && (time = (Element)nodelist.item(0)) != null) {
            try {
                long sTime = new Long(SessionRequestParser.parseCDATA(time));
                this.sessionNotification.setNotificationTime(sTime);
            }
            catch (Exception e) {
                SessionRequestParser.debug.message("Session.Notif Time", (Throwable)e);
            }
        }
        return this.sessionNotification;
    }
}

