/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.jaxrpc;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSSchema;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;

public class SMSJAXRPCObject
extends SMSObject
implements SMSObjectListener {
    private static SOAPClient client;
    public static final String AMJAXRPCVERSIONSTR = "AM_JAXRPC_VERSION";
    public static final String AMJAXRPCVERSION = "11";
    public static final String NOTIFICATION_PROPERTY = "com.sun.identity.sm.notification.enabled";
    private static String baseDN;
    private static String amsdkbaseDN;
    private static int entriesPresentCacheSize;
    private static Set entriesPresent;
    private static Set entriesNotPresent;
    private static boolean initializedNotification;
    private static boolean notificationInitialized;
    protected static boolean isLocal;
    private static Debug debug;
    private static SMSObjectListener objectListener;

    public SMSJAXRPCObject() {
        client = new SOAPClient("SMSObjectIF");
    }

    private void initializeNotification() {
        if (!initializedNotification) {
            if (SMSNotificationManager.isCacheEnabled()) {
                SMSNotificationManager.getInstance().registerCallbackHandler(this);
            }
            initializedNotification = true;
        }
    }

    public Map read(SSOToken token, String objName) throws SMSException, SSOException {
        try {
            Object[] objs = new String[]{((Object)token.getTokenID()).toString(), objName};
            Map attrs = (Map)client.send(client.encodeMessage("read", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            return attrs == null ? null : new CaseInsensitiveHashMap(attrs);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:read -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-cannot-read");
        }
    }

    public void create(SSOToken token, String objName, Map attributes) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), objName, attributes};
            client.send(client.encodeMessage("create", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:create -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-cannot-create");
        }
    }

    public void modify(SSOToken token, String objName, ModificationItem[] mods) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), objName, SMSJAXRPCObject.toMods(mods)};
            client.send(client.encodeMessage("modify", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:modify -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-cannot-modify");
        }
    }

    public void delete(SSOToken token, String objName) throws SMSException, SSOException {
        try {
            Object[] objs = new String[]{((Object)token.getTokenID()).toString(), objName};
            client.send(client.encodeMessage("delete", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:delete -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-cannot-delete");
        }
    }

    public Set searchSubOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), dn, filter, new Integer(numOfEntries), sortResults, ascendingOrder, recursive};
            return (Set)client.send(client.encodeMessage("searchSubOrgNames", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject.searchSubOrgNames", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-suborg-cannot-search");
        }
    }

    public Set searchOrganizationNames(SSOToken token, String dn, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), dn, new Integer(numOfEntries), sortResults, ascendingOrder, serviceName, attrName, values};
            return (Set)client.send(client.encodeMessage("searchOrganizationNames", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject.searchOrganizationNames", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-org-cannot-search");
        }
    }

    public Set subEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), dn, filter, new Integer(numOfEntries), sortResults, ascendingOrder};
            return (Set)client.send(client.encodeMessage("subEntries", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:subEntries -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-subentry-cannot-search");
        }
    }

    public Set schemaSubEntries(SSOToken token, String dn, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), dn, filter, sidFilter, new Integer(numOfEntries), sortResults, ascendingOrder};
            return (Set)client.send(client.encodeMessage("schemaSubEntries", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:subEntries -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-schemasubentry-cannot-search");
        }
    }

    public Iterator search(SSOToken token, String startDN, String filter, Set excludes) throws SMSException, SSOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Set search(SSOToken token, String startDN, String filter) throws SMSException, SSOException {
        try {
            Object[] objs = new String[]{((Object)token.getTokenID()).toString(), startDN, filter};
            return (Set)client.send(client.encodeMessage("search", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:search -- Exception:", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-error-in-searching");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(SSOToken token, String dn) {
        Iterator items;
        Set set;
        dn = new DN(dn).toRFCString().toLowerCase();
        if (SMSNotificationManager.isCacheEnabled() && entriesPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + dn);
            }
            return true;
        }
        if (SMSNotificationManager.isCacheEnabled() && entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + dn);
            }
            return false;
        }
        boolean entryExists = false;
        try {
            Object[] objs = new String[]{((Object)token.getTokenID()).toString(), dn};
            Boolean b = (Boolean)client.send(client.encodeMessage("entryExists", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            entryExists = b;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObject:entryExists -- Exception:", (Throwable)re);
            return false;
        }
        if (entryExists && SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesPresent.add(dn);
            if (entriesPresent.size() > entriesPresentCacheSize) {
                set = entriesPresent;
                synchronized (set) {
                    items = entriesPresent.iterator();
                    if (items.hasNext()) {
                        items.remove();
                    }
                }
            }
        } else if (SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesNotPresent.add(dn);
            if (entriesNotPresent.size() > entriesPresentCacheSize) {
                set = entriesNotPresent;
                synchronized (set) {
                    items = entriesNotPresent.iterator();
                    if (items.hasNext()) {
                        items.remove();
                    }
                }
            }
        }
        return entryExists;
    }

    public String getRootSuffix() {
        if (baseDN == null) {
            try {
                baseDN = (String)client.send(client.encodeMessage("getRootSuffix", null), null, null);
            }
            catch (Exception re) {
                debug.error("SMSJAXRPCObject:getRootSuffix:Exception:", (Throwable)re);
            }
        }
        return baseDN;
    }

    public String getAMSdkBaseDN() {
        if (amsdkbaseDN == null) {
            try {
                amsdkbaseDN = (String)client.send(client.encodeMessage("getAMSdkBaseDN", null), null, null);
            }
            catch (Exception re) {
                debug.error("SMSJAXRPCObject:getAMSdkBaseDN:Exception:", (Throwable)re);
            }
        }
        return amsdkbaseDN;
    }

    public boolean validateServiceAttributes(SSOToken token, String validatorClass, Set values) throws SMSException, SSOException {
        try {
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), validatorClass, values};
            Boolean b = (Boolean)client.send(client.encodeMessage("validateServiceAttributes", objs), null, null);
            return b;
        }
        catch (SSOException e) {
            throw e;
        }
        catch (SMSException smse) {
            throw smse;
        }
        catch (Exception re) {
            debug.error("SMSJAXRPCObjectvalidateServiceAttributes", (Throwable)re);
            throw new SMSException(re, "sms-JAXRPC-attribute-values-validation-failed");
        }
    }

    public void registerCallbackHandler(SMSObjectListener changeListener) throws SMSException {
        objectListener = changeListener;
        if (!notificationInitialized) {
            String notificationFlag = SystemProperties.get(NOTIFICATION_PROPERTY, "true");
            if (notificationFlag.equalsIgnoreCase("true")) {
                try {
                    URL url = WebtopNaming.getNotificationURL();
                    PLLClient.addNotificationHandler("SMSObjectIF", new SMSNotificationHandler());
                    client.send("registerNotificationURL", (Object)url.toString(), null, null);
                    if (debug.messageEnabled()) {
                        debug.message("SMSJAXRPCObject: Using notification mechanism for cache updates: " + url);
                    }
                }
                catch (Exception e) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSJAXRPCObject: Registering for notification via URL failed: " + e.getMessage() + "\nUsing polling mechanism for updates");
                    }
                    SMSJAXRPCObject.startPollingThreadIfEnabled(this.getCachePollingInterval());
                }
            } else {
                SMSJAXRPCObject.startPollingThreadIfEnabled(this.getCachePollingInterval());
            }
            notificationInitialized = true;
        }
    }

    private int getCachePollingInterval() {
        String cachePollingTimeStr = SystemProperties.get("com.sun.identity.sm.cacheTime");
        int cachePollingInterval = 1;
        if (cachePollingTimeStr != null) {
            try {
                cachePollingInterval = Integer.parseInt(cachePollingTimeStr);
            }
            catch (NumberFormatException nfe) {
                debug.error("EventListener::NotificationRunnable:: Invalid Polling Time: " + cachePollingTimeStr + " Defaulting to " + 1 + " minute", (Throwable)nfe);
            }
        }
        return cachePollingInterval;
    }

    private static void startPollingThreadIfEnabled(int cachePollingInterval) {
        if (cachePollingInterval > 0) {
            if (debug.messageEnabled()) {
                debug.message("EventListener: Polling mode enabled. Starting the polling thread..");
            }
            NotificationRunnable nr = new NotificationRunnable(cachePollingInterval);
            SystemTimerPool.getTimerPool().schedule((TaskRunnable)nr, new Date((System.currentTimeMillis() + nr.getRunPeriod()) / 1000L * 1000L));
        } else if (debug.warningEnabled()) {
            debug.warning("EventListener: Polling mode DISABLED. com.sun.identity.sm.cacheTime=" + cachePollingInterval);
        }
    }

    public void objectChanged(String dn, int type) {
        dn = new DN(dn).toRFCString().toLowerCase();
        if (type == 1) {
            entriesPresent.remove(dn);
        } else if (type == 0) {
            entriesNotPresent.remove(dn);
        }
    }

    public void allObjectsChanged() {
    }

    static String toMods(ModificationItem[] mods) throws SMSException {
        if (mods == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("<Modifications size=\"");
        sb.append(mods.length);
        sb.append("\">");
        for (int i = 0; i < mods.length; ++i) {
            sb.append("<AttributeValuePair event=\"");
            switch (mods[i].getModificationOp()) {
                case 1: {
                    sb.append("ADD");
                    break;
                }
                case 2: {
                    sb.append("REPLACE");
                    break;
                }
                case 3: {
                    sb.append("DELETE");
                }
            }
            sb.append("\"><Attribute name=\"");
            Attribute attr = mods[i].getAttribute();
            sb.append(attr.getID());
            sb.append("\"/>");
            int size = attr.size();
            for (int j = 0; j < size; ++j) {
                sb.append("<Value>");
                try {
                    sb.append(SMSSchema.escapeSpecialCharacters((String)attr.get(j)));
                }
                catch (NamingException ne) {
                    throw new SMSException(ne, "sms-JAXRPC-cannot-copy-fromModItemToString");
                }
                sb.append("</Value>");
            }
            sb.append("</AttributeValuePair>");
        }
        sb.append("</Modifications>");
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObject::ModsToString: " + sb.toString());
        }
        return sb.toString();
    }

    static void sendNotification(String modItem) {
        String dn = modItem.substring(4);
        int type = 3;
        if (modItem.startsWith("ADD:")) {
            type = 0;
        }
        if (modItem.startsWith("DEL:")) {
            type = 1;
        }
        objectListener.objectChanged(dn, type);
    }

    static {
        entriesPresentCacheSize = 1000;
        entriesPresent = Collections.synchronizedSet(new LinkedHashSet(entriesPresentCacheSize));
        entriesNotPresent = Collections.synchronizedSet(new LinkedHashSet(entriesPresentCacheSize));
        debug = Debug.getInstance((String)"amSMSClient");
    }

    static class SMSNotificationHandler
    implements NotificationHandler {
        SMSNotificationHandler() {
        }

        public void process(Vector notifications) {
            for (int i = 0; i < notifications.size(); ++i) {
                Notification notification = (Notification)notifications.elementAt(i);
                String content = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("SMSJAXRPCObject:SMSNotificationHandler:  received notification: " + content);
                }
                SMSJAXRPCObject.sendNotification(content);
            }
        }
    }

    static class NotificationRunnable
    extends GeneralTaskRunnable {
        static long WAIT_BEFORE_RETRY = 60000L;
        int pollingTime;
        volatile long sleepTime;
        SOAPClient client;

        NotificationRunnable(int interval) {
            this.pollingTime = interval;
            this.sleepTime = this.pollingTime * 1000 * 60;
            this.client = new SOAPClient("SMSObjectIF");
        }

        public void run() {
            try {
                Object[] obj = new Object[]{new Integer(this.pollingTime)};
                Set mods = (Set)this.client.send(this.client.encodeMessage("objectsChanged", obj), null, null);
                if (debug.messageEnabled()) {
                    debug.message("SMSJAXRPCObject:NotificationRunnable retrived changes: " + mods);
                }
                Iterator items = mods.iterator();
                while (items.hasNext()) {
                    SMSJAXRPCObject.sendNotification((String)items.next());
                }
                this.sleepTime = this.pollingTime * 1000 * 60;
            }
            catch (NumberFormatException nfe) {
                debug.warning("SMSJAXRCPObject::NotificationRunnable:run Number Format Exception for polling Time: " + this.pollingTime, (Throwable)nfe);
            }
            catch (SMSException smse) {
                this.sleepTime = WAIT_BEFORE_RETRY;
                if (smse.getExceptionCode() != SMSException.STATUS_REPEATEDLY_FAILED) {
                    debug.warning("SMSJAXRPCObject::NotificationRunnable:run SMSException", (Throwable)smse);
                }
            }
            catch (InterruptedException ie) {
                this.sleepTime = WAIT_BEFORE_RETRY;
                debug.warning("SMSJAXRPCObject::NotificationRunnable:run Interrupted Exception", (Throwable)ie);
            }
            catch (Exception re) {
                this.sleepTime = this.pollingTime * 1000 * 60;
                debug.warning("SMSJAXRPCObject::NotificationRunnable:run Exception", (Throwable)re);
            }
        }

        public long getRunPeriod() {
            return this.sleepTime;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

