/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ListDataStoreTypes
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String[] params = new String[]{};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_DATASTORE_TYPES", params);
        try {
            Map labelToName = this.getIDRepoTypesMap();
            if (labelToName != null && !labelToName.isEmpty()) {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-list-datastore-types-succeeded"));
                this.getOutputWriter().printlnMessage(FormatUtils.formatMap(this.getResourceString("datastore-list-datastore-types-desc"), this.getResourceString("datastore-list-datastore-types-type"), labelToName));
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-list-datastore-types-no-entries"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_DATASTORE_TYPES", params);
        }
        catch (SMSException e) {
            this.debugError("ListDataStores.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_DATASTORE_TYPES", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("ListDataStores.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_DATASTORE_TYPES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private Map getIDRepoTypesMap() throws SMSException, SSOException {
        ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", this.getAdminSSOToken());
        ResourceBundle rb = AMResBundleCacher.getBundle(schemaMgr.getI18NFileName(), this.getCommandManager().getLocale());
        ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
        Set names = orgSchema.getSubSchemaNames();
        HashMap<String, String> map = new HashMap<String, String>(names.size() * 2);
        for (String name : names) {
            ServiceSchema ss = orgSchema.getSubSchema(name);
            String i18nKey = ss.getI18NKey();
            if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
            map.put(rb.getString(i18nKey), name);
        }
        return map;
    }
}

