/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.server.AuthSPrincipal;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class SubjectUtils {
    private SubjectUtils() {
    }

    public static Subject createSuperAdminSubject() {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        return SubjectUtils.createSubject(adminToken);
    }

    public static Subject createSubject(SSOToken token) {
        try {
            HashSet<AuthSPrincipal> userPrincipals = new HashSet<AuthSPrincipal>(2);
            String uuid = token.getProperty("sun.am.UniversalIdentifier");
            userPrincipals.add(new AuthSPrincipal(uuid));
            HashSet<SSOToken> privateCred = new HashSet<SSOToken>();
            privateCred.add(token);
            return new Subject(false, userPrincipals, new HashSet(), privateCred);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("SubjectUtils.createSubject", (Throwable)((Object)ex));
            return null;
        }
    }

    public static SSOToken getSSOToken(Subject subject) {
        Set<Object> set = subject.getPrivateCredentials();
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (Object o : set) {
            if (!(o instanceof SSOToken)) continue;
            return (SSOToken)o;
        }
        return null;
    }

    public static String getPrincipalId(Subject subject) {
        Set<Principal> userPrincipals = subject.getPrincipals();
        return userPrincipals != null && !userPrincipals.isEmpty() ? userPrincipals.iterator().next().getName() : null;
    }
}

