/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotSubject
implements EntitlementSubject {
    private EntitlementSubject eSubject;
    private String pSubjectName;

    public NotSubject() {
    }

    public NotSubject(EntitlementSubject eSubject) {
        this.eSubject = eSubject;
    }

    public NotSubject(EntitlementSubject eSubject, String pSubjectName) {
        this.eSubject = eSubject;
        this.pSubjectName = pSubjectName;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            JSONObject memberSubject = jo.optJSONObject("memberESubject");
            if (memberSubject != null) {
                String className = memberSubject.getString("className");
                Class<?> cl = Class.forName(className);
                this.eSubject = (EntitlementSubject)cl.newInstance();
                this.eSubject.setState(memberSubject.getString("state"));
            }
            this.pSubjectName = jo.has("pSubjectName") ? jo.optString("pSubjectName") : null;
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("NotSubject.setState", (Throwable)e);
        }
        catch (InstantiationException e) {
            PrivilegeManager.debug.error("NotSubject.setState", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("NotSubject.setState", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PrivilegeManager.debug.error("NotSubject.setState", (Throwable)e);
        }
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public SubjectDecision evaluate(String realm, SubjectAttributesManager mgr, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        SubjectDecision d = this.eSubject.evaluate(realm, mgr, subject, resourceName, environment);
        return new SubjectDecision(!d.isSatisfied(), Collections.EMPTY_MAP);
    }

    public void setESubject(EntitlementSubject eSubject) {
        this.eSubject = eSubject;
    }

    public EntitlementSubject getESubject() {
        return this.eSubject;
    }

    public void setPSubjectName(String pSubjectName) {
        this.pSubjectName = pSubjectName;
    }

    public String getPSubjectName() {
        return this.pSubjectName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("pSubjectName", (Object)this.pSubjectName);
        JSONObject subjo = new JSONObject();
        subjo.put("className", (Object)this.eSubject.getClass().getName());
        subjo.put("state", (Object)this.eSubject.getState());
        jo.put("memberESubject", (Object)subjo);
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("NotSubject.toString()", (Throwable)e);
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        NotSubject object = (NotSubject)obj;
        if (this.eSubject == null ? object.getESubject() != null : !this.eSubject.equals(object.getESubject())) {
            return false;
        }
        if (this.pSubjectName == null ? object.getPSubjectName() != null : !this.pSubjectName.equals(object.getPSubjectName())) {
            return false;
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.eSubject != null) {
            code += this.eSubject.hashCode();
        }
        if (this.pSubjectName != null) {
            code += this.pSubjectName.hashCode();
        }
        return code;
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        set.add("all");
        map.put("identity:", set);
        return map;
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean isIdentity() {
        return this.eSubject != null ? this.eSubject.isIdentity() : false;
    }
}

