/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementCombiner;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementThreadPool;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.SequentialThreadPool;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.interfaces.IThreadPool;
import com.sun.identity.entitlement.util.NetworkMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrivilegeEvaluator {
    private String realm = "/";
    private Subject adminSubject;
    private Subject subject;
    private String applicationName;
    private String resourceName;
    private Map<String, Set<String>> envParameters;
    private ResourceSearchIndexes indexes;
    private List<List<Entitlement>> resultQ = new LinkedList<List<Entitlement>>();
    private Application application;
    private Set<String> actionNames;
    private EntitlementCombiner entitlementCombiner;
    private boolean recursive;
    private EntitlementException eException;
    private final Lock lock = new ReentrantLock();
    private Condition hasResults = this.lock.newCondition();
    private static int evalThreadSize = 10;
    private static int tasksPerThread = 5;
    private static IThreadPool threadPool;
    private static boolean isMultiThreaded;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_INIT;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_RES_INDEX;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_SUB_INDEX;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_SEARCH;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_SUBMIT;
    private static final NetworkMonitor PRIVILEGE_EVAL_MONITOR_WAIT;

    PrivilegeEvaluator() {
    }

    private void init(Subject adminSubject, Subject subject, String realm, String applicationName, String resourceName, Set<String> actions, Map<String, Set<String>> envParameters, boolean recursive) throws EntitlementException {
        long start = PRIVILEGE_EVAL_MONITOR_INIT.start();
        this.adminSubject = adminSubject;
        this.subject = subject;
        this.realm = realm;
        this.applicationName = applicationName;
        this.resourceName = resourceName;
        this.envParameters = envParameters;
        Application appl = this.getApplication();
        this.actionNames = new HashSet<String>();
        if (actions == null || actions.isEmpty()) {
            this.actionNames.addAll(appl.getActions().keySet());
        } else {
            this.actionNames.addAll(actions);
        }
        this.entitlementCombiner = appl.getEntitlementCombiner();
        this.entitlementCombiner.init(adminSubject, realm, applicationName, resourceName, this.actionNames, recursive);
        this.recursive = recursive;
        PRIVILEGE_EVAL_MONITOR_INIT.end(start);
    }

    public boolean hasEntitlement(String realm, Subject adminSubject, Subject subject, String applicationName, Entitlement entitlement, Map<String, Set<String>> envParameters) throws EntitlementException {
        this.init(adminSubject, subject, realm, applicationName, entitlement.getResourceName(), entitlement.getActionValues().keySet(), envParameters, false);
        long start = PRIVILEGE_EVAL_MONITOR_RES_INDEX.start();
        entitlement.setApplicationName(applicationName);
        this.indexes = entitlement.getResourceSearchIndexes(adminSubject, realm);
        PRIVILEGE_EVAL_MONITOR_RES_INDEX.end(start);
        List<Entitlement> results = this.evaluate(realm);
        Entitlement result = results.get(0);
        for (String action : entitlement.getActionValues().keySet()) {
            Boolean b = result.getActionValue(action);
            if (b != null && b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public List<Entitlement> evaluate(String realm, Subject adminSubject, Subject subject, String applicationName, String resourceName, Map<String, Set<String>> envParameters, boolean recursive) throws EntitlementException {
        this.init(adminSubject, subject, realm, applicationName, resourceName, null, envParameters, recursive);
        long start = PRIVILEGE_EVAL_MONITOR_RES_INDEX.start();
        this.indexes = this.getApplication().getResourceSearchIndex(resourceName);
        PRIVILEGE_EVAL_MONITOR_RES_INDEX.end(start);
        return this.evaluate(realm);
    }

    private List<Entitlement> evaluate(String realm) throws EntitlementException {
        boolean isDone;
        int totalCount;
        long start = PRIVILEGE_EVAL_MONITOR_SUB_INDEX.start();
        SubjectAttributesManager sam = SubjectAttributesManager.getInstance(this.adminSubject, realm);
        PRIVILEGE_EVAL_MONITOR_SUB_INDEX.end(start);
        start = PRIVILEGE_EVAL_MONITOR_SEARCH.start();
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(this.adminSubject, realm);
        Iterator<IPrivilege> i = pis.search(realm, this.indexes, sam.getSubjectSearchFilter(this.subject, this.applicationName), this.recursive);
        PRIVILEGE_EVAL_MONITOR_SEARCH.end(start);
        HashSet<IPrivilege> localPrivileges = new HashSet<IPrivilege>(2 * tasksPerThread);
        for (totalCount = 0; totalCount != tasksPerThread; ++totalCount) {
            start = PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT.start();
            if (i.hasNext()) {
                localPrivileges.add(i.next());
                PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT.end(start);
                continue;
            }
            PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT.end(start);
            break;
        }
        HashSet<IPrivilege> privileges = null;
        boolean tasksSubmitted = false;
        while (true) {
            start = PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT.start();
            if (!i.hasNext()) break;
            if (privileges == null) {
                privileges = new HashSet<IPrivilege>(2 * tasksPerThread);
                tasksSubmitted = true;
            }
            privileges.add(i.next());
            PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT.end(start);
            if (++totalCount % tasksPerThread != 0) continue;
            start = PRIVILEGE_EVAL_MONITOR_SUBMIT.start();
            threadPool.submit(new PrivilegeTask(this, privileges, isMultiThreaded));
            PRIVILEGE_EVAL_MONITOR_SUBMIT.end(start);
            privileges.clear();
        }
        if (privileges != null && !privileges.isEmpty()) {
            start = PRIVILEGE_EVAL_MONITOR_SUBMIT.start();
            threadPool.submit(new PrivilegeTask(this, privileges, isMultiThreaded));
            PRIVILEGE_EVAL_MONITOR_SUBMIT.end(start);
        }
        new PrivilegeTask(this, localPrivileges, tasksSubmitted).run();
        start = PRIVILEGE_EVAL_MONITOR_WAIT.start();
        if (tasksSubmitted) {
            if (isMultiThreaded) {
                this.receiveEvalResults(totalCount);
            } else {
                isDone = false;
                while (!this.resultQ.isEmpty() && !isDone) {
                    this.entitlementCombiner.add(this.resultQ.remove(0));
                    isDone = this.entitlementCombiner.isDone();
                }
            }
        } else if (this.eException == null) {
            isDone = false;
            while (!this.resultQ.isEmpty() && !isDone) {
                this.entitlementCombiner.add(this.resultQ.remove(0));
                isDone = this.entitlementCombiner.isDone();
            }
        }
        PRIVILEGE_EVAL_MONITOR_WAIT.end(start);
        if (this.eException != null) {
            throw this.eException;
        }
        List<Entitlement> ents = this.entitlementCombiner.getResults();
        return ents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveEvalResults(int totalCount) {
        int counter = 0;
        this.lock.lock();
        boolean isDone = this.eException != null;
        try {
            while (!isDone && counter < totalCount) {
                if (this.resultQ.isEmpty()) {
                    this.hasResults.await();
                }
                while (!this.resultQ.isEmpty() && !isDone) {
                    this.entitlementCombiner.add(this.resultQ.remove(0));
                    isDone = this.entitlementCombiner.isDone();
                    ++counter;
                }
            }
        }
        catch (InterruptedException ex) {
            PrivilegeManager.debug.error("PrivilegeEvaluator.evaluate", (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Application getApplication() throws EntitlementException {
        if (this.application == null) {
            this.application = ApplicationManager.getApplicationForEvaluation(this.realm, this.applicationName);
            if (this.application == null) {
                Object[] params = new String[]{this.realm};
                throw new EntitlementException(248, params);
            }
        }
        return this.application;
    }

    static {
        PRIVILEGE_EVAL_MONITOR_INIT = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorInit");
        PRIVILEGE_EVAL_MONITOR_RES_INDEX = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorResourceIndex");
        PRIVILEGE_EVAL_MONITOR_SUB_INDEX = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorSubjectIndex");
        PRIVILEGE_EVAL_MONITOR_SEARCH = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorSearch");
        PRIVILEGE_EVAL_MONITOR_SEARCH_NEXT = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorSearchNext");
        PRIVILEGE_EVAL_MONITOR_SUBMIT = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorSubmit");
        PRIVILEGE_EVAL_MONITOR_WAIT = NetworkMonitor.getInstance("PrivilegeEvaluatorMonitorCombineResults");
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(PrivilegeManager.superAdminSubject, "/");
        Set<String> setPolicyEvalThread = ec.getConfiguration("evalThreadSize");
        if (setPolicyEvalThread != null && !setPolicyEvalThread.isEmpty()) {
            try {
                evalThreadSize = Integer.parseInt(setPolicyEvalThread.iterator().next());
            }
            catch (NumberFormatException e) {
                PrivilegeManager.debug.error("PrivilegeEvaluator.<init>: get evaluation thread pool size", (Throwable)e);
            }
        }
        isMultiThreaded = evalThreadSize > 1;
        threadPool = isMultiThreaded ? new EntitlementThreadPool(evalThreadSize) : new SequentialThreadPool();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PrivilegeTask
    implements Runnable {
        final PrivilegeEvaluator parent;
        private Set<IPrivilege> privileges;
        private boolean isThreaded;

        PrivilegeTask(PrivilegeEvaluator parent, Set<IPrivilege> privileges, boolean isThreaded) {
            this.parent = parent;
            this.privileges = new HashSet<IPrivilege>(privileges.size() * 2);
            this.privileges.addAll(privileges);
            this.isThreaded = isThreaded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (IPrivilege eval : this.privileges) {
                    List<Entitlement> entitlements = eval.evaluate(this.parent.adminSubject, this.parent.realm, this.parent.subject, this.parent.applicationName, this.parent.resourceName, this.parent.actionNames, this.parent.envParameters, this.parent.recursive);
                    if (entitlements == null) continue;
                    if (this.isThreaded) {
                        try {
                            this.parent.lock.lock();
                            this.parent.resultQ.add(entitlements);
                            this.parent.hasResults.signal();
                            continue;
                        }
                        finally {
                            this.parent.lock.unlock();
                            continue;
                        }
                    }
                    this.parent.resultQ.add(entitlements);
                }
            }
            catch (EntitlementException ex) {
                if (this.isThreaded) {
                    try {
                        this.parent.lock.lock();
                        this.parent.eException = ex;
                        this.parent.hasResults.signal();
                    }
                    finally {
                        this.parent.lock.unlock();
                    }
                }
                this.parent.eException = ex;
            }
        }
    }
}

