/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.Template;

public class SearchTemplate
extends Template {
    private AttrSet m_attrSet = null;
    private String m_searchFilter = null;

    public SearchTemplate() {
    }

    public SearchTemplate(String name, AttrSet attrSet, String filter) {
        super(name);
        this.setAttributeSet(attrSet);
        this.setSearchFilter(filter);
    }

    public SearchTemplate(String name, String[] attributeNames, String filter) {
        super(name);
        this.setAttributeNames(attributeNames);
        this.setSearchFilter(filter);
    }

    public void setSearchFilter(String filter) {
        this.m_searchFilter = filter != null ? filter : "objectclass=*";
    }

    public String getSearchFilter() {
        return this.m_searchFilter;
    }

    public void setAttributeNames(String[] attributeNames) {
        if (attributeNames != null) {
            this.m_attrSet = new AttrSet();
            this.addAttributeNames(attributeNames);
        }
    }

    public void addAttributeName(String attributeName) {
        if (attributeName != null) {
            if (this.m_attrSet == null) {
                this.m_attrSet = new AttrSet();
            }
            this.m_attrSet.add(new Attr(attributeName));
        }
    }

    public void addAttributeNames(String[] attributeNames) {
        if (attributeNames != null) {
            for (int i = 0; i < attributeNames.length; ++i) {
                this.addAttributeName(attributeNames[i]);
            }
        }
    }

    public void removeAttributeName(String attributeName) {
        if (attributeName != null && this.m_attrSet != null) {
            this.m_attrSet.remove(attributeName);
        }
    }

    public void removeAttributeNames(String[] attributeNames) {
        if (attributeNames != null && this.m_attrSet != null) {
            for (int i = 0; i < attributeNames.length; ++i) {
                this.removeAttributeName(attributeNames[i]);
            }
        }
    }

    public String[] getAttributeNames() {
        return this.m_attrSet == null ? new String[]{} : this.m_attrSet.getAttributeNames();
    }

    AttrSet getAttributeSet() {
        return this.m_attrSet;
    }

    void setAttributeSet(AttrSet attrSet) {
        this.m_attrSet = attrSet;
    }

    public Object clone() {
        SearchTemplate t = (SearchTemplate)super.clone();
        if (this.m_attrSet != null) {
            t.setAttributeSet((AttrSet)this.m_attrSet.clone());
        }
        if (this.m_searchFilter != null) {
            t.setSearchFilter(this.m_searchFilter);
        }
        return t;
    }

    public String toString() {
        return "SearchTemplate: " + this.getName() + " { " + this.m_attrSet + " }";
    }
}

