/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import java.util.Map;
import java.util.Set;

public class DelegationPermission {
    String orgName;
    private String serviceName;
    private String serviceVersion;
    private String configType;
    private String subConfigName;
    private Set actions;
    private Map extensions;
    static final Debug debug = DelegationManager.debug;
    static String WILDCARD = "*";

    public DelegationPermission() {
    }

    public DelegationPermission(String orgName, String serviceName, String version, String configType, String subConfigName, Set actions, Map extensions) throws DelegationException {
        this.setOrganizationName(orgName);
        this.serviceName = serviceName;
        this.serviceVersion = version;
        this.configType = configType;
        this.subConfigName = subConfigName;
        this.actions = actions;
        this.extensions = extensions;
    }

    public String getOrganizationName() {
        return this.orgName;
    }

    public void setOrganizationName(String name) throws DelegationException {
        int index;
        if (name != null && (index = name.indexOf(WILDCARD)) != -1) {
            this.orgName = name;
            return;
        }
        this.orgName = DNMapper.orgNameToDN(name);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) throws DelegationException {
        this.serviceName = name;
    }

    public String getVersion() {
        return this.serviceVersion;
    }

    public void setVersion(String version) throws DelegationException {
        this.serviceVersion = version;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) throws DelegationException {
        this.configType = configType;
    }

    public String getSubConfigName() {
        return this.subConfigName;
    }

    public void setSubConfigName(String name) throws DelegationException {
        this.subConfigName = name;
    }

    public Set getActions() {
        return this.actions;
    }

    public void setActions(Set actions) throws DelegationException {
        this.actions = actions;
    }

    public Map getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map extensions) throws DelegationException {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("\nDelegationPermission Object:");
        sb.append("\norgName=");
        sb.append(this.orgName);
        sb.append("\nserviceName=");
        sb.append(this.serviceName);
        sb.append("\nserviceVersion=");
        sb.append(this.serviceVersion);
        sb.append("\nconfigType=");
        sb.append(this.configType);
        sb.append("\nsubConfigName=");
        sb.append(this.subConfigName);
        sb.append("\nactions=");
        sb.append(this.actions);
        sb.append("\nextensions=");
        sb.append(this.extensions);
        return sb.toString();
    }
}

