/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.workflow.WorkflowException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportSAML2MetaData {
    private ImportSAML2MetaData() {
    }

    public static String[] importData(String realm, String metadata, String extended) throws WorkflowException {
        String entityID = null;
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            EntityConfigElement configElt = null;
            if (extended != null) {
                List config;
                Object obj = SAML2MetaUtils.convertStringToJAXB((String)extended);
                EntityConfigElement entityConfigElement = configElt = obj instanceof EntityConfigElement ? (EntityConfigElement)obj : null;
                if (configElt != null && configElt.isHosted() && !(config = configElt.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig()).isEmpty()) {
                    BaseConfigType bConfig = (BaseConfigType)config.iterator().next();
                    realm = SAML2MetaUtils.getRealmByMetaAlias((String)bConfig.getMetaAlias());
                }
            }
            EntityDescriptorElement descriptor = null;
            if (metadata != null && (descriptor = ImportSAML2MetaData.getEntityDescriptorElement(metadata)) != null) {
                entityID = descriptor.getEntityID();
            }
            metaManager.createEntity(realm, descriptor, configElt);
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
        catch (JAXBException e) {
            throw new WorkflowException(e.getMessage());
        }
        String[] results = new String[]{realm, entityID};
        return results;
    }

    static EntityDescriptorElement getEntityDescriptorElement(String metadata) throws SAML2MetaException, JAXBException, WorkflowException {
        Debug debug = Debug.getInstance((String)"workflow");
        Document doc = XMLUtils.toDOMDocument((String)metadata, (Debug)debug);
        if (doc == null) {
            throw new WorkflowException("import-entity-exception-invalid-descriptor", null);
        }
        Element docElem = doc.getDocumentElement();
        if (!"EntityDescriptor".equals(docElem.getLocalName()) || !"urn:oasis:names:tc:SAML:2.0:metadata".equals(docElem.getNamespaceURI())) {
            throw new WorkflowException("import-entity-exception-invalid-descriptor", null);
        }
        SAML2MetaSecurityUtils.verifySignature((Document)doc);
        ImportSAML2MetaData.workaroundAbstractRoleDescriptor(doc);
        Object obj = SAML2MetaUtils.convertNodeToJAXB((Node)doc);
        return obj instanceof EntityDescriptorElement ? (EntityDescriptorElement)obj : null;
    }

    private static void workaroundAbstractRoleDescriptor(Document doc) {
        Debug debug = Debug.getInstance((String)"workflow");
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
        int length = nl.getLength();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Element child = (Element)nl.item(i);
            String type = child.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type == null || !type.equals("AttributeQueryDescriptorType") && !type.endsWith(":AttributeQueryDescriptorType")) continue;
            String newTag = type.substring(0, type.length() - 4);
            String xmlstr = XMLUtils.print((Node)child);
            int index = xmlstr.indexOf("RoleDescriptor");
            xmlstr = "<" + newTag + xmlstr.substring(index + "RoleDescriptor".length());
            if (!xmlstr.endsWith("/>")) {
                index = xmlstr.lastIndexOf("</");
                xmlstr = xmlstr.substring(0, index) + "</" + newTag + ">";
            }
            Document tmpDoc = XMLUtils.toDOMDocument((String)xmlstr, (Debug)debug);
            Node newChild = doc.importNode(tmpDoc.getDocumentElement(), true);
            child.getParentNode().replaceChild(newChild, child);
        }
    }
}

