/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginConfig;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstance;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceConfigManager {
    private SSOToken token;
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private ServiceConfigManagerImpl scm;

    public ServiceConfigManager(String serviceName, SSOToken token) throws SMSException, SSOException {
        this(token, serviceName, ServiceManager.isCoexistenceMode() ? ServiceManager.serviceDefaultVersion(token, serviceName) : ServiceManager.getVersion(serviceName));
    }

    public ServiceConfigManager(SSOToken token, String serviceName, String version) throws SMSException, SSOException {
        if (token == null || serviceName == null || version == null) {
            throw new IllegalArgumentException(SMSEntry.bundle.getString("sms-INVALID_PARAMETERS"));
        }
        SSOTokenManager.getInstance().validateToken(token);
        this.token = token;
        this.serviceName = serviceName;
        this.version = version;
        this.validateSCM();
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public Set getInstanceNames() throws SMSException {
        try {
            this.validateSCM();
            return this.scm.getInstanceNames(this.token);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Instance Names", (Throwable)((Object)s));
            return Collections.EMPTY_SET;
        }
    }

    public Set getGroupNames() throws SMSException {
        try {
            this.validateSCM();
            return this.scm.getGroupNames(this.token);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Group Names", (Throwable)((Object)s));
            return Collections.EMPTY_SET;
        }
    }

    public ServiceInstance getInstance(String instanceName) throws SMSException, SSOException {
        this.validateSCM();
        return new ServiceInstance(this, this.scm.getInstance(this.token, instanceName));
    }

    public void removeInstance(String instanceName) throws SMSException, SSOException {
        this.getInstance(instanceName).delete();
    }

    public ServiceConfig getGlobalConfig(String instanceName) throws SMSException, SSOException {
        this.validateSCM();
        ServiceConfigImpl sci = this.scm.getGlobalConfig(this.token, instanceName);
        return sci == null ? null : new ServiceConfig(this, sci);
    }

    public ServiceConfig getOrganizationConfig(String orgName, String instanceName) throws SMSException, SSOException {
        this.validateSCM();
        ServiceConfigImpl sci = this.scm.getOrganizationConfig(this.token, orgName, instanceName);
        return sci == null ? null : new ServiceConfig(this, sci);
    }

    public ServiceConfig createGlobalConfig(Map attrs) throws SMSException, SSOException {
        this.validateSSM();
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.GLOBAL);
        if (ss == null) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-global-schema", args);
        }
        String orgDN = this.scm.constructServiceConfigDN("default", "ou=GlobalConfig,", null);
        try {
            CreateServiceConfig.createSubConfigEntry(this.token, orgDN, ss, null, null, attrs, SMSEntry.baseDN);
        }
        catch (ServiceAlreadyExistsException slee) {
            // empty catch block
        }
        return this.getGlobalConfig(null);
    }

    public ServiceConfig createOrganizationConfig(String orgName, Map attrs) throws SMSException, SSOException {
        this.validateSSM();
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (ss == null) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-org-schema", args);
        }
        String orgdn = DNMapper.orgNameToDN(orgName);
        CreateServiceConfig.checkBaseNodesForOrg(this.token, orgdn, this.serviceName, this.version);
        String orgDN = this.scm.constructServiceConfigDN("default", "ou=OrganizationConfig,", orgdn);
        try {
            CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, orgDN);
            if (cEntry.isDirty()) {
                cEntry.refresh();
            }
            if (cEntry.isNewEntry()) {
                CreateServiceConfig.createSubConfigEntry(this.token, orgDN, ss, null, null, attrs, orgName);
                if (ServiceManager.isCoexistenceMode()) {
                    String smsDN = DNMapper.orgNameToDN(orgName);
                    OrgConfigViaAMSDK amsdk = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(smsDN), smsDN);
                    amsdk.assignService(this.serviceName);
                }
            } else if (attrs != null && !attrs.isEmpty()) {
                ServiceConfig sc = this.getOrganizationConfig(orgName, null);
                sc.setAttributes(attrs);
            }
        }
        catch (ServiceAlreadyExistsException slee) {
            // empty catch block
        }
        return this.getOrganizationConfig(orgName, null);
    }

    public void addConfiguration(InputStream in) throws SMSException, SSOException {
        ServiceManager sm = new ServiceManager(this.token);
        Document doc = SMSSchema.getXMLDocument(in);
        NodeList nodes = doc.getElementsByTagName("Service");
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node configNode;
            Node serviceNode = nodes.item(i);
            String sName = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"name");
            String sVersion = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"version");
            if (!sName.equals(this.serviceName) || !sVersion.equals(this.version) || (configNode = XMLUtils.getChildNode((Node)serviceNode, (String)"Configuration")) == null) continue;
            CreateServiceConfig.createService(sm, sName, sVersion, configNode, null);
        }
    }

    public void removeGlobalConfiguration(String groupName) throws SMSException, SSOException {
        if (this.serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || this.serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        if (groupName == null || groupName.length() == 0) {
            groupName = "default";
        }
        this.validateSCM();
        String gdn = this.scm.constructServiceConfigDN(groupName, "ou=GlobalConfig,", null);
        CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, gdn);
        if (cEntry.isDirty()) {
            cEntry.refresh();
        }
        SMSEntry entry = cEntry.getClonedSMSEntry();
        entry.delete(this.token);
        cEntry.refresh(entry);
    }

    public void deleteOrganizationConfig(String orgName) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(orgName, "default");
    }

    public void removeOrganizationConfiguration(String orgName, String groupName) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(orgName, groupName, true);
    }

    public void removeOrganizationConfiguration(String orgName, String groupName, boolean checkLegacyMode) throws SMSException, SSOException {
        if (groupName == null || groupName.length() == 0) {
            groupName = "default";
        }
        String orgdn = DNMapper.orgNameToDN(orgName);
        this.validateSCM();
        String odn = this.scm.constructServiceConfigDN(groupName, "ou=OrganizationConfig,", orgdn);
        CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, odn);
        if (cEntry.isNewEntry()) {
            return;
        }
        if (checkLegacyMode && ServiceManager.isCoexistenceMode() && groupName.equalsIgnoreCase("default")) {
            OrgConfigViaAMSDK amsdk = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(orgdn), orgdn);
            amsdk.unassignService(this.serviceName);
        }
        if (!cEntry.isNewEntry()) {
            SMSEntry entry = cEntry.getClonedSMSEntry();
            entry.delete(this.token);
            cEntry.refresh(entry);
        }
    }

    public Set getPluginConfigNames(String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou=").append(pluginSchemaName).append(",ou=").append(interfaceName).append(",").append("ou=PluginConfig,").append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",").append(DNMapper.orgNameToDN(orgName));
        CachedSMSEntry.getInstance(this.token, sb.toString());
        CachedSubEntries cse = CachedSubEntries.getInstance(this.token, sb.toString());
        return cse.getSubEntries(this.token);
    }

    public PluginConfig getPluginConfig(String name, String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        this.validateSCM();
        PluginConfigImpl pci = this.scm.getPluginConfig(this.token, name, pluginSchemaName, interfaceName, orgName);
        return new PluginConfig(name, this, pci);
    }

    public void removePluginConfig(String name, String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        PluginConfig pci = this.getPluginConfig(name, pluginSchemaName, interfaceName, orgName);
        if (pci != null) {
            pci.delete();
        }
    }

    public String addListener(ServiceListener listener) {
        try {
            this.validateSCM();
            return this.scm.addListener(this.token, listener);
        }
        catch (Exception e) {
            SMSEntry.debug.error("ServiceConfigManager:addListener exception Service Name: " + this.serviceName, (Throwable)e);
            return null;
        }
    }

    public void removeListener(String listenerID) {
        if (this.scm != null) {
            this.scm.removeListener(listenerID);
        }
    }

    private void validateSCM() throws SSOException, SMSException {
        if (this.scm == null || !this.scm.isValid()) {
            this.scm = ServiceConfigManagerImpl.getInstance(this.token, this.serviceName, this.version);
        }
    }

    private void validateSSM() throws SSOException, SMSException {
        if (this.ssm == null || !this.ssm.isValid()) {
            this.validateSCM();
            this.ssm = this.scm.getServiceSchemaManagerImpl(this.token);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        hash = 29 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceConfigManager) {
            ServiceConfigManager oscm = (ServiceConfigManager)o;
            if (this.serviceName.equals(oscm.serviceName) && this.version.equals(oscm.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nService Config Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        try {
            for (String instanceName : this.getInstanceNames()) {
                sb.append(this.getInstance(instanceName));
                ServiceConfig config = null;
                try {
                    config = this.getGlobalConfig(instanceName);
                    if (config != null) {
                        sb.append("\nGlobal Configuation:\n").append(config);
                    }
                }
                catch (SMSException e) {
                    // empty catch block
                }
                try {
                    config = this.getOrganizationConfig(null, instanceName);
                    if (config == null) continue;
                    sb.append("Org Configuation:\n").append(config);
                }
                catch (SMSException e) {}
            }
            sb.append("\n");
        }
        catch (SMSException smse) {
            sb.append(smse.getMessage());
        }
        catch (SSOException ssoe) {
            sb.append(ssoe.getMessage());
        }
        return sb.toString();
    }

    public String toXML(AMEncryption encryptObj) throws SMSException, SSOException {
        StringBuffer buff = new StringBuffer();
        buff.append("<Configuration>");
        Set instances = this.getInstanceNames();
        for (String instanceName : instances) {
            ServiceInstance instance = this.getInstance(instanceName);
            buff.append(instance.toXML());
        }
        instances.add("default");
        for (String instanceName : instances) {
            try {
                ServiceConfig sc = this.getGlobalConfig(instanceName);
                if (sc == null) continue;
                buff.append(sc.toXML("GlobalConfiguration", encryptObj));
            }
            catch (SMSException e) {}
        }
        OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.token, "/");
        HashSet<String> orgNames = new HashSet<String>();
        Set oNames = orgMgr.getSubOrganizationNames("*", true);
        for (String name : oNames) {
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            orgNames.add(name);
        }
        orgNames.add("/");
        orgNames.add("/sunamhiddenrealmdelegationservicepermissions");
        for (String orgName : orgNames) {
            for (String instanceName : instances) {
                try {
                    ServiceConfig sc = this.getOrganizationConfig(orgName, instanceName);
                    if (sc == null) continue;
                    buff.append(sc.toXML("OrganizationConfiguration", encryptObj, orgName));
                }
                catch (SMSException e) {}
            }
        }
        buff.append("</Configuration>");
        return buff.toString();
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    boolean containsGroup(String groupName) throws SMSException, SSOException {
        return this.scm.containsGroup(this.token, groupName);
    }
}

