/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.assertion.SubjectLocality;
import com.sun.identity.saml2.assertion.impl.AssertionImpl;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class SAML2AssertionValidator {
    private Map attributeMap = null;
    private String subjectName = null;
    private Map config = null;
    private static final String TRUSTED_ISSUERS = "trustedIssuers";
    private static final String TRUSTED_IP_ADDRESSES = "trustedIPAddresses";
    private X509Certificate cert = null;

    public SAML2AssertionValidator(Element assertionE, Map config) throws SecurityException {
        this.config = config;
        if (config == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullConfig"));
        }
        try {
            List attributeStatements;
            List authnStatements;
            AssertionImpl samlAssertion = new AssertionImpl(assertionE);
            if (!samlAssertion.isSigned()) {
                throw new SecurityException(WSSUtils.bundle.getString("assertionNotSigned"));
            }
            Issuer issuer = samlAssertion.getIssuer();
            String issuerID = issuer.getValue();
            if (issuerID == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullIssuer"));
            }
            Set trustedIssuers = (Set)config.get(TRUSTED_ISSUERS);
            if (trustedIssuers != null && !trustedIssuers.contains(issuerID)) {
                throw new SecurityException(WSSUtils.bundle.getString("issuerNotTrusted"));
            }
            if (!samlAssertion.isTimeValid()) {
                throw new SecurityException(WSSUtils.bundle.getString("assertionTimeNotValid"));
            }
            Subject subject = samlAssertion.getSubject();
            if (subject == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullSubject"));
            }
            this.subjectName = subject.getNameID().getValue();
            if (this.subjectName == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullSubject"));
            }
            Element keyInfo = this.getKeyInfo(subject);
            if (keyInfo != null) {
                this.cert = WSSUtils.getCertificate(keyInfo);
            }
            if ((authnStatements = samlAssertion.getAuthnStatements()) != null && !authnStatements.isEmpty()) {
                this.validateAuthnStatement((AuthnStatement)authnStatements.get(0));
            }
            if ((attributeStatements = samlAssertion.getAttributeStatements()) != null && !attributeStatements.isEmpty()) {
                this.validateAttributeStatement((AttributeStatement)attributeStatements.get(0));
            }
        }
        catch (SAML2Exception se) {
            throw new SecurityException(se.getMessage());
        }
    }

    private void validateAuthnStatement(AuthnStatement authnStatement) throws SecurityException {
        SubjectLocality subjectLocality = authnStatement.getSubjectLocality();
        AuthnContext authnContext = authnStatement.getAuthnContext();
        if (authnContext != null) {
            String authnContextRef = authnContext.getAuthnContextClassRef();
        }
    }

    private void validateAttributeStatement(AttributeStatement attributeStatement) throws SecurityException {
        List attributes = attributeStatement.getAttribute();
        if (!attributes.isEmpty()) {
            this.attributeMap = new HashMap();
        }
        for (Attribute attribute : attributes) {
            String value;
            Element attrElement;
            String attrValue;
            String attrName = attribute.getName();
            List values = attribute.getAttributeValue();
            if (values == null || values.isEmpty() || (attrValue = XMLUtils.getElementValue((Element)(attrElement = XMLUtils.toDOMDocument((String)(value = (String)values.get(0)), (Debug)WSSUtils.debug).getDocumentElement()))) == null || attrValue.length() == 0) continue;
            this.attributeMap.put(attrName, value);
        }
    }

    public Map getAttributes() {
        return this.attributeMap;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getKeyInfoCert() {
        return this.cert;
    }

    private Element getKeyInfo(Subject subject) {
        List list = subject.getSubjectConfirmation();
        if (list == null || list.isEmpty()) {
            return null;
        }
        SubjectConfirmation subjConfirmation = (SubjectConfirmation)list.get(0);
        SubjectConfirmationData confirmationData = subjConfirmation.getSubjectConfirmationData();
        if (confirmationData == null) {
            return null;
        }
        List content = confirmationData.getContent();
        if (content == null || content.isEmpty()) {
            return null;
        }
        return (Element)content.get(0);
    }
}

