/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc.client;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CDCClientServlet
extends HttpServlet {
    private static final ArrayList adviceParams = new ArrayList();
    private static HashSet invalidSet = new HashSet();
    private static final String LEFT_ANGLE = "<";
    private static final String RIGHT_ANGLE = ">";
    private static final String URLENC_RIGHT_ANGLE = "%3e";
    private static final String URLENC_LEFT_ANGLE = "%3c";
    private static final String URLENC_JAVASCRIPT = "javascript%3a";
    private static final String JAVASCRIPT = "javascript:";
    private static final String DELIM = ",";
    private static final String DEBUG_FILE_NAME = "amCDC";
    static Debug debug = Debug.getInstance((String)"amCDC");
    private static SSOTokenManager tokenManager;
    private static String sessionServiceName;
    private static String authURLCookieName;
    private static String authURLCookieDomain;
    private static String deployDescriptor;
    private String policyAdviceList;
    private String requestParams;
    boolean serverMode = Boolean.valueOf(System.getProperty("com.iplanet.am.serverMode", SystemProperties.get((String)"com.iplanet.am.serverMode", (String)"false")));
    private static final char QUESTION_MARK = '?';
    private static final char AMPERSAND = '&';
    private static final char EQUAL_TO = '=';
    private static final String GOTO_PARAMETER = "goto";
    private static final String TARGET_PARAMETER = "TARGET";
    private static final String CDCURI = "/cdcservlet";
    private static final String AUTHURI = "/UI/Login";
    private static String redirectURLStr;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (debug.messageEnabled()) {
            debug.message("CDCClientServlet.init:CDCClientServlet Initializing...");
        }
        try {
            tokenManager = SSOTokenManager.getInstance();
        }
        catch (SSOException ssoe) {
            debug.error("CDCClientServlet.init:unable to get SSOTokenManager", (Throwable)ssoe);
        }
        authURLCookieName = SystemProperties.get((String)"com.sun.identity.authentication.uniqueCookieName", (String)"sunIdentityServerAuthNServer");
        authURLCookieDomain = SystemProperties.get((String)"com.sun.identity.authentication.uniqueCookieDomain", (String)"");
        deployDescriptor = SystemProperties.get((String)"com.iplanet.am.distauth.deploymentDescriptor", (String)"/distauth");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SSOToken token;
        if (debug.messageEnabled()) {
            debug.message("CDCClientServlet.doGetPost:Query String received= " + request.getQueryString());
        }
        String gotoParameter = request.getParameter(GOTO_PARAMETER);
        String targetParameter = request.getParameter(TARGET_PARAMETER);
        if (targetParameter == null) {
            targetParameter = request.getParameter(TARGET_PARAMETER.toLowerCase());
        }
        if (gotoParameter != null || targetParameter != null) {
            debug.message("CDCServlet:doGetPost():goto or target is not null");
            for (String invalidStr : invalidSet) {
                if (gotoParameter != null && gotoParameter.toLowerCase().indexOf(invalidStr) != -1) {
                    this.showError(response, "GOTO parameter has invalid characters");
                    return;
                }
                if (targetParameter == null || targetParameter.toLowerCase().indexOf(invalidStr) == -1) continue;
                this.showError(response, "TARGET parameter has invalid characters");
                return;
            }
        }
        if ((token = this.getSSOToken(request, response)) == null) {
            this.policyAdviceList = null;
        }
        this.parseRequestParams(request);
        if (token == null || this.policyAdviceList != null) {
            this.redirectForAuthentication(request, response);
        } else {
            this.sendAuthnRequest(request, response, token);
        }
    }

    private void sendAuthnRequest(HttpServletRequest request, HttpServletResponse response, SSOToken token) throws ServletException, IOException {
        SessionID sessid = new SessionID(request);
        URL CDCServletURL = null;
        URL sessionServiceURL = null;
        try {
            sessionServiceURL = Session.getSessionServiceURL((SessionID)sessid);
        }
        catch (SessionException se) {
            debug.error("CDCClientServlet.sendAuthnRequest: Cannot locate OpenSSO instance to forward to.", (Throwable)se);
            this.showError(response, "Cannot locate OpenSSO instance to forward to");
        }
        if (sessionServiceURL == null) {
            this.showError(response, "Cannot locate OpenSSO instance to forward to");
        }
        String sessionServiceURLString = sessionServiceURL.toString();
        int serviceNameIndex = sessionServiceURLString.lastIndexOf("/", sessionServiceURLString.length() - 2);
        StringBuffer buffer = new StringBuffer(150);
        buffer.append(sessionServiceURLString.substring(0, serviceNameIndex)).append(CDCURI).append('?').append(request.getQueryString());
        CDCServletURL = new URL(buffer.toString());
        try {
            HttpURLConnection connection = (HttpURLConnection)CDCServletURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            String strCookies = this.getCookiesFromRequest(request);
            if (strCookies != null) {
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet.sendAuthnRequest:Setting cookies = " + strCookies);
                }
                connection.setRequestProperty("Cookie", strCookies);
            }
            HttpURLConnection.setFollowRedirects(false);
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.sendAuthnRequest:Getting response back from  " + CDCServletURL);
                debug.message("CDCClientServlet.sendAuthnRequest:Response Code " + connection.getResponseCode());
                debug.message("CDCClientServlet.sendAuthnRequest:Response Message= " + connection.getResponseMessage());
            }
            if (connection.getResponseCode() == 200 || connection.getResponseCode() == 302) {
                int len;
                StringBuffer inBuf = new StringBuffer();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                char[] buf = new char[1024];
                while ((len = in.read(buf, 0, buf.length)) != -1) {
                    inBuf.append(buf, 0, len);
                }
                String inString = inBuf.toString();
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet.sendAuthnRequest:Received response data = " + inString);
                }
                this.sendAuthnResponse(request, response, inString);
            } else {
                debug.error("CDCClientServlet.sendAuthnRequest: Response code NOT OK/MOVED_TEMP ");
                this.showError(response, "ERROR: Received HTTP error code " + connection.getResponseCode() + " from " + CDCServletURL);
            }
        }
        catch (ConnectException ce) {
            if (debug.warningEnabled()) {
                debug.warning("CDCClientServlet.sendAuthnRequest: Connection Exception to " + CDCServletURL, (Throwable)ce);
            }
            this.showError(response, "Could not connect to CDCServlet at " + CDCServletURL + ":" + ce.getMessage());
        }
    }

    private String getCookiesFromRequest(HttpServletRequest request) {
        Cookie[] cookies = CookieUtils.getCookieArrayFromReq((HttpServletRequest)request);
        StringBuffer cookieStr = null;
        String strCookies = null;
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                String cookieName = cookies[nCookie].getName();
                String cookieVal = cookies[nCookie].getValue();
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet.getCookiesFromRequest:Cookie name = " + cookieName);
                    debug.message("CDCClientServlet.getCookiesFromRequest:Cookie val= " + cookieVal);
                }
                if (cookieStr == null) {
                    cookieStr = new StringBuffer();
                } else {
                    cookieStr.append(";");
                }
                cookieStr.append(cookieName).append('=').append(cookieVal);
            }
        }
        if (cookieStr != null) {
            strCookies = cookieStr.toString();
        }
        return strCookies;
    }

    private void parseRequestParams(HttpServletRequest request) {
        StringBuffer adviceList = null;
        StringBuffer parameterString = new StringBuffer(100);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            int i;
            String[] values;
            String paramName = (String)e.nextElement();
            if (adviceParams.contains(paramName.toLowerCase())) {
                if (adviceList == null) {
                    adviceList = new StringBuffer();
                } else {
                    adviceList.append('&');
                }
                values = request.getParameterValues(paramName);
                for (i = 0; values != null && i < values.length; ++i) {
                    adviceList.append(paramName).append('=').append(values[i]);
                }
                continue;
            }
            if (paramName.equals(GOTO_PARAMETER)) continue;
            values = request.getParameterValues(paramName);
            for (i = 0; values != null && i < values.length; ++i) {
                parameterString.append('&').append(paramName).append('=').append(URLEncDec.encode((String)values[i]));
            }
        }
        if (debug.messageEnabled()) {
            debug.message("CDCClientServlet.parseRequestParams:Advice List is = " + adviceList);
            debug.message("CDCClientServlet.parseRequestParams:Parameter String is = " + parameterString.toString());
        }
        this.policyAdviceList = adviceList == null ? null : adviceList.toString();
        this.requestParams = parameterString.length() > 0 ? parameterString.deleteCharAt(0).toString() : parameterString.toString();
    }

    private void redirectForAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("CDCClientServlet.redirectForAuthentication: requestURL=" + request.getRequestURL());
        }
        StringBuffer redirectURL = new StringBuffer(100);
        StringBuffer gotoURL = new StringBuffer(100);
        String authURL = null;
        Cookie authCookie = CookieUtils.getCookieFromReq((HttpServletRequest)request, (String)authURLCookieName);
        if (authCookie != null) {
            authURL = CookieUtils.getCookieValue((Cookie)authCookie);
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.redirectForAuthentication: got an authenticated URL= " + authURL);
            }
        }
        try {
            if (authURL == null || authURL.length() == 0 || !authURL.toLowerCase().startsWith("http") || this.policyAdviceList != null) {
                String finalURL = request.getParameter(GOTO_PARAMETER);
                if (finalURL == null || finalURL.equals("")) {
                    finalURL = request.getParameter(TARGET_PARAMETER);
                }
                if (finalURL == null || finalURL.equals("")) {
                    this.showError(response, "GOTO or TARGET parameter is missing in the request");
                    return;
                }
                gotoURL.append(deployDescriptor).append(CDCURI).append('?').append(TARGET_PARAMETER).append('=').append(URLEncDec.encode((String)finalURL)).append('&').append(this.requestParams);
                String cdcurl = SystemProperties.get((String)"com.sun.identity.cdcservlet.loginurl");
                redirectURLStr = cdcurl != null && cdcurl.length() > 0 ? (cdcurl.indexOf("?") == -1 ? cdcurl + '?' : cdcurl + '&') : "/UI/Login?";
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet init redirect URL isset to= " + redirectURLStr);
                }
                redirectURL.append(redirectURLStr);
                if (this.policyAdviceList != null) {
                    redirectURL.append(this.policyAdviceList).append('&');
                }
                redirectURL.append(GOTO_PARAMETER).append('=').append(URLEncDec.encode((String)gotoURL.toString()));
                if (this.policyAdviceList != null) {
                    redirectURL.append('&').append(this.policyAdviceList);
                }
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet.redirectForAuthentication:redirectURL before dispatching is=" + redirectURL);
                }
                RequestDispatcher dispatcher = request.getRequestDispatcher(redirectURL.toString());
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                redirectURL.append(authURL).append(deployDescriptor).append(CDCURI).append('?').append(request.getQueryString());
                if (authCookie != null) {
                    authCookie.setValue("");
                    response.addCookie(authCookie);
                }
                response.sendRedirect(redirectURL.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.redirectForAuthentication:Forwarding for authentication to= " + redirectURL);
            }
        }
        catch (IOException ex) {
            debug.error("CDCClientServlet.redirectForAuthentication: Failed in forwarding to Authentication service. IOException", (Throwable)ex);
            this.showError(response, "Could for forward to authentication service:" + ex.getMessage());
        }
        catch (ServletException se) {
            debug.error("CDCClientServlet.redirectForAuthentication : Failed in forwarding to Authentication service. ServletException", (Throwable)se);
            this.showError(response, "Could for forward to authentication service:" + se.getMessage());
        }
        catch (IllegalStateException ie) {
            debug.error("CDCClientServlet.redirectForAuthentication : Failed in forwarding to Authentication service. Illegal state", (Throwable)ie);
            this.showError(response, "Could for forward to authentication service:" + ie.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showError(HttpServletResponse response, String msg) {
        ServletOutputStream out = null;
        if (msg == null || msg.equals("")) {
            msg = "ERROR: An application error has occured.";
        }
        try {
            out = response.getOutputStream();
            out.println(msg);
            out.flush();
        }
        catch (IOException e) {
            debug.error("CDCClientServlet.showError::Could not show error message to the user " + e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ignore) {}
        }
    }

    private SSOToken getSSOToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOToken token = null;
        try {
            token = tokenManager.createSSOToken(request);
            if (token == null || !tokenManager.isValidToken(token)) {
                if (debug.messageEnabled()) {
                    debug.message("CDCClientServlet.getSSOToken:SSOToken is either null or not valid: " + token + "\nRedirecting for authentication");
                }
                token = null;
            }
        }
        catch (SSOException e) {
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.getSSOToken:SSOException caught= " + (Object)((Object)e));
            }
            token = null;
        }
        return token;
    }

    private void sendAuthnResponse(HttpServletRequest request, HttpServletResponse response, String authnResponse) {
        if (debug.messageEnabled()) {
            debug.message("CDCClientServlet.sendAuthnResponse: Called");
        }
        try {
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.sendAuthnResponse: AuthnResponse= " + authnResponse);
            }
            response.setContentType("text/html");
            response.setHeader("Pragma", "no-cache");
            PrintWriter out = response.getWriter();
            out.println(authnResponse);
            out.close();
            if (debug.messageEnabled()) {
                debug.message("CDCClientServlet.sendAuthnResponse: AuthnResponse sent successfully");
            }
            return;
        }
        catch (IOException ioe) {
            debug.error("CDCServlet.sendAuthnResponse:" + ioe.getMessage());
            return;
        }
    }

    static {
        adviceParams.add("module");
        adviceParams.add("authlevel");
        adviceParams.add("role");
        adviceParams.add("service");
        adviceParams.add("user");
        adviceParams.add("realm");
        adviceParams.add("org");
        adviceParams.add("sunamcompositeadvice");
        String invalidStrings = SystemPropertiesManager.get((String)"com.iplanet.services.cdc.invalidGotoStrings");
        if (invalidSet.isEmpty()) {
            debug.message("CDCServlet:static block: creating invalidSet");
            if (invalidStrings == null) {
                debug.message("CDCServlet: invalidStrings is null");
                invalidSet.add(LEFT_ANGLE);
                invalidSet.add(RIGHT_ANGLE);
                invalidSet.add(URLENC_LEFT_ANGLE);
                invalidSet.add(URLENC_RIGHT_ANGLE);
                invalidSet.add(JAVASCRIPT);
                invalidSet.add(URLENC_JAVASCRIPT);
            } else {
                debug.message("CDCServlet: invalidStrings is NOT null");
                StringTokenizer st = new StringTokenizer(invalidStrings, DELIM);
                while (st.hasMoreTokens()) {
                    invalidSet.add(st.nextToken());
                }
            }
        }
        sessionServiceName = "iPlanetAMSessionService";
        redirectURLStr = "";
    }
}

