/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.spi;

import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.impl.FMSessionProvider;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.AssertionTokenSpec;
import com.sun.identity.wss.security.SAML11AssertionValidator;
import com.sun.identity.wss.security.SAML2AssertionValidator;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.SecurityTokenFactory;
import com.sun.identity.wss.security.UserNameTokenSpec;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSClientUserToken;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.sts.config.FAMSTSConfiguration;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.xml.ws.api.security.trust.STSTokenProvider;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSTokenProvider
implements STSTokenProvider {
    /*
     * Unable to fully structure code
     */
    public void generateToken(IssuedTokenContext ctx) throws WSTrustException {
        STSUtils.debug.message("FAMSTSTokenProvider.generateToken called.");
        issuer = ctx.getTokenIssuer();
        appliesTo = ctx.getAppliesTo();
        tokenType = ctx.getTokenType();
        if (tokenType != null && tokenType.equals("urn:sun:wss:ssotoken")) {
            this.generateSSOToken(ctx);
            return;
        }
        if (tokenType != null && (tokenType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText") || tokenType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest"))) {
            this.generateUserNameToken(ctx, tokenType);
            return;
        }
        keyType = ctx.getKeyType();
        tokenLifeSpan = ctx.getExpirationTime().getTime() - ctx.getCreationTime().getTime();
        confirMethod = (String)ctx.getOtherProperties().get("samlConfirmationMethod");
        if ("urn:oasis:names:tc:SAML:1.0:cm::sender-vouches".equals(confirMethod)) {
            confirMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        }
        claimedAttrs = (Map)ctx.getOtherProperties().get("cliamedAttributes");
        wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        eleFac = WSTrustElementFactory.newInstance((WSTrustVersion)wstVer);
        stsCert = (X509Certificate)ctx.getOtherProperties().get("stsCertificate");
        stsCertAlias = WSSUtils.getXMLSignatureManager().getKeyProvider().getCertificateAlias((Certificate)stsCert);
        keyInfo = this.createKeyInfo(ctx);
        assertionId = "uuid-" + UUID.randomUUID().toString();
        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("FAMSTSTokenProvider.tokenType : " + tokenType);
        }
        assertionE = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            authMethod = this.getAuthnMechanism(ctx);
            try {
                assertionE = this.createSAML11Assertion(wstVer, tokenLifeSpan, confirMethod, authMethod, issuer, appliesTo, keyInfo, claimedAttrs, keyType, assertionId, stsCertAlias);
                if (!LogUtil.isLogEnabled()) ** GOTO lbl52
                data = new String[]{assertionId, issuer, appliesTo, confirMethod, tokenType, keyType};
                LogUtil.access(Level.INFO, "CREATED_SAML11_ASSERTION", data, null);
            }
            catch (FAMSTSException fse) {
                STSUtils.debug.error("FAMSTSTokenProvider.generateToken: Could not generate SAML11 Assertion", (Throwable)fse);
                throw new WSTrustException(fse.getMessage());
            }
        } else if (tokenType == null || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            authnCtx = this.getAuthContextClassRef(ctx);
            try {
                assertionE = this.createSAML20Assertion(wstVer, tokenLifeSpan, confirMethod, assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType, authnCtx, stsCertAlias);
                if (!LogUtil.isLogEnabled()) ** GOTO lbl52
                data = new String[]{assertionId, issuer, appliesTo, confirMethod, tokenType, keyType};
                LogUtil.access(Level.INFO, "CREATED_SAML20_ASSERTION", data, null);
            }
            catch (FAMSTSException fse) {
                STSUtils.debug.error("FAMSTSTokenProvider.generateToken: Could not generate SAML2 Assertion", (Throwable)fse);
                throw new WSTrustException(fse.getMessage());
            }
        } else {
            STSUtils.debug.error("FAMSTSTokenProvider.generateToken ERROR : UNSUPPORTED_TOKEN_TYPE");
            data = new String[]{tokenType};
            LogUtil.error(Level.INFO, "UNSUPPORTED_TOKEN_TYPE", data, null);
            throw new WSTrustException(LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE((Object)tokenType, (Object)appliesTo));
        }
lbl52:
        // 4 sources

        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("FAMSTSTokenProvider.signedAssertion : " + XMLUtils.print((Node)assertionE));
        }
        ctx.setSecurityToken((Token)new GenericToken(assertionE));
        valueType = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
        }
        samlReference = WSTrustUtil.createSecurityTokenReference((String)assertionId, (String)valueType);
        raRef = eleFac.createRequestedAttachedReference(samlReference);
        ruRef = eleFac.createRequestedUnattachedReference(samlReference);
        ctx.setAttachedSecurityTokenReference((Token)samlReference);
        ctx.setUnAttachedSecurityTokenReference((Token)samlReference);
    }

    public void isValideToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void renewToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void invalidateToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Element createSAML11Assertion(WSTrustVersion wstVer, long lifeSpan, String confirMethod, String authMethod, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType, String assertionId, String stsKey) throws FAMSTSException {
        try {
            SecurityTokenFactory stFactory = SecurityTokenFactory.getInstance(WSSUtils.getAdminToken());
            String subjectName = this.getSubjectName(claimedAttrs);
            if (subjectName == null) {
                if (STSUtils.debug.warningEnabled()) {
                    STSUtils.debug.warning("FAMSTSTokenProvider.createSAML11Assertion: subject is null");
                }
                throw new FAMSTSException(STSUtils.bundle.getString("nullSubject"));
            }
            if (confirMethod == null) {
                confirMethod = keyType.equals(wstVer.getBearerKeyTypeURI()) ? "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches" : "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            }
            AssertionTokenSpec tokenSpec = new AssertionTokenSpec();
            NameIdentifier nameID = new NameIdentifier(subjectName);
            tokenSpec.setSenderIdentity(nameID);
            tokenSpec.setAppliesTo(appliesTo);
            tokenSpec.setAssertionInterval(lifeSpan);
            tokenSpec.setIssuer(issuer);
            tokenSpec.setConfirmationMethod(confirMethod);
            tokenSpec.setClaimedAttributes(claimedAttrs);
            X509Certificate cert = keyInfo.getX509Certificate();
            if (cert != null) {
                String clientCert = WSSUtils.getXMLSignatureManager().getKeyProvider().getCertificateAlias((Certificate)cert);
                tokenSpec.setSubjectCertAlias(clientCert);
            }
            tokenSpec.setAuthenticationMethod(authMethod);
            tokenSpec.setAssertionID(assertionId);
            tokenSpec.setSigningAlias(stsKey);
            AssertionToken token = (AssertionToken)stFactory.getSecurityToken(tokenSpec);
            return token.toDocumentElement();
        }
        catch (SecurityException se) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML11Assertion: failed in creating SAML11 Token", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
        catch (SAMLException sle) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML11Assertion: failed in creating SAML11 Token", (Throwable)sle);
            throw new FAMSTSException(sle.getMessage());
        }
        catch (KeyResolverException ke) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML11Assertion: failed in creating SAML11 Token", (Throwable)ke);
            throw new FAMSTSException(ke.getMessage());
        }
    }

    protected Element createSAML20Assertion(WSTrustVersion wstVer, long lifeSpan, String confirMethod, String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType, String authnCtx, String stsKey) throws FAMSTSException {
        try {
            SecurityTokenFactory stFactory = SecurityTokenFactory.getInstance(WSSUtils.getAdminToken());
            String subjectName = this.getSubjectName(claimedAttrs);
            if (subjectName == null) {
                if (STSUtils.debug.warningEnabled()) {
                    STSUtils.debug.warning("FAMSTSTokenProvider.createSAML2Assertion: subject is null");
                }
                throw new FAMSTSException(STSUtils.bundle.getString("nullSubject"));
            }
            if (confirMethod == null) {
                confirMethod = keyType.equals(wstVer.getBearerKeyTypeURI()) ? "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches" : "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            }
            SAML2TokenSpec tokenSpec = new SAML2TokenSpec();
            AssertionFactory assertionFactory = AssertionFactory.getInstance();
            NameID nameID = assertionFactory.createNameID();
            nameID.setValue(subjectName);
            nameID.setNameQualifier(issuer);
            tokenSpec.setAssertionID(assertionId);
            tokenSpec.setSenderIdentity(nameID);
            tokenSpec.setConfirmationMethod(confirMethod);
            X509Certificate cert = keyInfo.getX509Certificate();
            if (cert != null) {
                String clientCert = WSSUtils.getXMLSignatureManager().getKeyProvider().getCertificateAlias((Certificate)cert);
                tokenSpec.setSubjectCertAlias(clientCert);
            }
            tokenSpec.setAppliesTo(appliesTo);
            tokenSpec.setClaimedAttributes(claimedAttrs);
            tokenSpec.setAssertionInterval(lifeSpan);
            tokenSpec.setAuthnContextClassRef(authnCtx);
            tokenSpec.setIssuer(issuer);
            tokenSpec.setSigningAlias(stsKey);
            SAML2Token saml2Token = (SAML2Token)stFactory.getSecurityToken(tokenSpec);
            return saml2Token.toDocumentElement();
        }
        catch (SecurityException se) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML2Assertion:  failed in creating SAML20 Token", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
        catch (SAML2Exception s2e) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML2Assertion:  failed in creating SAML20 Token", (Throwable)s2e);
            throw new FAMSTSException(s2e.getMessage());
        }
        catch (KeyResolverException ke) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML2Assertion:  failed in creating SAML20 Token", (Throwable)ke);
            throw new FAMSTSException(ke.getMessage());
        }
    }

    private String getSubjectName(Map claimedAttrs) {
        Set entries = claimedAttrs.entrySet();
        for (Map.Entry entry : entries) {
            QName attrKey = (QName)entry.getKey();
            List values = (List)entry.getValue();
            if (values == null || values.size() <= 0 || !"NameID".equals(attrKey.getLocalPart())) continue;
            return (String)values.get(0);
        }
        return null;
    }

    private KeyInfo createKeyInfo(IssuedTokenContext ctx) throws WSTrustException {
        Element kiEle = (Element)ctx.getOtherProperties().get("ConfirmationKeyInfo");
        if (kiEle != null) {
            try {
                return new KeyInfo(kiEle, null);
            }
            catch (XMLSecurityException ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : UNABLE_GET_CLIENT_CERT : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), (Throwable)ex);
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = docFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : ERROR_CREATING_DOCFACTORY : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), (Throwable)ex);
        }
        String appliesTo = ctx.getAppliesTo();
        KeyInfo keyInfo = new KeyInfo(doc);
        String keyType = ctx.getKeyType();
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        if (wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            byte[] key = ctx.getProofKey();
            try {
                EncryptedKey encKey = WSTrustUtil.encryptKey((Document)doc, (byte[])key, (X509Certificate)((X509Certificate)ctx.getOtherProperties().get("tagetedServiceCertificate")), null);
                keyInfo.add(encKey);
            }
            catch (Exception ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : ERROR_ENCRYPT_PROOFKEY : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY((Object)appliesTo), (Throwable)ex);
            }
        }
        if (wstVer.getPublicKeyTypeURI().equals(keyType)) {
            X509Data x509data = new X509Data(doc);
            try {
                x509data.addCertificate(ctx.getRequestorCertificate());
            }
            catch (XMLSecurityException ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : UNABLE_GET_CLIENT_CERT : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), (Throwable)ex);
            }
            keyInfo.add(x509data);
        }
        return keyInfo;
    }

    private void generateSSOToken(IssuedTokenContext ctx) throws WSTrustException {
        Subject subject = ctx.getRequestorSubject();
        if (subject == null) {
            throw new WSTrustException(STSUtils.bundle.getString("nullSubject"));
        }
        String subjectName = null;
        Map attributeMap = null;
        HashMap<String, Set> config = new HashMap<String, Set>();
        FAMSTSConfiguration stsConfig = new FAMSTSConfiguration();
        config.put("trustedIssuers", stsConfig.getTrustedIssuers());
        config.put("trustedIPAddresses", stsConfig.getTrustedIPAddresses());
        for (Object object : subject.getPublicCredentials()) {
            Element famToken;
            if (!(object instanceof Element) || !(famToken = (Element)object).getLocalName().equals("FAMToken")) continue;
            Element assertionE = null;
            try {
                STSClientUserToken oboToken = new STSClientUserToken(famToken);
                String tokenID = oboToken.getTokenId();
                assertionE = XMLUtils.toDOMDocument((String)tokenID, (Debug)STSUtils.debug).getDocumentElement();
            }
            catch (FAMSTSException se) {
                throw new WSTrustException(se.getMessage());
            }
            if (assertionE == null) {
                throw new WSTrustException(STSUtils.bundle.getString("nullAssertion"));
            }
            if (!assertionE.getLocalName().equals("Assertion")) continue;
            String namespace = assertionE.getNamespaceURI();
            try {
                Object validator;
                if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace)) {
                    validator = new SAML11AssertionValidator(assertionE, config);
                    subjectName = ((SAML11AssertionValidator)validator).getSubjectName();
                    attributeMap = ((SAML11AssertionValidator)validator).getAttributes();
                    continue;
                }
                if (!"urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) continue;
                validator = new SAML2AssertionValidator(assertionE, config);
                subjectName = ((SAML2AssertionValidator)validator).getSubjectName();
                attributeMap = ((SAML2AssertionValidator)validator).getAttributes();
            }
            catch (SecurityException se) {
                throw new WSTrustException(se.getMessage());
            }
        }
        if (subjectName == null) {
            throw new WSTrustException(STSUtils.bundle.getString("assertion subject is null"));
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("realm", "/");
        info.put("principalName", subjectName);
        info.put("AuthLevel", "0");
        FMSessionProvider sessionProvider = new FMSessionProvider();
        try {
            SSOToken ssoToken = (SSOToken)sessionProvider.createSession(info, null, null, null);
            if (attributeMap != null && !attributeMap.isEmpty()) {
                for (String attrName : attributeMap.keySet()) {
                    String attrValue = (String)attributeMap.get(attrName);
                    ssoToken.setProperty(attrName, attrValue);
                }
            }
            STSClientUserToken wscToken = new STSClientUserToken();
            wscToken.init(ssoToken);
            ctx.setSecurityToken((Token)wscToken);
        }
        catch (SessionException se) {
            STSUtils.debug.error("FAMSTSTokenProvider.generateSSOToken: session exception ", (Throwable)se);
            throw new WSTrustException(se.getMessage());
        }
        catch (FAMSTSException fe) {
            STSUtils.debug.error("FAMSTSTokenProvider.generateSSOToken: FAMSTSException ", (Throwable)fe);
            throw new WSTrustException(fe.getMessage());
        }
        catch (SSOException ssoe) {
            STSUtils.debug.error("FAMSTSTokenProvider.generateSSOToken: SSOException ", (Throwable)ssoe);
            throw new WSTrustException(ssoe.getMessage());
        }
    }

    private void generateUserNameToken(IssuedTokenContext ctx, String tokenType) throws WSTrustException {
        Subject subject = ctx.getRequestorSubject();
        if (subject == null) {
            return;
        }
        for (Object object : subject.getPublicCredentials()) {
            Element credential;
            if (!(object instanceof Element) || !(credential = (Element)object).getLocalName().equals("FAMToken")) continue;
            try {
                STSClientUserToken userToken = new STSClientUserToken(credential);
                String tokenID = userToken.getTokenId();
                if (!userToken.getType().equals("urn:sun:wss:ssotoken")) continue;
                SSOToken ssoToken = SSOTokenManager.getInstance().createSSOToken(tokenID);
                String userid = ssoToken.getProperty("UserId");
                String password = null;
                boolean useHashedPassword = Boolean.valueOf(SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.security.useHashedPassword", (String)"true"));
                if (!useHashedPassword) {
                    String encryptedPassword = ssoToken.getProperty("EncryptedUserPassword");
                    if (encryptedPassword == null || encryptedPassword.length() == 0) {
                        throw new WSTrustException("noEncryptedPassword");
                    }
                    password = Crypt.decrypt((String)encryptedPassword);
                } else {
                    password = ssoToken.getProperty("HashedUserPassword");
                }
                if (password == null || password.length() == 0) {
                    throw new WSTrustException("noUserPassword");
                }
                UserNameTokenSpec tokenSpec = new UserNameTokenSpec();
                tokenSpec.setCreateTimeStamp(true);
                tokenSpec.setNonce(true);
                tokenSpec.setPassword(password);
                tokenSpec.setUserName(userid);
                tokenSpec.setPasswordType(tokenType);
                SecurityTokenFactory tokenFactory = SecurityTokenFactory.getInstance(WSSUtils.getAdminToken());
                SecurityToken securityToken = tokenFactory.getSecurityToken(tokenSpec);
                ctx.setSecurityToken((Token)new GenericToken(securityToken.toDocumentElement()));
            }
            catch (FAMSTSException fe) {
                STSUtils.debug.error("FAMSTSTokenProvider.generateUserNameToken: FAMSTSException ", (Throwable)fe);
                throw new WSTrustException(fe.getMessage());
            }
            catch (SSOException se) {
                STSUtils.debug.error("FAMSTSTokenProvider.generateUserNameToken: SSOException ", (Throwable)se);
                throw new WSTrustException(se.getMessage());
            }
            catch (SecurityException see) {
                STSUtils.debug.error("FAMSTSTokenProvider.generateUserNameToken: SSOException ", (Throwable)see);
                throw new WSTrustException(see.getMessage());
            }
        }
    }

    private String getAuthnMechanism(IssuedTokenContext ctx) {
        Subject subject = ctx.getRequestorSubject();
        if (subject == null) {
            return null;
        }
        Set<Object> creds = subject.getPublicCredentials();
        if (creds == null || creds.isEmpty()) {
            return null;
        }
        for (Object obj : creds) {
            if (!(obj instanceof Map)) continue;
            Map secureAttrs = (Map)obj;
            return (String)secureAttrs.get("AuthMethod");
        }
        return null;
    }

    private String getAuthContextClassRef(IssuedTokenContext ctx) {
        String authMech = this.getAuthnMechanism(ctx);
        if ("urn:sun:wss:security:null:KerberosToken".equals(authMech)) {
            return "urn:oasis:names:tc:SAML:2:0:ac:classes:Kerberos";
        }
        if ("urn:sun:wss:security:null:UserNameToken-Plain".equals(authMech)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
        }
        if ("urn:sun:wss:security:null:UserNameToken".equals(authMech)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
        }
        if ("urn:sun:wss:security:null:X509Token".equals(authMech)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:X509";
        }
        return "urn:oasis:names:tc:SAML:2.0:ac:classes:Software-PKI";
    }
}

