/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.sdk.ldap.EventManager;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntryEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(&(objectclass=*)(!(|(objectclass=sunService)(objectclass=sunServiceComponent)(aci=*))))";
    protected static final int OPERATIONS = 15;
    private Debug debug = EventManager.getDebug();
    private SSOToken internalToken;
    private Map listeners = new HashMap();

    public EntryEventListener() {
        try {
            this.internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        catch (Exception le) {
            this.debug.error("EntryEventListener() Exception occurred while getting SSOToken", (Throwable)le);
        }
    }

    private Set getDynamicAttributeNames(String serviceName) {
        Set attrNames;
        block4: {
            attrNames = Collections.EMPTY_SET;
            try {
                ServiceSchemaManager sm = new ServiceSchemaManager(serviceName, this.internalToken);
                ServiceSchema sschema = sm.getSchema(SchemaType.DYNAMIC);
                attrNames = sschema.getAttributeSchemaNames();
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("EntryEventListener.entryChanged(): caught SMSException: ", (Throwable)smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.error("EntryEventListener.entryChanged(): caught SSOException: ", (Throwable)((Object)ssoe));
            }
        }
        return attrNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryChanged(DSEvent dsEvent) {
        DN dn = new DN(dsEvent.getID());
        String normalizedDN = dn.toRFCString().toLowerCase();
        if (this.debug.messageEnabled()) {
            this.debug.message("EntryEventListener.entryChanged(): DSEvent generated for: " + dn);
        }
        boolean cosType = true;
        String affectDNs = "";
        Set attrNames = Collections.EMPTY_SET;
        String serviceName = null;
        String objClasses = dsEvent.getClassName();
        if (objClasses.indexOf("cosClassicDefinition") != -1) {
            affectDNs = dn.getParent().toRFCString().toLowerCase();
            serviceName = dn.explodeDN(true)[0];
            attrNames = this.getDynamicAttributeNames(serviceName);
            if (this.debug.messageEnabled()) {
                this.debug.message("EntryEventListener.entryChanged() Cos Definition changed for service: " + serviceName + "Dynamic Attributes: " + attrNames);
            }
        } else if (objClasses.indexOf("costemplate") != -1) {
            affectDNs = dn.getParent().getParent().toRFCString().toLowerCase();
            serviceName = dn.getParent().explodeDN(true)[0];
            attrNames = this.getDynamicAttributeNames(serviceName);
            if (this.debug.messageEnabled()) {
                this.debug.message("EntryEventListener.entryChanged()Cos template changed for service: " + serviceName + "Dynamic Attributes: " + attrNames);
            }
        } else {
            cosType = false;
            affectDNs = normalizedDN;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("EntryEventListener.entryChanged(): Affected dn: " + affectDNs + " cosType: " + cosType);
        }
        IDirectoryServices dsServices = DirectoryServicesFactory.getInstance();
        Map map = this.listeners;
        synchronized (map) {
            Set keys = this.listeners.keySet();
            for (AMObjectListener listener : keys) {
                Map configMap = (Map)this.listeners.get(listener);
                if (cosType) {
                    if (DirectoryServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)dsServices).dirtyCache(affectDNs, dsEvent.getEventType(), true, false, attrNames);
                        ((ICachedDirectoryServices)dsServices).dirtyCache(normalizedDN, dsEvent.getEventType(), false, false, Collections.EMPTY_SET);
                    }
                    listener.objectsChanged(affectDNs, dsEvent.getEventType(), attrNames, configMap);
                    listener.objectChanged(normalizedDN, dsEvent.getEventType(), configMap);
                    continue;
                }
                if (DirectoryServicesFactory.isCachingEnabled()) {
                    ((ICachedDirectoryServices)dsServices).dirtyCache(affectDNs, dsEvent.getEventType(), false, false, Collections.EMPTY_SET);
                }
                listener.objectChanged(affectDNs, dsEvent.getEventType(), configMap);
            }
        }
    }

    public void eventError(String errorStr) {
        this.debug.error("EntryEventListener.eventError(): " + errorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allEntriesChanged() {
        this.debug.error("EntryEventListener: Received all entries changed eventfrom event service");
        IDirectoryServices dsServices = DirectoryServicesFactory.getInstance();
        if (DirectoryServicesFactory.isCachingEnabled()) {
            ((ICachedDirectoryServices)dsServices).clearCache();
        }
        Map map = this.listeners;
        synchronized (map) {
            Set keys = this.listeners.keySet();
            for (AMObjectListener listener : keys) {
                listener.allObjectsChanged();
            }
        }
    }

    public String getBase() {
        return EventManager.EVENT_BASE_NODE;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map listener) {
        this.listeners = listener;
    }
}

