/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.util.ParseOutput;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLParser;
import java.util.Hashtable;
import java.util.Vector;

public class Server
implements ParseOutput {
    int serverPort;
    String serverName;
    String serverID;
    Type connType;
    boolean serverStatus = true;

    public int getPort() {
        return this.serverPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Type getConnectionType() {
        return this.connType;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void process(XMLParser parser, String name, Vector elems, Hashtable atts, String Pcdata) throws XMLException {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in Server.process()");
        }
        if (name.equals("Server")) {
            this.serverID = (String)atts.get("name");
            this.serverName = (String)atts.get("host");
            String connTypeStr = (String)atts.get("type");
            String serverPortStr = (String)atts.get("port");
            if (connTypeStr == null) {
                connTypeStr = "SIMPLE";
            }
            this.connType = connTypeStr.equalsIgnoreCase("SSL") ? Type.CONN_SSL : Type.CONN_SIMPLE;
            try {
                this.serverPort = Integer.parseInt(serverPortStr);
            }
            catch (NumberFormatException ex) {
                this.serverPort = 389;
            }
        } else {
            throw new XMLException(DSConfigMgr.getString("dscfg-dirserver_node_expected"));
        }
    }

    void setActiveStatus(boolean status) {
        this.serverStatus = status;
    }

    public boolean getActiveStatus() {
        return this.serverStatus;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Server Name=").append(this.serverName);
        str.append(" Server Port=").append(this.serverPort);
        str.append(" Status=").append(this.serverStatus);
        return new String(str);
    }

    public static class Type {
        int type = -1;
        public static final Type CONN_SIMPLE = new Type(0);
        public static final Type CONN_SSL = new Type(1);

        private Type(int type) {
            this.type = type;
        }

        public boolean equals(Type type) {
            return this.type == type.type;
        }

        public String toString() {
            if (this.equals(CONN_SIMPLE)) {
                return "SIMPLE";
            }
            if (this.equals(CONN_SSL)) {
                return "SSL";
            }
            return "SIMPLE";
        }
    }
}

