/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AssignService
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        String serviceName = this.getStringOptionValue("servicename");
        IdType idType = this.convert2IdType(type);
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String[] params = new String[]{realm, type, idName, serviceName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_ASSIGN_SERVICE", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            amid.assignService(serviceName, attributeValues);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-assign-service-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_ASSIGN_SERVICE", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("AssignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_ASSIGN_SERVICE", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("AssignService.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_ASSIGN_SERVICE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

