/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.console.realm.model.RMRealmModel;
import com.sun.identity.console.realm.model.RMRealmModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RealmPropertiesViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/RealmProperties.jsp";
    private AMPropertySheetModel psModel;
    private static final String PAGETITLE = "pgtitle";
    protected static final String REALM_PROPERTIES = "realmProperties";
    private boolean submitCycle;
    private boolean initialized;

    public RealmPropertiesViewBean() {
        super("RealmProperties");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("currentRealm")) != null) {
            this.initialized = true;
            this.createPropertyModel(realmName);
            this.createPageTitleModel();
            this.registerChildren();
            super.initialize();
        }
        super.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(REALM_PROPERTIES, AMPropertySheet.class);
        this.psModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(REALM_PROPERTIES) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.psModel, name) : (this.psModel != null && this.psModel.isChildSupported(name) ? this.psModel.createChild((View)this, name, this.getModel()) : (this.ptModel != null && this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        RMRealmModel model = (RMRealmModel)this.getModel();
        if (model != null) {
            if (!this.submitCycle) {
                String realm = (String)this.getPageSessionAttribute("currentRealm");
                AMPropertySheet ps = (AMPropertySheet)this.getChild(REALM_PROPERTIES);
                this.psModel.clear();
                try {
                    ps.setAttributeValues(model.getAttributeValues(realm), model);
                }
                catch (AMConsoleException a) {
                    this.setInlineAlertMessage("error", "message.error", "no.properties");
                }
            }
            this.setPageTitle(this.getModel(), "page.title.realms.properties");
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new RMRealmModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPropertyModel(String realmName) {
        RMRealmModel model = (RMRealmModel)this.getModel();
        try {
            this.psModel = new AMPropertySheetModel(model.getRealmProfilePropertyXML(realmName, ((Object)((Object)this)).getClass().getName()));
            this.psModel.clear();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        RMRealmModel model = (RMRealmModel)this.getModel();
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        AMPropertySheet ps = (AMPropertySheet)this.getChild(REALM_PROPERTIES);
        try {
            Map orig = model.getAttributeValues(realm);
            Map values = ps.getAttributeValues(orig, true, true, model);
            model.setAttributeValues(realm, values);
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }
}

