/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.database;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.plugins.database.DaoInterface;
import com.sun.identity.idm.plugins.database.RepoConfigHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SchemaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class DatabaseRepo
extends IdRepo {
    private static Debug debug = Debug.getInstance((String)"amIdRepoDatabase");
    private static final String PLUGIN_CLASS_NAME = "com.sun.identity.idm.plugins.database.DatabaseRepo";
    private static final String SUPPORTED_OPERATIONS_SCHEMA_NAME = "sun-opensso-database-sunIdRepoSupportedOperations";
    private static final String DAO_PLUGIN_CLASS_NAME_SCHEMA_NAME = "sun-opensso-database-dao-class-name";
    private static final String JDBC_CONNECTION_TYPE_SCHEMA_NAME = "sun-opensso-database-dao-JDBCConnectionType";
    private static final String DATASOURCE_SCHEMA_NAME = "sun-opensso-database-DataSourceJndiName";
    private static final String JDBC_DRIVER_SCHEMA_NAME = "sun-opensso-database-JDBCDriver";
    private static final String JDBC__DRIVER_URL_SCHEMA_NAME = "sun-opensso-database-JDBCUrl";
    private static final String JDBC_USER_NAME_SCHEMA_NAME = "sun-opensso-database-JDBCDbuser";
    private static final String JDBC__DRIVER_PASSWORD_SCHEMA_NAME = "sun-opensso-database-JDBCDbpassword";
    private static final String USER_DB_TABLE_NAME_SCHEMA_NAME = "sun-opensso-database-UserTableName";
    private static final String USER_PASSWORD_SCHEMA_NAME = "sun-opensso-database-UserPasswordAttr";
    private static final String USER_ID_SCHEMA_NAME = "sun-opensso-database-UserIDAttr";
    private static final String USER_STATUS_SCHEMA_NAME = "sun-opensso-database-UserStatusAttr";
    private static final String USER_STATUS_ACTIVE_VALUE_SCHEMA_NAME = "sun-opensso-database-activeValue";
    private static final String USER_STATUS_INACTIVE_VALUE_SCHEMA_NAME = "sun-opensso-database-inactiveValue";
    private static final String SEARCH_MAX_RESULT = "sun-opensso-database-config-max-result";
    private static final String USERS_SEARCH_ATTRIBUTE_SCHEMA_NAME = "sun-opensso-database-config-users-search-attribute";
    private static final String SET_OF_USER_ATTRIBUTES_SCHEMA_NAME = "sun-opensso-database-UserAttrs";
    private static final String MEMBERSHIP_TABLE_NAME_SCHEMA_NAME = "sun-opensso-database-MembershipTableName";
    private static final String MEMBERSHIP_ID_ATTRIBUTE_NAME_SCHEMA_NAME = "sun-opensso-database-MembershipIDAttr";
    private static final String MEMBERSHIP_SEARCH_ATTRIBUTE_NAME_SCHEMA_NAME = "sun-opensso-database-membership-search-attribute";
    private String daoClassName;
    private DaoInterface dao;
    private String userDataBaseTableName;
    private String passwordAttributeName;
    private String userIDAttributeName;
    private static Map supportedOps = new CaseInsensitiveHashMap();
    private Set<String> userAtttributesAllowed;
    private String statusAttributeName;
    private boolean alwaysActive = false;
    private static final String DEFAULT_USER_STATUS_ACTIVE_COMPARISON_VALUE = "Active";
    private static final String DEFAULT_USER_STATUS_INACTIVE_COMPARISON_VALUE = "Inactive";
    private String statusActiveComparisonValue = "Active";
    private String statusInActiveComparisonValue = "Inactive";
    private int defaultSearchMaxResults = 100;
    private String userSearchNamingAttr = null;
    private String membershipTableName = null;
    private String membershipIdAttributeName = null;
    private String membershipSearchAttributeName = null;
    IdRepoException initializationException;

    public DatabaseRepo() {
        if (debug == null) {
            debug = Debug.getInstance((String)"amIdRepoDatabase");
        }
        DatabaseRepo.loadDefaultSupportedOps();
    }

    public void initialize(Map configParams) {
        String errorMessage;
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.initialize called.");
        }
        super.initialize(configParams);
        RepoConfigHelper configHelper = new RepoConfigHelper(debug);
        this.daoClassName = configHelper.getPropertyStringValue(configParams, DAO_PLUGIN_CLASS_NAME_SCHEMA_NAME);
        try {
            if (this.daoClassName == null || this.daoClassName.trim().length() == 0) {
                String badDaoMsg = "DatabaseRepo.initialize: daoClassName obtained from IdRepoService.xml can not be null or empty. daoClassName=" + this.daoClassName;
                this.initializationException = new IdRepoException(badDaoMsg);
                debug.error(badDaoMsg);
                return;
            }
            this.dao = (DaoInterface)Class.forName(this.daoClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.initializationException = new IdRepoException(cnfe.getMessage());
            debug.error("DatabaseRepo.initialize: exception trying to create a new DAO class. Can not configure this datastore", (Throwable)cnfe);
            return;
        }
        catch (InstantiationException ie) {
            this.initializationException = new IdRepoException(ie.getMessage());
            debug.error("DatabaseRepo.initialize: exception trying to create a new DAO class. Can not configure this datastore", (Throwable)ie);
            return;
        }
        catch (IllegalAccessException iae) {
            this.initializationException = new IdRepoException(iae.getMessage());
            debug.error("DatabaseRepo.initialize: exception trying to create a new DAO class. Can not configure this datastore", (Throwable)iae);
            return;
        }
        catch (Exception noDAOex) {
            this.initializationException = new IdRepoException(noDAOex.getMessage());
            debug.error("DatabaseRepo.initialize: exception trying to create a new DAO class. Can not configure this datastore", (Throwable)noDAOex);
            return;
        }
        String connectionType = configHelper.getPropertyStringValue(configParams, JDBC_CONNECTION_TYPE_SCHEMA_NAME);
        boolean useJNDI = connectionType != null && connectionType.equals("JNDI");
        this.userDataBaseTableName = configHelper.getPropertyStringValue(configParams, USER_DB_TABLE_NAME_SCHEMA_NAME);
        if (this.userDataBaseTableName == null || this.userDataBaseTableName.trim().length() == 0) {
            errorMessage = "DatabaseRepo.initialize: validation failed on User DataBase Table Name config info, value must be non-null and not empty for userDataBaseTableName=" + this.userDataBaseTableName;
            if (debug.errorEnabled()) {
                debug.error(errorMessage);
            }
            this.initializationException = new IdRepoException(errorMessage);
        }
        this.membershipTableName = configHelper.getPropertyStringValue(configParams, MEMBERSHIP_TABLE_NAME_SCHEMA_NAME);
        this.membershipIdAttributeName = configHelper.getPropertyStringValue(configParams, MEMBERSHIP_ID_ATTRIBUTE_NAME_SCHEMA_NAME);
        this.membershipSearchAttributeName = configHelper.getPropertyStringValue(configParams, MEMBERSHIP_SEARCH_ATTRIBUTE_NAME_SCHEMA_NAME);
        if (this.membershipTableName == null || this.membershipIdAttributeName == null || this.membershipSearchAttributeName == null) {
            errorMessage = "DatabaseRepo.initialize: validation failed on membership config info, values must be non-null for membershipTableName=" + this.membershipTableName + " membershipIdAttributeName=" + this.membershipIdAttributeName + " membershipSearchAttributeName=" + this.membershipSearchAttributeName;
            if (debug.errorEnabled()) {
                debug.error(errorMessage);
            }
            this.initializationException = new IdRepoException(errorMessage);
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.initialize:  membershipTableName=" + this.membershipTableName + " membershipIdAttributeName=" + this.membershipIdAttributeName + " membershipSearchAttributeName=" + this.membershipSearchAttributeName);
        }
        if (useJNDI) {
            String datasourceName = configHelper.getPropertyStringValue(configParams, DATASOURCE_SCHEMA_NAME);
            if (datasourceName != null && datasourceName.length() != 0 && this.userDataBaseTableName != null && this.userDataBaseTableName.length() != 0) {
                if (debug.messageEnabled()) {
                    debug.message("DatabaseRepo.initialize, about to callDAO initialize, for useJNDI=" + useJNDI);
                }
                try {
                    this.dao.initialize(datasourceName, this.userDataBaseTableName, this.membershipTableName, debug);
                }
                catch (Exception ex) {
                    this.initializationException = new IdRepoException(ex.getMessage());
                    debug.error("DatabaseRepo.initialize: exception trying to set up DB datasource connection.", (Throwable)ex);
                }
            } else {
                String errorMessage2 = "DatabaseRepo.initialize: datasourceName and userDataBaseTableName must be not null and not empty. So initialize can not succeed. datasourceName=" + datasourceName + " userDataBaseTableName" + this.userDataBaseTableName;
                debug.error(errorMessage2);
                this.initializationException = new IdRepoException(errorMessage2);
            }
        } else {
            String jdbcDriver = configHelper.getPropertyStringValue(configParams, JDBC_DRIVER_SCHEMA_NAME);
            String jdbcDriverUrl = configHelper.getPropertyStringValue(configParams, JDBC__DRIVER_URL_SCHEMA_NAME);
            String jdbcDbUser = configHelper.getPropertyStringValue(configParams, JDBC_USER_NAME_SCHEMA_NAME);
            String jdbcDbPassword = configHelper.getPropertyStringValue(configParams, JDBC__DRIVER_PASSWORD_SCHEMA_NAME);
            if (jdbcDriver != null && jdbcDriver.length() != 0 && jdbcDriverUrl != null && jdbcDriverUrl.length() != 0 && jdbcDbUser != null && jdbcDbUser.length() != 0 && jdbcDbPassword != null && jdbcDbPassword.length() != 0 && this.userDataBaseTableName != null && this.userDataBaseTableName.length() != 0) {
                if (debug.messageEnabled()) {
                    debug.message("DatabaseRepo.initialize, about to callDAO initialize, for useJNDI=" + useJNDI);
                }
                try {
                    this.dao.initialize(jdbcDriver, jdbcDriverUrl, jdbcDbUser, jdbcDbPassword, this.userDataBaseTableName, this.membershipTableName, debug);
                }
                catch (Exception ex) {
                    this.initializationException = new IdRepoException(ex.getMessage());
                    debug.error("DatabaseRepo.initialize: exception trying to set up DB datasource connection.", (Throwable)ex);
                }
            } else {
                String errorMessage3 = "DatabaseRepo.initialize: using  useJNDI=" + useJNDI + " . The config parameters" + " jdbcDriver, jdbcDriverUrl, jdbcDbUser, jdbcDbPassword," + " and userDataBaseTableName must be not null and not" + " empty. So initialize can not succeed." + " jdbcDriver=" + jdbcDriver + " jdbcDriverUrl=" + jdbcDriverUrl + " jdbcDbUser=" + jdbcDbUser + " jdbcDbPassword=" + jdbcDbPassword + " userDataBaseTableName" + this.userDataBaseTableName;
                debug.error(errorMessage3);
                this.initializationException = new IdRepoException(errorMessage3);
            }
        }
        this.passwordAttributeName = configHelper.getPropertyStringValue(configParams, USER_PASSWORD_SCHEMA_NAME);
        this.userIDAttributeName = configHelper.getPropertyStringValue(configParams, USER_ID_SCHEMA_NAME);
        HashSet userSpecifiedOpsSet = null;
        userSpecifiedOpsSet = new HashSet((Set)configParams.get(SUPPORTED_OPERATIONS_SCHEMA_NAME));
        supportedOps = configHelper.parsedUserSpecifiedOps(userSpecifiedOpsSet);
        this.userAtttributesAllowed = new HashSet<String>((Set)configParams.get(SET_OF_USER_ATTRIBUTES_SCHEMA_NAME));
        this.statusAttributeName = configHelper.getPropertyStringValue(configParams, USER_STATUS_SCHEMA_NAME);
        if (this.statusAttributeName == null || this.statusAttributeName.length() == 0) {
            this.alwaysActive = true;
        }
        this.statusActiveComparisonValue = configHelper.getPropertyStringValue(configParams, USER_STATUS_ACTIVE_VALUE_SCHEMA_NAME, DEFAULT_USER_STATUS_ACTIVE_COMPARISON_VALUE);
        this.statusInActiveComparisonValue = configHelper.getPropertyStringValue(configParams, USER_STATUS_INACTIVE_VALUE_SCHEMA_NAME, DEFAULT_USER_STATUS_INACTIVE_COMPARISON_VALUE);
        this.defaultSearchMaxResults = configHelper.getPropertyIntValue(configParams, SEARCH_MAX_RESULT, this.defaultSearchMaxResults);
        this.userSearchNamingAttr = configHelper.getPropertyStringValue(configParams, USERS_SEARCH_ATTRIBUTE_SCHEMA_NAME);
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.initialize: \n\t Password Attr name: " + this.passwordAttributeName + "\n\t User ID Attr name: " + this.userIDAttributeName + "\n\t userAtttributesAllowed: " + this.userAtttributesAllowed + "\n\tStatus Attr name: " + this.statusAttributeName + "\n\t defaultSearchMaxResults:" + this.defaultSearchMaxResults + "\n\t userSearchNamingAttr:" + this.userSearchNamingAttr + "\n\tsupportedOps Map Attr: " + supportedOps);
        }
    }

    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        Set<String> nameVals;
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.create: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.create called with: token=" + token + " IdType=" + type + " name=" + name + "\n\tattrMap=" + attrMap);
        }
        if ((name == null || name.length() == 0) && debug.messageEnabled()) {
            debug.message("DatabaseRepo.create will not be executed since name is null or empty. name=" + name);
        }
        if (type.equals(IdType.GROUP)) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.createtype is GROUP, so will attempt to create group of name=" + name + "\n\tattrMap=" + attrMap);
            }
            this.dao.createGroup(name, this.membershipIdAttributeName);
            return name;
        }
        if (attrMap == null) {
            attrMap = new HashMap<String, Set<String>>();
        } else if (attrMap.isEmpty() || !attrMap.containsKey(this.userIDAttributeName)) {
            nameVals = new HashSet<String>();
            nameVals.add(name);
            attrMap.put(this.userIDAttributeName, nameVals);
        } else {
            nameVals = (Set)attrMap.get(this.userIDAttributeName);
            if (nameVals == null || nameVals.isEmpty()) {
                nameVals.add(name);
            }
        }
        this.isValidType(type, "create");
        String createdName = null;
        if (this.isExists(token, type, name)) {
            Object[] args = new String[]{name};
            throw new IdRepoException("amIdRepo", "310", args);
        }
        createdName = this.dao.createUser(this.userIDAttributeName, attrMap);
        if (createdName == null) {
            return "";
        }
        return createdName;
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.delete: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.delete called with parameters: token=" + token + " type=" + type + " name=" + name);
        }
        this.isValidType(type, "delete");
        if (name != null && name.length() != 0) {
            if (type.equals(IdType.USER)) {
                this.dao.deleteUser(name, this.userIDAttributeName);
            } else if (type.equals(IdType.GROUP)) {
                this.dao.deleteGroup(name, this.membershipIdAttributeName);
            }
        } else if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.delete: parameter name is null orempty so delete will not be executed. name=" + name);
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getAttributes called with:  token=" + token + " type=" + type + " name=" + name + "\n\treturn attributes=" + attrNames);
        }
        this.isValidType(type, "getAttributes");
        Map answer = attrNames == null ? null : new CaseInsensitiveHashMap();
        Map map = this.getAttributes(token, type, name);
        if (attrNames == null) {
            answer = map;
        } else {
            for (Object key : attrNames) {
                Object value = map.get(key);
                if (value == null) continue;
                answer.put(key, value);
            }
        }
        return answer;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getAttributes: get all attrs called:  token=" + token + " type=" + type.getName() + " name=" + name);
        }
        this.isValidType(type, "getAttributes");
        Map<String, Set<String>> users = Collections.EMPTY_MAP;
        if (type.equals(IdType.USER)) {
            users = this.dao.getAttributes(name, this.userIDAttributeName, this.userAtttributesAllowed);
        } else if (type.equals(IdType.GROUP)) {
            HashSet<String> groupAttrsAllowed = new HashSet<String>();
            groupAttrsAllowed.add(this.membershipIdAttributeName);
            users = this.dao.getGroupAttributes(name, this.membershipIdAttributeName, groupAttrsAllowed);
        }
        CaseInsensitiveHashMap answer = new CaseInsensitiveHashMap(users);
        return answer;
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.setAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.setAttributes called with: token=" + token + " type=" + type.getName() + " name=" + name + " isAdd=" + isAdd + "\n\tAttributes=" + attributes);
        }
        this.isValidType(type, "getAttributes");
        isAdd = false;
        if (name != null && name.length() != 0) {
            this.dao.updateUser(name, this.userIDAttributeName, attributes);
        } else if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.setAttributes: input parameter  name is null or empty so delete will not be executed. name=" + name);
        }
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.removeAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.removeAttributes called with: token=" + token + " type=" + type.getName() + " name=" + name + "\n\t attrNames=" + attrNames);
        }
        this.isValidType(type, "removeAttributes");
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getBinaryAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getBinaryAttributes called with: token=" + token + " type=" + type.getName() + " name=" + name + "\n\t attrNames=" + attrNames);
        }
        this.isValidType(type, "getBinaryAttributes");
        return Collections.EMPTY_MAP;
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.setBinaryAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.setBinaryAttributes called with: token=" + token + " type=" + type.getName() + " name=" + name + " isAdd=" + isAdd + "\n\t attributes=" + attributes);
        }
        this.isValidType(type, "setBinaryAttributes");
    }

    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getMembers: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getMembers: token=" + token + "IdType=" + type + ": name=" + name + ": membersType=" + membersType);
        }
        if (name == null || type == null || membersType == null) {
            debug.message("DatabaseRepo.getMembers: parameters type, name,membersTypeare can not be null, so returning empty set.IdType=" + type + ": name=" + name + ": membersType=" + membersType);
            return Collections.EMPTY_SET;
        }
        if (!membersType.equals(IdType.USER)) {
            debug.error("DatabaseRepo.getMembers: Groups do not support membership for " + membersType.getName());
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, membersType.getName(), type.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        Set members = null;
        if (type.equals(IdType.USER)) {
            debug.error("DatabaseRepo.getMembers: Membership operation is not supported for Users");
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        if (!type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, IdOperation.READ.getName(), type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        members = this.dao.getMembers(name, this.membershipIdAttributeName);
        if (members == null) {
            members = Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getMembers: returning members=" + members);
        }
        return members;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getMemberships: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getMemberships called  token=" + token + " type=" + type + " name=" + name + "membershipType=" + membershipType);
        }
        if (name == null || type == null || membershipType == null) {
            debug.message("DatabaseRepo.getMemberships: parameters type, name,membersTypeare can not be null, so returning empty set.IdType=" + type + ": name=" + name + ": membershipType=" + membershipType);
            return Collections.EMPTY_SET;
        }
        Set groups = null;
        if (!type.equals(IdType.USER)) {
            debug.error("DatabaseRepo.getMemberships: Membership for identities other than Users is not allowed ");
            Object[] args = new Object[]{PLUGIN_CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (!membershipType.equals(IdType.GROUP)) {
            debug.error("DatabaseRepo.getMemberships: Membership for other types of entities not supported for Users");
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, type.getName(), membershipType.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        groups = this.dao.getMemberships(name, this.membershipIdAttributeName);
        if (groups == null) {
            groups = Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getMemberships: returning groups=" + groups);
        }
        return groups;
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.modifyMemberShip: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.modifyMemberShip called:  token=" + token + " type=" + type + " name=" + name + " members=" + members + " membersType= " + membersType + " operation=" + operation);
        }
        if (type == null || name == null) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.modifyMemberShip: parameters type and name can not be null. type=" + type + " name=" + name);
            }
            return;
        }
        if (operation != 1 && operation != 2) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.modifyMemberShip: parameter operation must have value equivalent to ADD or REMOVE. operation=" + operation);
            }
            return;
        }
        if (members == null || members.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.modifyMemberShip: Members set is empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (type.equals(IdType.USER)) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.modifyMemberShip: Memberhsip to users is not supported");
            }
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!membersType.equals(IdType.USER)) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.modifyMemberShip: A non-user type cannot  be made a member of any identity" + membersType.getName());
            }
            Object[] args = new Object[]{PLUGIN_CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (type.equals(IdType.GROUP)) {
            switch (operation) {
                case 1: {
                    this.dao.addMembersToGroup(members, name, this.membershipIdAttributeName);
                    break;
                }
                case 2: {
                    this.dao.deleteMembersFromGroup(members, name, this.membershipIdAttributeName);
                }
            }
        } else {
            debug.error("DatabaseRepo.modifyMemberShip: Memberships cannot bemodified for type= " + type.getName());
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, type.getName()};
            throw new IdRepoException("amIdRepo", "209", args);
        }
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.search: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo:search called with : token=" + token + " IdType=" + type + " pattern=" + pattern + " maxTime=" + maxTime + " maxResults=" + maxResults + " returnAttrs=" + returnAttrs + " filter= " + filterOp + " avPairs= " + avPairs + " recursive=" + recursive);
        }
        this.isValidType(type, "search");
        if (maxResults < 1) {
            maxResults = this.defaultSearchMaxResults;
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo:search changing value of maxResults to deafult, so now maxResults=" + maxResults);
            }
        }
        pattern = pattern.trim();
        Map<Object, Object> users = new HashMap();
        Set<String> attributesToFetch = null;
        if (returnAttrs == null) {
            if (type.equals(IdType.USER)) {
                attributesToFetch = this.userAtttributesAllowed;
            } else if (type.equals(IdType.GROUP)) {
                HashSet<String> groupAttrsAllowed = new HashSet<String>();
                groupAttrsAllowed.add(this.membershipIdAttributeName);
                attributesToFetch = groupAttrsAllowed;
            }
        } else if (returnAttrs.isEmpty()) {
            attributesToFetch = new HashSet<String>();
            if (type.equals(IdType.USER)) {
                attributesToFetch.add(this.userIDAttributeName);
            } else if (type.equals(IdType.GROUP)) {
                attributesToFetch.add(this.membershipIdAttributeName);
            }
        } else {
            attributesToFetch = returnAttrs;
        }
        String filterOpString = "NONE";
        if (filterOp == 0) {
            filterOpString = "OR";
        } else if (filterOp == 1) {
            filterOpString = "AND";
        }
        if ((pattern == null || pattern.length() == 0 || pattern.equals("*")) && (avPairs == null || avPairs.isEmpty())) {
            if (type.equals(IdType.USER)) {
                users = this.dao.search(this.userIDAttributeName, maxResults, "", attributesToFetch, filterOpString, avPairs);
            } else if (type.equals(IdType.GROUP)) {
                users = this.dao.searchForGroups(this.membershipIdAttributeName, maxResults, "", attributesToFetch, filterOpString, avPairs);
            }
        } else {
            String searchPattern = pattern.replaceAll("\\*", "%");
            HashMap<String, Set<String>> avPairsChanged = new HashMap<String, Set<String>>();
            if (avPairs != null && !avPairs.isEmpty()) {
                for (String key : avPairs.keySet()) {
                    if (key == null) continue;
                    Set values = (Set)avPairs.get(key);
                    HashSet<String> changedValues = new HashSet<String>();
                    if (values != null && !values.isEmpty()) {
                        for (String attrValue : values) {
                            if (attrValue != null && attrValue.contains("*")) {
                                attrValue = attrValue.replaceAll("\\*", "%");
                            }
                            changedValues.add(attrValue);
                        }
                    }
                    avPairsChanged.put(key, changedValues);
                }
            }
            if (type.equals(IdType.USER)) {
                users = this.dao.search(this.userIDAttributeName, maxResults, searchPattern, attributesToFetch, filterOpString, avPairsChanged);
            } else if (type.equals(IdType.GROUP)) {
                users = this.dao.searchForGroups(this.membershipIdAttributeName, maxResults, searchPattern, attributesToFetch, filterOpString, avPairsChanged);
            }
        }
        if (users == null) {
            return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
        }
        if (users.isEmpty()) {
            return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
        }
        Set allUserIds = users.keySet();
        if (returnAttrs != null && returnAttrs.isEmpty()) {
            users = new HashMap();
            Iterator usersIt = allUserIds.iterator();
            while (usersIt.hasNext()) {
                users.put(usersIt.next(), Collections.EMPTY_MAP);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.search: returning users= " + users);
        }
        return new RepoSearchResults(allUserIds, 0, users, type);
    }

    public Set getSupportedOperations(IdType type) {
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getSupportedOperations: supportedOps= " + supportedOps);
        }
        return (Set)supportedOps.get(type);
    }

    private static void loadDefaultSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.CREATE);
        opSet.add(IdOperation.DELETE);
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.SERVICE);
        supportedOps.put(IdType.USER, Collections.unmodifiableSet(opSet));
        HashSet op2Set = new HashSet(opSet);
        op2Set.remove(IdOperation.SERVICE);
        supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(op2Set));
        supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(op2Set));
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.loadDefaultSupportedOps: load defaults\n\t supportedOps=" + supportedOps);
        }
    }

    public Set getSupportedTypes() {
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getSupportedTypes: supported types supportedOps.keySet=" + supportedOps.keySet());
        }
        return supportedOps.keySet();
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.isExists: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.isExists: token=" + token + " IdType=" + type + " name= " + name);
        }
        this.isValidType(type, "isExists");
        boolean entryExists = true;
        Map userDetails = this.getAttributes(token, type, name);
        if (userDetails.isEmpty()) {
            entryExists = false;
        }
        return entryExists;
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.isActive: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.isActive: token=" + token + " IdType=" + type + " name= " + name);
        }
        this.isValidType(type, "isActive");
        Map attrMap = null;
        HashSet<String> attrNameSet = new HashSet<String>();
        attrNameSet.add(this.statusAttributeName);
        try {
            attrMap = this.getAttributes(token, type, name, attrNameSet);
        }
        catch (IdRepoException idrepoerr) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.isActive calling getAttributes got IdRepoException=" + idrepoerr);
            }
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.isActive: query results fecthed for name=" + name + " retrieved attrMap=" + attrMap);
        }
        if (attrMap == null || attrMap.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.isActive: the fetching of attributes  for user name=" + name + " got no results, either null or empty, which indicates" + " user does not exists, so considered inactive.");
            }
            return false;
        }
        if (this.alwaysActive) {
            return true;
        }
        Set activeValueSet = (Set)attrMap.get(this.statusAttributeName);
        if (activeValueSet == null || activeValueSet.isEmpty()) {
            return true;
        }
        boolean allValuesInactive = true;
        for (String activeVal : activeValueSet) {
            if (activeVal == null) {
                allValuesInactive = false;
                continue;
            }
            if (activeVal.equalsIgnoreCase(this.statusInActiveComparisonValue)) continue;
            allValuesInactive = false;
        }
        return !allValuesInactive;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.setActiveStatus: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.setActiveStatus method called with token=" + token + " IdType=" + type + " name= " + name + " active=" + active);
        }
        if (name == null || name.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.setActiveStatus: name is null or empty so can not set active status. name=" + name);
            }
            return;
        }
        this.isValidType(type, "setActiveStatus");
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>();
        if (active) {
            vals.add(this.statusActiveComparisonValue);
        } else {
            vals.add(this.statusInActiveComparisonValue);
        }
        attrs.put(this.statusAttributeName, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getFullyQualifiedName: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo:getFullyQualifiedName:  token=" + token + " IdType=" + type + " name=" + name);
        }
        if (name == null || name.length() == 0) {
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, ""};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        this.isValidType(type, "getFullyQualifiedName");
        RepoSearchResults results = this.search(token, type, name, 0, 2, null, true, -1, null, false);
        Set dns = results.getSearchResults();
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo:getFullyQualifiedName:  search results dns=" + dns);
        }
        if (dns == null || dns.size() != 1) {
            Object[] args = new String[]{PLUGIN_CLASS_NAME, name};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        String dbURL = this.dao.getDataSourceURL();
        String fqdn = dbURL + "/" + type.getName() + "/" + dns.iterator().next().toString();
        fqdn = fqdn.toLowerCase();
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo:getFullyQualifiedName:  about to return fqdn=" + fqdn);
        }
        return fqdn;
    }

    public boolean supportsAuthentication() {
        boolean AUTHN_ENABLED = true;
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo:supportsAuthentication:  authenticationEnabled=true");
        }
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.authenticate: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.authenticate method called with  credentials=" + credentials);
        }
        String username = null;
        String password = null;
        for (int i = 0; i < credentials.length; ++i) {
            char[] passwd;
            if (credentials[i] instanceof NameCallback) {
                username = ((NameCallback)credentials[i]).getName();
                if (!debug.messageEnabled()) continue;
                debug.message("DatabaseRepo.authenticate: username: " + username);
                continue;
            }
            if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
            password = new String(passwd);
            debug.message("DatabaseRepo.authenticate:authN passwd present");
        }
        if (username == null || password == null) {
            return false;
        }
        Map attrs = this.searchForAuthN(IdType.USER, username);
        if (attrs == null || attrs.isEmpty() || !attrs.containsKey(this.passwordAttributeName)) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.authenticate: did not found user.");
            }
            return false;
        }
        Set storedPasswords = (Set)attrs.get(this.passwordAttributeName);
        if (storedPasswords == null || storedPasswords.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.authenticate: no stored password");
            }
            return false;
        }
        String storedPassword = (String)storedPasswords.iterator().next();
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.authenticate: AuthN of " + username + "=" + password.equals(storedPassword));
        }
        return password.equals(storedPassword);
    }

    private Map searchForAuthN(IdType type, String userName) throws IdRepoException {
        Map attributes = null;
        try {
            attributes = this.getAttributes(null, type, userName);
            if (attributes != null || !attributes.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("DatabaseRepo.searchForAuthN: found " + type.getName() + " entry: " + userName);
                }
            } else if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.searchForAuthN: did not find " + type.getName() + " entry: " + userName);
            }
        }
        catch (SSOException ssoe) {
            // empty catch block
        }
        return attributes;
    }

    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.addListener called");
        }
        return 0;
    }

    public void removeListener() {
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.removeListener called");
        }
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.assignService: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.assignService called with:  token=" + token + " type=" + type.getName() + " name=" + name + " serviceName=" + serviceName + "\n\tSchema Type stype=" + stype + "\n\t attrMap=" + "=" + attrMap);
        }
        this.isValidType(type, "assignService");
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.unassignService: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.unassignService called with:  token=" + token + " type=" + type.getName() + " name=" + name + " serviceName=" + serviceName + "\n\t attrMap=" + "=" + attrMap);
        }
        this.isValidType(type, "unassignService");
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServicesAndOCs) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getAssignedServices: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getAssignedService called with: token=" + token + " type =" + type.getName() + " name=" + name + " mapOfServicesAndOCs=" + mapOfServicesAndOCs);
        }
        this.isValidType(type, "getAssignedServices");
        return Collections.EMPTY_SET;
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.modifyService: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.modifyService called with: token=" + token + " IdType=" + type + " name=" + name + " serviceName=" + serviceName + " SchemaType stype=" + sType + "\n\t attrMap=" + attrMap);
        }
        this.isValidType(type, "modifyService");
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getServiceAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getServiceAttributes called with: token=" + token + " type =" + type.getName() + " name=" + name + " serviceName=" + serviceName + " attrNames=" + attrNames);
        }
        this.isValidType(type, "getServiceAttributes");
        return Collections.EMPTY_MAP;
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("DatabaseRepo.getBinaryServiceAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("DatabaseRepo.getBinaryServiceAttributes called with: token=" + token + " type =" + type.getName() + " name=" + name + " serviceName=" + serviceName + " attrNames=" + attrNames);
        }
        this.isValidType(type, "getBinaryServiceAttributes");
        return Collections.EMPTY_MAP;
    }

    private void isValidType(IdType type, String methodName) throws IdRepoUnsupportedOpException {
        if (type == null || !supportedOps.keySet().contains(type)) {
            if (debug.messageEnabled()) {
                debug.message("DatabaseRepo.isValidType: method " + methodName + " was called with type=" + (type == null ? null : type.getName()) + " but this is an unsupported operation for this type of" + " user. So operation cannot be executed. Exception will be" + " thrown.");
            }
            Object[] args = new Object[]{PLUGIN_CLASS_NAME, IdOperation.SERVICE.getName(), type == null ? null : type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
    }
}

