/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ServiceTypeManager {
    private static ServiceTypeManager svtm = null;
    private static SSOToken token;
    private Map serviceTypes = Collections.synchronizedMap(new HashMap());
    private static Random random;
    private static boolean ssoadm;

    static ServiceTypeManager getServiceTypeManager() throws SSOException {
        if (svtm == null) {
            svtm = new ServiceTypeManager();
        }
        return svtm;
    }

    private ServiceTypeManager() throws SSOException {
        token = ServiceTypeManager.getSSOToken();
    }

    private ServiceTypeManager(PolicyManager pm) {
        token = pm.token;
    }

    public ServiceTypeManager(SSOToken token) throws SSOException {
        SSOTokenManager.getInstance().validateToken(token);
        ServiceTypeManager.token = token;
    }

    public Set getServiceTypeNames() throws SSOException, NoPermissionException {
        SSOTokenManager.getInstance().validateToken(token);
        try {
            ServiceManager sm = new ServiceManager(token);
            Iterator items = sm.getServiceNames().iterator();
            HashSet<String> answer = new HashSet<String>();
            while (items.hasNext()) {
                String serviceName = (String)items.next();
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                    if (ssm.getPolicySchema() == null) continue;
                    answer.add(serviceName);
                }
                catch (Exception e) {
                    PolicyManager.debug.error("ServiceTypeManager.getServiceTypeNames:", (Throwable)e);
                }
            }
            return answer;
        }
        catch (SMSException se) {
            throw new NoPermissionException(se);
        }
    }

    public ServiceType getServiceType(String serviceTypeName) throws SSOException, NameNotFoundException {
        ServiceType st = (ServiceType)this.serviceTypes.get(serviceTypeName);
        if (st == null) {
            try {
                ServiceSchema policySchema = null;
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceTypeName, token);
                if (ssm == null || (policySchema = ssm.getPolicySchema()) == null) {
                    if (PolicyManager.debug.messageEnabled()) {
                        PolicyManager.debug.message("ServiceTypeManager::getServiceType " + serviceTypeName + " not found with policy privileges");
                    }
                    Object[] objs = new String[]{serviceTypeName};
                    throw new NameNotFoundException("amPolicy", "service_name_not_found", objs, serviceTypeName, 3);
                }
                st = new ServiceType(serviceTypeName, ssm, policySchema);
                this.serviceTypes.put(serviceTypeName, st);
            }
            catch (SMSException se) {
                PolicyManager.debug.error("In ServiceTypeManager::getServiceType " + serviceTypeName + " got SMS exception: ", (Throwable)se);
                throw new NameNotFoundException(se, serviceTypeName, 3);
            }
        }
        return st;
    }

    static SSOToken getSSOToken() throws SSOException {
        if (!SystemProperties.isServerMode() && token != null && !ssoadm) {
            return token;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (token == null) {
            throw new SSOException(new PolicyException("amPolicy", "invalid_admin", null, null));
        }
        return token;
    }

    static String generateRandomName() {
        StringBuffer sb = new StringBuffer(30);
        byte[] keyRandom = new byte[5];
        random.nextBytes(keyRandom);
        sb.append(System.currentTimeMillis()).toString();
        return sb.append(Base64.encode((byte[])keyRandom)).toString();
    }

    public static int getPolicyServiceRevisionNumber() throws PolicyException, SSOException, SMSException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("ServiceTypeManager.getPolicyServiceRevisionNumber:entering");
        }
        SSOToken token = ServiceTypeManager.getSSOToken();
        ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPolicyService", token);
        int revision = ssm.getRevisionNumber();
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("ServiceTypeManager.getPolicyServiceRevisionNumber:returning revision=" + revision);
        }
        return revision;
    }

    static {
        random = new Random();
        ssoadm = Boolean.valueOf(System.getProperty("ssoadm", "false"));
    }
}

