/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthenticateToServiceCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private Map properties;
    private String authenticateToService = null;
    private boolean realmEmpty = false;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    /*
     * Unable to fully structure code
     */
    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        allowed = false;
        requestAuthnServices = new HashSet<E>();
        if (env != null && env.get("requestAuthenticatedToServices") != null) {
            try {
                requestAuthnServices = (Set)env.get("requestAuthenticatedToServices");
                if (!AuthenticateToServiceCondition.DEBUG.messageEnabled()) ** GOTO lbl19
                AuthenticateToServiceCondition.DEBUG.message("At AuthenticateToServiceCondition.getConditionDecision(): requestAuthnServices from request = " + requestAuthnServices);
            }
            catch (ClassCastException e) {
                args = new String[]{"requestAuthenticatedToServices"};
                throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
            }
        } else if (token != null) {
            authenticatedServices = AMAuthUtils.getRealmQualifiedAuthenticatedServices(token);
            if (authenticatedServices != null) {
                requestAuthnServices.addAll(authenticatedServices);
            }
            if (AuthenticateToServiceCondition.DEBUG.messageEnabled()) {
                AuthenticateToServiceCondition.DEBUG.message("At AuthenticateToServiceCondition.getConditionDecision(): requestAuthnServices from ssoToken = " + requestAuthnServices);
            }
        }
lbl19:
        // 7 sources

        adviceMessages = new HashSet<String>(1);
        if (requestAuthnServices.contains(this.authenticateToService)) {
            allowed = true;
        } else if (this.realmEmpty) {
            for (String requestAuthnService : requestAuthnServices) {
                service = AMAuthUtils.getDataFromRealmQualifiedData(requestAuthnService);
                if (!this.authenticateToService.equals(service)) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            adviceMessages.add(this.authenticateToService);
            if (AuthenticateToServiceCondition.DEBUG.messageEnabled()) {
                AuthenticateToServiceCondition.DEBUG.message("At AuthenticateToServiceCondition.getConditionDecision():authenticateToService not satisfied = " + this.authenticateToService);
            }
        }
        if (AuthenticateToServiceCondition.DEBUG.messageEnabled()) {
            AuthenticateToServiceCondition.DEBUG.message("At AuthenticateToServiceCondition.getConditionDecision():authenticateToService = " + this.authenticateToService + "," + " requestAuthnServices = " + requestAuthnServices + ", " + " allowed = " + allowed);
        }
        advices = new HashMap<String, HashSet<String>>();
        if (!allowed) {
            advices.put("AuthenticateToServiceConditionAdvice", adviceMessages);
        }
        return new ConditionDecision(allowed, advices);
    }

    public Object clone() {
        AuthenticateToServiceCondition theClone = null;
        try {
            theClone = (AuthenticateToServiceCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
            theClone.authenticateToService = this.authenticateToService;
            theClone.realmEmpty = this.realmEmpty;
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = this.properties.keySet();
        if (!keySet.contains("AuthenticateToService")) {
            Object[] args = new String[]{"AuthenticateToService"};
            throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
        }
        for (String key : keySet) {
            if ("AuthenticateToService".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", args, null);
        }
        Set authnToServiceSet = null;
        try {
            authnToServiceSet = (Set)this.properties.get("AuthenticateToService");
        }
        catch (ClassCastException e) {
            Object[] args = new String[]{"requestAuthenticatedToServices"};
            throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
        }
        if (authnToServiceSet != null) {
            this.validateAuthnToServices(authnToServiceSet);
        }
        return true;
    }

    private boolean validateAuthnToServices(Set authnToServiceSet) throws PolicyException {
        String realm;
        if (authnToServiceSet.isEmpty()) {
            Object[] args = new String[]{"AuthenticateToService"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", args, null);
        }
        this.authenticateToService = null;
        Iterator authnToServiceSetIter = authnToServiceSet.iterator();
        try {
            this.authenticateToService = (String)authnToServiceSetIter.next();
        }
        catch (ClassCastException e) {
            Object[] args = new String[]{"AuthenticateToService"};
            throw new PolicyException("amPolicy", "property_is_not_a_String", args, null);
        }
        if (this.authenticateToService != null && ((realm = AMAuthUtils.getRealmFromRealmQualifiedData(this.authenticateToService)) == null || realm.length() == 0)) {
            this.realmEmpty = true;
        }
        return true;
    }

    static {
        propertyNames.add("AuthenticateToService");
    }
}

