/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AuthenticationServiceNameProvider;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;

public class AuthenticationServiceNameProviderImpl
implements AuthenticationServiceNameProvider {
    private static boolean initialized;
    private static HashSet authNmodules;
    private static Debug debug;

    public Set getAuthenticationServiceNames() {
        if (initialized) {
            return authNmodules;
        }
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", token);
            ServiceSchema schema = scm.getGlobalSchema();
            Set authenticators = (Set)schema.getAttributeDefaults().get("iplanet-am-auth-authenticators");
            for (String module : authenticators) {
                int index = module.lastIndexOf(".");
                if (index != -1) {
                    module = module.substring(index + 1);
                }
                String serviceName = "iPlanetAMAuth" + module + "Service";
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                    if (ssm.getOrganizationSchema() == null) continue;
                    authNmodules.add(serviceName);
                }
                catch (Exception e) {
                    serviceName = "sunAMAuth" + module + "Service";
                    try {
                        ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                        if (ssm.getOrganizationSchema() == null) continue;
                        authNmodules.add(serviceName);
                    }
                    catch (Exception ee) {}
                }
            }
            initialized = true;
        }
        catch (SMSException ex) {
            debug.error("AuthenticationServiceNameProviderImpl error", (Throwable)ex);
        }
        catch (SSOException ex) {
            debug.error("AuthenticationServiceNameProviderImpl error", (Throwable)((Object)ex));
        }
        return authNmodules;
    }

    static {
        authNmodules = new HashSet();
        debug = SMSEntry.debug;
    }
}

